/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu.skills;

import com.ibm.smarts.conversation.nlu.schema.intent.Intent;
import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.ColumnDataClassifier;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.stats.Counter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class IntentClassifier {
    private ColumnDataClassifier cdc;
    private Classifier<String, String> classifier;

    public IntentClassifier(Classifier<String, String> classifier, ColumnDataClassifier cdc) {
        this.cdc = cdc;
        this.classifier = classifier;
    }

    public List<Intent> classify(String sentence) {
        Datum<String, String> d = this.getDatum(sentence);
        Counter scores = ((LinearClassifier)this.classifier).probabilityOf(d);
        Set keys = scores.keySet();
        ArrayList<Intent> intents = new ArrayList<Intent>();
        for (String key : keys) {
            intents.add(new Intent(key, scores.getCount((Object)key)));
        }
        return intents;
    }

    private Datum<String, String> getDatum(String sentence) {
        return this.cdc.makeDatumFromLine("0\t" + sentence);
    }
}

