/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu.skills;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.skills.ITrainingCallback;
import com.ibm.smarts.conversation.nlu.skills.TrainingCancelledException;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import com.ibm.smarts.conversation.schema.training.TrainingStatus;
import com.ibm.smarts.conversation.training.SkillSamplesGenerator;
import edu.stanford.nlp.classify.ColumnDataClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelTrainer
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelTrainer.class);
    private String storeId;
    private JSONObject trainingData;
    private String activationPhrase;
    private String jarFilePath;
    private JSONObject blob;
    private String systemTempPath;
    private IConversationProvider provider;
    private ITrainingCallback iCallback;
    private boolean isCanceled = false;
    private TrainingStatus status = TrainingStatus.QUEUED;

    public ModelTrainer(String storeId, JSONObject trainingData, String activationPhrase, String jarFilePath, JSONObject blob, String systemTempPath, IConversationProvider provider, ITrainingCallback iCallback) {
        this.storeId = storeId;
        this.trainingData = trainingData;
        this.activationPhrase = activationPhrase;
        this.jarFilePath = jarFilePath;
        this.blob = blob;
        this.systemTempPath = systemTempPath;
        this.provider = provider;
        this.iCallback = iCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        if (this.isCanceled) {
            return;
        }
        LOGGER.info("Model Training {}: Starting", (Object)this.storeId);
        String tempFolderPath = null;
        try {
            this.updateStatus(TrainingStatus.INITIALIZING);
            if (StringUtils.isEmpty((CharSequence)this.systemTempPath)) {
                tempFolderPath = Files.createTempDirectory("skill", new FileAttribute[0]).toString();
            } else {
                Path temp = Paths.get(this.systemTempPath, new String[0]);
                Files.createDirectories(temp, new FileAttribute[0]);
                tempFolderPath = Files.createTempDirectory(temp, "skill", new FileAttribute[0]).toString();
            }
            LOGGER.debug("Model Training {}: Using folder {}", (Object)this.storeId, (Object)tempFolderPath);
            this.updateStatus(TrainingStatus.GENERATING_SAMPLES);
            String entitiesFilePath = Paths.get(tempFolderPath, "train_entities.tsv").toString();
            String intentsFilePath = Paths.get(tempFolderPath, "train_intents.tsv").toString();
            JSONObject systemDataDictionary = this.getSystemDataDictionaryFromResource();
            SkillSamplesGenerator.createTrainingData((JSONObject)systemDataDictionary, (JSONObject)this.trainingData, (String)entitiesFilePath, (String)intentsFilePath);
            if (this.isValidTariningFile(intentsFilePath)) {
                this.updateStatus(TrainingStatus.TRAINING_INTENT_MODEL);
                String intentModelPath = this.trainIntentModel(tempFolderPath);
                String entityModelPath = null;
                if (this.isValidTariningFile(entitiesFilePath)) {
                    this.updateStatus(TrainingStatus.TRAINING_ENTITY_MODEL);
                    entityModelPath = this.trainEntityModel(tempFolderPath);
                }
                this.updateStatus(TrainingStatus.TRAINING_COMPLETE);
                if (this.provider.saveSkillModels(intentModelPath, entityModelPath)) {
                    this.updateStatus(TrainingStatus.MODELS_SAVED);
                    this.iCallback.trainingCompleted(this.storeId, intentModelPath, entityModelPath, this.activationPhrase, this.jarFilePath, this.blob);
                }
            } else {
                throw new IllegalArgumentException("No intent training samples found");
            }
            if (tempFolderPath != null) {
                this.deleteFolder(tempFolderPath);
            }
        }
        catch (TrainingCancelledException e) {
            LOGGER.error(String.format("Training cancelled. Skill: %s while status was %s", this.storeId, this.status), (Throwable)e);
            if (tempFolderPath != null) {
                this.deleteFolder(tempFolderPath);
            }
        }
        catch (Exception e2) {
            LOGGER.error(String.format("Skill: %s failed while status was %s", this.storeId, this.status), (Throwable)e2);
            try {
                this.updateStatus(TrainingStatus.FAILED);
                this.iCallback.trainingFailed(this.storeId);
            }
            catch (TrainingCancelledException e22) {
                LOGGER.error(String.format("Training cancelled. Skill: %s while status was %s", this.storeId, this.status), (Throwable)e22);
            }
            if (tempFolderPath != null) {
                this.deleteFolder(tempFolderPath);
            }
            {
                catch (Throwable throwable) {
                    if (tempFolderPath != null) {
                        this.deleteFolder(tempFolderPath);
                    }
                    throw throwable;
                }
            }
        }
    }

    public String getStoreId() {
        return this.storeId;
    }

    public TrainingStatus getStatus() {
        return this.status;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public boolean isCancelled() {
        return this.isCanceled;
    }

    private void updateStatus(TrainingStatus status) throws TrainingCancelledException {
        if (this.isCanceled) {
            throw new TrainingCancelledException(this.storeId);
        }
        this.status = status;
        LOGGER.debug("Model Training {}: Change status to: {}", (Object)this.storeId, (Object)status);
        this.provider.updateSkillStatus(this.storeId, status);
    }

    private String trainIntentModel(String destFolderPath) throws IOException {
        String trainingFilePath = Paths.get(destFolderPath, "train_intents.tsv").toString();
        String modelFilePath = Paths.get(destFolderPath, "intent-model.ser.gz").toString();
        String propFilePath = this.copyPropFileFromResource(destFolderPath, "intents.prop", trainingFilePath, modelFilePath);
        String[] args = new String[]{"-prop", propFilePath};
        ColumnDataClassifier.main((String[])args);
        return modelFilePath;
    }

    private String trainEntityModel(String destFolderPath) throws Exception {
        String entityFilePath = Paths.get(destFolderPath, "train_entities.tsv").toString();
        String modelFilePath = Paths.get(destFolderPath, "ner-model.ser.gz").toString();
        String propFilePath = this.copyPropFileFromResource(destFolderPath, "model.prop", entityFilePath, modelFilePath);
        String[] args = new String[]{"-prop", propFilePath};
        CRFClassifier.main((String[])args);
        return modelFilePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFileFromResource(String fileName) {
        try (InputStream is = ModelTrainer.class.getResourceAsStream("/" + fileName);){
            String body;
            String string = body = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Skill: " + this.storeId, (Throwable)e);
            return null;
        }
    }

    private JSONObject getSystemDataDictionaryFromResource() throws IOException {
        String fileContent = this.getFileFromResource("data_dictionary.json");
        return JSONObject.parse((String)fileContent);
    }

    private String copyPropFileFromResource(String destFolderPath, String propFileName, String trainingFilePath, String modelFilePath) {
        String body = this.getFileFromResource(propFileName);
        if (body != null) {
            String escapedTrainingPath = Matcher.quoteReplacement(trainingFilePath.replace("\\", "\\\\"));
            String escapedModelPath = Matcher.quoteReplacement(modelFilePath.replace("\\", "\\\\"));
            body = body.replaceFirst("trainFile\\s?=.*?\n", "trainFile=" + escapedTrainingPath + "\n").replaceFirst("testFile\\s?=.*?\n", "testFile=" + escapedTrainingPath + "\n").replaceFirst("serializeTo\\s?=.*?\n", "serializeTo=" + escapedModelPath + "\n");
            try {
                File propFile = new File(destFolderPath, propFileName);
                FileUtils.writeStringToFile((File)propFile, (String)body);
                return propFile.getAbsolutePath();
            }
            catch (IOException e) {
                LOGGER.error("Skill: " + this.storeId, (Throwable)e);
            }
        }
        return null;
    }

    private void deleteFolder(String folderPath) {
        File folder = new File(folderPath);
        if (folder.exists()) {
            File[] files;
            for (File f : files = folder.listFiles()) {
                if (f.delete()) continue;
                LOGGER.error("Skill: {} couldn't delete {}", (Object)this.storeId, (Object)f.getAbsolutePath());
            }
            if (!folder.delete()) {
                LOGGER.error("Skill: {} couldn't delete {}", (Object)this.storeId, (Object)folder.getAbsolutePath());
            }
        }
    }

    private boolean isValidTariningFile(String filePath) {
        return new File(filePath).length() > 0L;
    }
}

