/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu.skills;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.skills.EntityClassifier;
import com.ibm.smarts.conversation.nlu.skills.IntentClassifier;
import java.util.HashMap;
import java.util.Map;

public class Skill {
    private String id;
    private String name;
    private String description;
    private String activationPhrase;
    private IntentClassifier intentClassifier;
    private EntityClassifier entityClassifier;
    private Class<?> sentenceHandlerClass;
    private Map<String, Class<?>> intentHandlerMap = new HashMap();
    private Map<String, String> entityInstanceOfMap = new HashMap<String, String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Skill(String id) {
        this.id = id;
    }

    public Skill(String id, String activationPhrase, IntentClassifier intentClassifier, EntityClassifier entityClassifier) {
        this.id = id;
        this.activationPhrase = activationPhrase;
        this.intentClassifier = intentClassifier;
        this.entityClassifier = entityClassifier;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setActivationPhrase(String activationPhrase) {
        this.activationPhrase = activationPhrase;
    }

    public Map<String, String> getEntityInstanceOfMap() {
        return this.entityInstanceOfMap;
    }

    public void setEntityInstanceOfMap(JSONObject entityMapObject) {
        for (Object e : entityMapObject.entrySet()) {
            Map.Entry entry = (Map.Entry)e;
            this.entityInstanceOfMap.put(String.valueOf(entry.getKey()), entry.getValue().toString());
        }
    }

    public String getActivationPhrase() {
        return this.activationPhrase;
    }

    public void setIntentClassifier(IntentClassifier intentClassifier) {
        this.intentClassifier = intentClassifier;
    }

    public IntentClassifier getIntentClassifier() {
        return this.intentClassifier;
    }

    public void setEntityClassifier(EntityClassifier entityClassifier) {
        this.entityClassifier = entityClassifier;
    }

    public EntityClassifier getEntityClassifier() {
        return this.entityClassifier;
    }

    public void registerIntentHandler(String id, Class<?> handler) {
        this.intentHandlerMap.put(id, handler);
    }

    public int getNumberOfRegisteredIntentHandlers() {
        return this.intentHandlerMap.size();
    }

    public Class<?> getIntentHandlerClass(String intent) {
        return this.intentHandlerMap.get(intent);
    }

    public Class<?> getSentenceHandlerClass() {
        return this.sentenceHandlerClass;
    }

    public void setSentenceHandlerClass(Class<?> sentenceHandlerClass) {
        this.sentenceHandlerClass = sentenceHandlerClass;
    }

    public boolean hasIntentModel() {
        return this.intentClassifier != null;
    }

    public void addExistingHandler(String intent, Class<?> handler) {
        this.intentHandlerMap.put(intent, handler);
    }
}

