/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu.skills;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.skills.EntityClassifier;
import com.ibm.smarts.conversation.nlu.skills.ISystemIntentHandlersRegistrar;
import com.ibm.smarts.conversation.nlu.skills.ITrainingCallback;
import com.ibm.smarts.conversation.nlu.skills.IntentClassifier;
import com.ibm.smarts.conversation.nlu.skills.Skill;
import com.ibm.smarts.conversation.nlu.skills.TrainingQueue;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.ColumnDataClassifier;
import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.ErasureUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkillsManager
implements ITrainingCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkillsManager.class);
    private Map<String, Skill> skillsById = new ConcurrentHashMap<String, Skill>();
    private Map<String, Skill> skillsByActivationPhrase = new ConcurrentHashMap<String, Skill>();
    private ColumnDataClassifier cdc;
    private TrainingQueue trainingQueue;
    private Class<?> intentHandlerClass;
    private Class<?> sentenceHandlerClass;
    private Class<?> defaultSentenceHandlerClass;
    private String defaultSkillId;
    private static final String INTENT_MODEL_NAME = "intent-model.ser.gz";
    private static final String NER_MODEL_NAME = "ner-model.ser.gz";
    private static final String INTENT_PROPS_FILE = "intents.prop";
    private static final String SYSTEM_NAME = "Cognos Assistant";
    private static final String SYSTEM_DESCRIPTION = "The System Assistant that can perform many tasks.";
    private static final String PREDEPLOYED_EXT_ID_PREFIX = "pre.";
    private static final String STORE_EXT_ID_PREFIX = "store.";
    private static final String SYSTEM_SKILL_ID = "pre.system";
    private static final String SYSTEM_ACTIVATION_PHRASE = "system";

    public SkillsManager(String configPath, String skillsPath, String tempPath, ISystemIntentHandlersRegistrar systemRegistrar) {
        this(configPath, skillsPath, tempPath, systemRegistrar, Collections.emptyList(), null);
    }

    public SkillsManager(String configPath, String skillsPath, String tempPath, ISystemIntentHandlersRegistrar systemRegistrar, List<String> disabledSkills, String defaultSkill) {
        this.cdc = new ColumnDataClassifier(Paths.get(configPath, INTENT_PROPS_FILE).toString());
        this.intentHandlerClass = systemRegistrar.getIntentHandlerClass();
        this.sentenceHandlerClass = systemRegistrar.getSentenceHandlerClass();
        this.defaultSentenceHandlerClass = systemRegistrar.getDefaultSentenceHandlerClass();
        this.loadPreDeployedSkills(configPath, skillsPath, systemRegistrar, disabledSkills);
        this.trainingQueue = new TrainingQueue(tempPath);
        this.defaultSkillId = PREDEPLOYED_EXT_ID_PREFIX + defaultSkill;
        if (defaultSkill == null || StringUtils.isBlank((CharSequence)defaultSkill) || this.skillsById.get(this.defaultSkillId) == null) {
            this.defaultSkillId = SYSTEM_SKILL_ID;
        }
    }

    public Skill getSkillById(String id) {
        return this.skillsById.get(id);
    }

    public Skill getSystemSkill() {
        return this.skillsById.get(SYSTEM_SKILL_ID);
    }

    public String getSystemSkillId() {
        return SYSTEM_SKILL_ID;
    }

    public String getDefaultSkillId() {
        return this.defaultSkillId;
    }

    public Skill getSkillByActivationPhrase(String activationPhrase) {
        if (!StringUtils.isEmpty((CharSequence)activationPhrase)) {
            return this.skillsByActivationPhrase.get(activationPhrase.toLowerCase());
        }
        return null;
    }

    public Collection<Skill> getAllSkills() {
        return this.skillsById.values();
    }

    public Set<String> getAllActivationPhrases() {
        return this.skillsByActivationPhrase.keySet();
    }

    private void add(Skill skill) {
        if (skill.getSentenceHandlerClass() != null && !StringUtils.isEmpty((CharSequence)skill.getActivationPhrase())) {
            this.skillsById.put(skill.getId(), skill);
            String activationPhrase = skill.getActivationPhrase();
            if (this.skillsByActivationPhrase.containsKey(activationPhrase)) {
                LOGGER.error("skill has duplicate activation phrase and cannot be added: {}", (Object)skill.getId());
            } else {
                this.skillsByActivationPhrase.put(activationPhrase.toLowerCase(), skill);
            }
            LOGGER.debug("Loaded skill {}", (Object)skill.getId());
        } else {
            LOGGER.error("skill doesn't have any intent handlers, sentence handler, and/or activation phrase: {}", (Object)skill.getId());
        }
    }

    private void loadPreDeployedSkills(String configPath, String skillsPath, ISystemIntentHandlersRegistrar systemRegistrar, List<String> disabledSkills) {
        IntentClassifier intentClassifier = new IntentClassifier(this.loadIntentClassifier(Paths.get(configPath, INTENT_MODEL_NAME).toString()), this.cdc);
        EntityClassifier entityClassifier = new EntityClassifier(this.loadEntityClassifier(Paths.get(configPath, NER_MODEL_NAME).toString()));
        Skill skill = new Skill(SYSTEM_SKILL_ID, SYSTEM_ACTIVATION_PHRASE, intentClassifier, entityClassifier);
        skill.setName(SYSTEM_NAME);
        skill.setDescription(SYSTEM_DESCRIPTION);
        systemRegistrar.registerIntentHandlers(skill);
        skill.setSentenceHandlerClass(this.defaultSentenceHandlerClass);
        this.add(skill);
        File skillsFolder = new File(skillsPath);
        if (skillsFolder.exists() && skillsFolder.isDirectory()) {
            for (File file : FileUtils.listFiles((File)skillsFolder, (String[])new String[]{"jar"}, (boolean)false)) {
                try {
                    String fileName = file.getName();
                    if (disabledSkills.contains(fileName)) continue;
                    JSONObject json = this.getSkillDefinition(file);
                    if (json == null) {
                        LOGGER.warn("Ignoring {} it doesn't have META-INF/skill.json", (Object)fileName);
                        continue;
                    }
                    skill = new Skill(PREDEPLOYED_EXT_ID_PREFIX + fileName);
                    if (!this.updateFromSkillDefinition(skill, json)) continue;
                    String sentenceHandlerClassName = (String)json.get((Object)"sentenceHandler");
                    if (StringUtils.isEmpty((CharSequence)sentenceHandlerClassName)) {
                        String modelsPath = (String)json.get((Object)"models");
                        JSONArray intents = (JSONArray)json.get((Object)"intents");
                        if (StringUtils.isEmpty((CharSequence)modelsPath)) {
                            LOGGER.error("Skill " + skill.getId() + " does not have a model associated with it");
                            continue;
                        }
                        String fullModelPath = Paths.get(skillsPath, modelsPath).toString();
                        if (!this.loadClassifiers(skill, fullModelPath)) continue;
                        this.registerSkillIntentHandlers(skill, intents);
                        if (skill.getNumberOfRegisteredIntentHandlers() > 0) {
                            skill.setSentenceHandlerClass(this.defaultSentenceHandlerClass);
                        }
                        this.add(skill);
                        continue;
                    }
                    this.registerSkillSentenceHandler(skill, sentenceHandlerClassName);
                    this.add(skill);
                }
                catch (IOException e) {
                    LOGGER.error(String.format("Failed to read jar file {} or its contents", file.getAbsolutePath()), (Throwable)e);
                }
            }
        }
    }

    private boolean updateFromSkillDefinition(Skill skill, JSONObject json) {
        String activationPhrase = (String)json.get((Object)"activationPhrase");
        JSONObject entityInstanceOfMap = (JSONObject)json.get((Object)"entity_instanceOf_map");
        if (StringUtils.isEmpty((CharSequence)activationPhrase)) {
            LOGGER.error("No activation phrase in META-INF/skill.json in skill: {}", (Object)skill.getId());
            return false;
        }
        skill.setActivationPhrase(activationPhrase);
        String name = (String)json.get((Object)"name");
        if (StringUtils.isEmpty((CharSequence)name)) {
            LOGGER.error("No name was specified in META-INF/skill.json in skill: {}", (Object)skill.getId());
            return false;
        }
        skill.setName(name);
        String description = (String)json.get((Object)"description");
        if (StringUtils.isEmpty((CharSequence)description)) {
            LOGGER.error("No description was specified in META-INF/skill.json in skill: {}", (Object)skill.getId());
            return false;
        }
        skill.setDescription(description);
        if (entityInstanceOfMap != null && !entityInstanceOfMap.isEmpty()) {
            skill.setEntityInstanceOfMap(entityInstanceOfMap);
        }
        return true;
    }

    private boolean loadClassifiers(Skill skill, String modelsFolder) {
        String intentModelPath = Paths.get(modelsFolder, INTENT_MODEL_NAME).toString();
        String entityModelPath = Paths.get(modelsFolder, NER_MODEL_NAME).toString();
        return this.loadClassifiers(skill, intentModelPath, entityModelPath);
    }

    private boolean loadClassifiers(Skill skill, String intentModelPath, String entityModelPath) {
        AbstractSequenceClassifier<CoreLabel> entityClassifier;
        Classifier<String, String> intentClassifier = this.loadIntentClassifier(intentModelPath);
        if (intentClassifier == null) {
            return false;
        }
        skill.setIntentClassifier(new IntentClassifier(intentClassifier, this.cdc));
        if (entityModelPath != null && (entityClassifier = this.loadEntityClassifier(entityModelPath)) != null) {
            skill.setEntityClassifier(new EntityClassifier(entityClassifier, skill.getEntityInstanceOfMap()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Classifier<String, String> loadIntentClassifier(String modelPath) {
        ObjectInputStream ois = null;
        try {
            Classifier classifier;
            ois = IOUtils.readStreamFromString((String)modelPath);
            Classifier classifier2 = classifier = (Classifier)ErasureUtils.uncheckedCast((Object)ois.readObject());
            return classifier2;
        }
        catch (IOException classifier) {
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing an intent model in: " + modelPath, (Throwable)e);
        }
        finally {
            IOUtils.closeIgnoringExceptions((Closeable)ois);
        }
        return null;
    }

    private AbstractSequenceClassifier<CoreLabel> loadEntityClassifier(String modelPath) {
        if (new File(modelPath).exists()) {
            try {
                return CRFClassifier.getClassifier((String)modelPath);
            }
            catch (Exception e) {
                LOGGER.error("Error deserializing ner model: " + modelPath, (Throwable)e);
            }
        }
        return null;
    }

    private void registerSkillIntentHandlers(Skill skill, JSONArray intents) {
        if (intents != null && !intents.isEmpty()) {
            this.loadAndRegisterIntents(skill, intents);
        }
    }

    private JSONObject getSkillDefinition(File file) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            ZipEntry jarEntry = jarFile.getEntry("META-INF/skill.json");
            if (jarEntry != null) {
                JSONObject json;
                JSONObject jSONObject = json = JSONObject.parse((InputStream)jarFile.getInputStream(jarEntry));
                return jSONObject;
            }
            LOGGER.error("Missing META-INF/skill.json in Jar file: {}", (Object)file.getAbsolutePath());
        }
        return null;
    }

    private boolean loadAndRegisterIntents(Skill skill, JSONArray intents) {
        for (Object obj : intents) {
            String className;
            JSONObject intent = (JSONObject)obj;
            String intentName = (String)intent.get((Object)"id");
            if (this.loadAndRegisterIntent(skill, intentName, className = (String)intent.get((Object)"class"))) continue;
            return false;
        }
        return true;
    }

    private Class<?> getHandlerClass(String className, Class<?> baseClass) {
        try {
            Class<?> handler = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            if (baseClass.isAssignableFrom(handler)) {
                return handler;
            }
            LOGGER.error("{} handler class does not extend {}", (Object)className, (Object)baseClass.getName());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOGGER.error("Class not found for class: " + className, e);
        }
        return null;
    }

    private boolean loadAndRegisterIntent(Skill skill, String intentName, String className) {
        Class<?> handler = this.getHandlerClass(className, this.intentHandlerClass);
        if (handler != null) {
            skill.registerIntentHandler(intentName, handler);
            return true;
        }
        return false;
    }

    private boolean registerSkillSentenceHandler(Skill skill, String sentenceHandlerClassName) {
        Class<?> handler = this.getHandlerClass(sentenceHandlerClassName, this.sentenceHandlerClass);
        if (handler != null) {
            skill.setSentenceHandlerClass(handler);
            return true;
        }
        return false;
    }

    public void buildSkill(String storeId, JSONObject trainingData, String activationPhrase, String jarFilePath, JSONObject blob, IConversationProvider provider) {
        this.trainingQueue.train(storeId, trainingData, activationPhrase, jarFilePath, blob, provider, this);
    }

    @Override
    public synchronized void trainingCompleted(String storeId, String intentModelPath, String entityModelPath, String activationPhrase, String jarFilePath, JSONObject blob) {
        if (this.trainingQueue.contains(storeId)) {
            try {
                JSONObject json = this.getSkillDefinition(new File(jarFilePath));
                if (json != null) {
                    Skill skill = new Skill(STORE_EXT_ID_PREFIX + storeId);
                    if (this.loadClassifiers(skill, intentModelPath, entityModelPath)) {
                        this.updateFromSkillDefinition(skill, json);
                        String sentenceHandlerClassName = (String)json.get((Object)"sentenceHandler");
                        if (StringUtils.isEmpty((CharSequence)sentenceHandlerClassName)) {
                            JSONArray intents = (JSONArray)json.get((Object)"intents");
                            this.registerSkillIntentHandlers(skill, intents);
                            if (skill.getNumberOfRegisteredIntentHandlers() > 0) {
                                skill.setSentenceHandlerClass(this.defaultSentenceHandlerClass);
                            }
                        } else {
                            this.registerSkillSentenceHandler(skill, sentenceHandlerClassName);
                        }
                        if (!StringUtils.isEmpty((CharSequence)activationPhrase)) {
                            skill.setActivationPhrase(activationPhrase);
                        }
                        this.add(skill);
                    } else {
                        LOGGER.error("Can't load models for skill: {}", (Object)skill.getId());
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error(String.format("Failed to read jar file %s or its contents", new File(jarFilePath).getAbsolutePath()), (Throwable)e);
            }
            this.trainingQueue.removeByStoreId(storeId);
        }
    }

    @Override
    public void trainingFailed(String storeId) {
        this.trainingQueue.removeByStoreId(storeId);
    }

    public synchronized void deleteSkill(String storeId) {
        String skillId = STORE_EXT_ID_PREFIX + storeId;
        Skill skill = this.getSkillById(skillId);
        if (skill != null) {
            this.skillsByActivationPhrase.remove(skill.getActivationPhrase());
            this.skillsById.remove(skillId);
        }
        this.trainingQueue.cancelTraining(storeId);
    }

    public synchronized void updateSkill(String storeId, JSONObject trainingData, String activationPhrase, String jarFilePath, JSONObject blob, IConversationProvider provider) {
        String skillId = STORE_EXT_ID_PREFIX + storeId;
        Skill skill = this.getSkillById(skillId);
        if (skill != null) {
            this.skillsById.remove(skillId);
            this.skillsByActivationPhrase.remove(skill.getActivationPhrase());
        }
        this.trainingQueue.cancelTraining(storeId);
        this.trainingQueue.train(storeId, trainingData, activationPhrase, jarFilePath, blob, provider, this);
    }
}

