/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.nlu.skills;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.skills.ITrainingCallback;
import com.ibm.smarts.conversation.nlu.skills.ModelTrainer;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class TrainingQueue
extends ConcurrentLinkedQueue<ModelTrainer> {
    private Executor executor = Executors.newSingleThreadExecutor();
    private String tempPath;

    public TrainingQueue(String tempPath) {
        this.tempPath = tempPath;
    }

    public void train(String storeId, JSONObject trainingData, String activationPhrase, String jarFilePath, JSONObject blob, IConversationProvider provider, ITrainingCallback iCallback) {
        ModelTrainer trainer = new ModelTrainer(storeId, trainingData, activationPhrase, jarFilePath, blob, this.tempPath, provider, iCallback);
        super.add(trainer);
        this.executor.execute(trainer);
    }

    public void removeByStoreId(String storeId) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (!storeId.equals(((ModelTrainer)it.next()).getStoreId())) continue;
            it.remove();
            break;
        }
    }

    public void cancelTraining(String storeId) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ModelTrainer trainer = (ModelTrainer)it.next();
            if (!storeId.equals(trainer.getStoreId())) continue;
            trainer.cancel();
            it.remove();
            break;
        }
    }

    public boolean contains(String storeId) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (!storeId.equals(((ModelTrainer)it.next()).getStoreId())) continue;
            return true;
        }
        return false;
    }
}

