/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.skill.intent;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.ConversationNLUResponse;
import com.ibm.smarts.conversation.schema.ConversationRequest;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.action.Action;
import com.ibm.smarts.conversation.schema.action.ShowTextAction;
import com.ibm.smarts.conversation.schema.provider.IConversationProvider;
import com.ibm.smarts.conversation.skill.handler.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IntentHandler
extends Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntentHandler.class);
    private String intent;
    protected ConversationNLUResponse nluResponse;

    public void init(ConversationNLUResponse parseResponse, ConversationRequest request, IConversationProvider provider) {
        super.init(request, provider, parseResponse.getSkillId());
        this.intent = parseResponse.getSelectedIntent().getId();
        this.nluResponse = parseResponse;
    }

    @Override
    public void init(JSONObject json, ConversationRequest request, IConversationProvider provider) {
        super.init(json, request, provider);
        this.intent = (String)json.get((Object)"intent");
    }

    public String getIntent() {
        return this.intent;
    }

    public void setIntent(String intent) {
        this.intent = intent;
    }

    @Override
    protected JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put((Object)"intent", (Object)this.intent);
        return json;
    }

    public boolean isStandalone() {
        return false;
    }

    public Action getResumeAction(String redefinedEntity) {
        LOGGER.error("You don't have a method in your intent handler to handle re-processing of the sentence with the newly defined entities. Please implement getResumeAction in your intent handler.");
        return new ShowTextAction(Messages.getString((String)"SuggestionIntentHandler.Rephrase"));
    }
}

