/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConversationConfiguration.class);
    public static final String PROPERTIES_FILE_NAME = "conversation.properties";
    public static final String KEY_CONVERSATION_DISABLED_SKILLS = "smarts.conversation.disabledSkills";
    public static final String KEY_CONVERSATION_DEFAULT_SKILL = "smarts.conversation.defaultSkill";
    public static final String DEFAULT_CONVERSATION_DISABLED_SKILLS = "causal-discovery-skill-jar-with-dependencies.jar";
    public static final String DEFAULT_CONVERSATION_SKILL = "system";

    private static Properties getDefaultConfig() {
        Properties defaultConfig = new Properties();
        defaultConfig.setProperty(KEY_CONVERSATION_DISABLED_SKILLS, DEFAULT_CONVERSATION_DISABLED_SKILLS);
        defaultConfig.setProperty(KEY_CONVERSATION_DEFAULT_SKILL, DEFAULT_CONVERSATION_SKILL);
        return defaultConfig;
    }

    public static Properties getProperties(Path conversationConfigPath) {
        Properties conversationDefaults = ConversationConfiguration.getDefaultConfig();
        Path conversationPropsPath = Paths.get(conversationConfigPath.toString(), PROPERTIES_FILE_NAME);
        if (Files.exists(conversationPropsPath, new LinkOption[0])) {
            try (FileInputStream input = new FileInputStream(conversationPropsPath.toFile());){
                conversationDefaults.load(input);
                LOGGER.info("Total number of properties after load: {}.", (Object)conversationDefaults.size());
            }
            catch (IOException e) {
                LOGGER.warn("Could not load {}. Using system defaults.", (Object)PROPERTIES_FILE_NAME);
            }
        } else {
            LOGGER.info("{} not found. Using system defaults.", (Object)PROPERTIES_FILE_NAME);
        }
        return conversationDefaults;
    }
}

