/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.provider;

import com.ibm.bi.platform.moser.common.utils.MoserConnectionSpec;
import java.util.Properties;
import java.util.Set;

public abstract class ProviderProperties
extends Properties {
    private static final long serialVersionUID = -7588363126838830319L;
    private static final String CATALOG = "catalog";
    private static final String DATASOURCE = "dataSource";
    private static final String EXCLUDED_TABLES = "excludedTables";
    private static final String INCLUDED_TABLES = "includedTables";
    private static final String IMPORT_PF_KEYS = "importPrimaryForeignKeys";
    private static final String SCHEMA = "schema";
    private static final String TABLE = "table";
    private static final String CONNSPEC = "connSpec";
    private static final String PROPERTIES = "properties";
    private static final Properties EMPTY_PROPS = new Properties();

    public String getCatalog() {
        return this.getProperty(CATALOG);
    }

    public String getDataSource() {
        return this.getProperty(DATASOURCE);
    }

    public Set<String> getExcludedTables() {
        return (Set)this.get(EXCLUDED_TABLES);
    }

    public boolean getImportPrimaryForeignKeys() {
        return (Boolean)this.getOrDefault((Object)IMPORT_PF_KEYS, Boolean.TRUE);
    }

    public String getSchema() {
        return this.getProperty(SCHEMA);
    }

    public String getTable() {
        return this.getProperty(TABLE);
    }

    public void setCatalog(String catalog) {
        if (catalog != null) {
            this.setProperty(CATALOG, catalog);
        }
    }

    public void setDataSource(String dataSource) {
        this.setProperty(DATASOURCE, dataSource);
    }

    public void setExcludedTables(Set<String> excludedTables) {
        if (excludedTables != null) {
            this.put(EXCLUDED_TABLES, excludedTables);
        }
    }

    public void setImportPrimaryForeignKeys(boolean importPrimaryForeignKeys) {
        this.put(IMPORT_PF_KEYS, (Object)importPrimaryForeignKeys);
    }

    public void setSchema(String schema) {
        if (schema != null) {
            this.setProperty(SCHEMA, schema);
        }
    }

    public void setTable(String table) {
        this.setProperty(TABLE, table);
    }

    public Properties getProperties() {
        return (Properties)this.getOrDefault((Object)PROPERTIES, EMPTY_PROPS);
    }

    public void setProperties(Properties props) {
        this.put(PROPERTIES, props);
    }

    public void setConnectionSpec(MoserConnectionSpec connSpec) {
        this.put(CONNSPEC, connSpec);
    }

    public MoserConnectionSpec getConnectionSpec() {
        return (MoserConnectionSpec)this.get(CONNSPEC);
    }

    public Set<String> getIncludedTables() {
        return (Set)this.get(INCLUDED_TABLES);
    }

    public void setIncludedTables(Set<String> includedTables) {
        if (includedTables != null) {
            this.put(INCLUDED_TABLES, includedTables);
        }
    }
}

