/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.registry;

import com.ibm.smarts.ontology.registry.Concept;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ConceptsJsonObjectComparator {
    private static final String COMPARE_CURRENT_AND_NEW_MESSAGE = "  %s Current: %s%n  %s New: %s";
    private static StringBuilder builder = new StringBuilder();

    private ConceptsJsonObjectComparator() {
    }

    public static Result compare(Map<String, Map<String, Concept>> currentConcepts, Map<String, Map<String, Concept>> newConcepts) {
        ConceptsJsonObjectComparator.log("COMPARISON RESULTS", new Object[0]);
        ConceptsJsonObjectComparator.log("=============================================================", new Object[0]);
        boolean result = ConceptsJsonObjectComparator.doCompare(currentConcepts, newConcepts);
        ConceptsJsonObjectComparator.log("%n=============================================================", new Object[0]);
        ConceptsJsonObjectComparator.log(result ? "No diff found in two versions" : "There are differences in versions", new Object[0]);
        Result res = new Result(result, builder.toString());
        System.out.println(builder.toString());
        builder.delete(0, builder.length());
        return res;
    }

    private static boolean doCompare(Map<String, Map<String, Concept>> currentMultiDomainConcepts, Map<String, Map<String, Concept>> newMultiDomainConcepts) {
        KeyComparator keyComparator = new KeyComparator(currentMultiDomainConcepts.keySet(), newMultiDomainConcepts.keySet());
        if (keyComparator.isDiff()) {
            ConceptsJsonObjectComparator.logKeyDiff(keyComparator, "mutli domain map");
            ConceptsJsonObjectComparator.log("The current mutli domain map keys are different from the new multi domain map", new Object[0]);
            return false;
        }
        boolean isSame = true;
        for (String ontologyID : keyComparator.getInCommon()) {
            ConceptsJsonObjectComparator.log("%n--------------------------------------------------------", new Object[0]);
            ConceptsJsonObjectComparator.log("Ontology: %s", ontologyID);
            ConceptsJsonObjectComparator.log("--------------------------------------------------------", new Object[0]);
            Map<String, Concept> currentFlattenConcepts = currentMultiDomainConcepts.get(ontologyID);
            Map<String, Concept> newFlattenConcepts = newMultiDomainConcepts.get(ontologyID);
            if (currentFlattenConcepts == null || currentFlattenConcepts.isEmpty()) {
                ConceptsJsonObjectComparator.log("No concepts under ontology %s in current version", ontologyID);
                isSame = false;
                continue;
            }
            if (newFlattenConcepts == null || newFlattenConcepts.isEmpty()) {
                ConceptsJsonObjectComparator.log("No concepts under ontology %s in new version", ontologyID);
                isSame = false;
                continue;
            }
            if (ConceptsJsonObjectComparator.compareFlattenConcepts(currentFlattenConcepts, newFlattenConcepts)) continue;
            isSame = false;
        }
        return isSame;
    }

    private static boolean compareFlattenConcepts(Map<String, Concept> currentFlattenConcepts, Map<String, Concept> newFlattenConcepts) {
        KeyComparator keyComparator = new KeyComparator(currentFlattenConcepts.keySet(), newFlattenConcepts.keySet());
        if (keyComparator.isDiff()) {
            ConceptsJsonObjectComparator.logKeyDiff(keyComparator, "ontology domain map");
            ConceptsJsonObjectComparator.log("The current ontology domain map keys are different from the new ontology domain map", new Object[0]);
            return false;
        }
        boolean isSame = true;
        newFlattenConcepts = new HashMap<String, Concept>(newFlattenConcepts);
        for (String iri : keyComparator.getInCommon()) {
            Concept currentConcept = currentFlattenConcepts.get(iri);
            Concept newConcept = newFlattenConcepts.get(iri);
            if (newConcept == null) {
                ConceptsJsonObjectComparator.log("Concept %s is not found in the new version%n", iri);
                isSame = false;
                continue;
            }
            if (currentConcept == null) {
                ConceptsJsonObjectComparator.log("Concept %s is not found in the current version%n", iri);
                isSame = false;
                continue;
            }
            if (ConceptsJsonObjectComparator.compareConcept(currentConcept, newConcept)) continue;
            isSame = false;
        }
        return isSame;
    }

    private static boolean compareConcept(Concept currentConcept, Concept newConcept) {
        boolean isSame = ConceptsJsonObjectComparator.compareProperty(currentConcept.getName(), newConcept.getName(), "Name");
        isSame = ConceptsJsonObjectComparator.compareProperty(currentConcept.getOntologyID(), newConcept.getOntologyID(), "OntologyID") && isSame;
        isSame = ConceptsJsonObjectComparator.compareProperty(currentConcept.isVisible(), newConcept.isVisible(), "Visible") && isSame;
        isSame = ConceptsJsonObjectComparator.compareProperty(currentConcept.getProperties(), newConcept.getProperties(), "Properties") && isSame;
        isSame = ConceptsJsonObjectComparator.compareCollections(currentConcept.getChildren(), newConcept.getChildren(), "Children") && isSame;
        boolean bl = isSame = ConceptsJsonObjectComparator.compareCollections(currentConcept.getParents(), newConcept.getParents(), "Parent") && isSame;
        if (!isSame) {
            ConceptsJsonObjectComparator.log("Concept %s in the current version and the new version is different%n", currentConcept);
        }
        return isSame;
    }

    private static <T> boolean compareProperty(T currentProp, T newProp, String prop) {
        if (currentProp.equals(newProp)) {
            return true;
        }
        ConceptsJsonObjectComparator.log(COMPARE_CURRENT_AND_NEW_MESSAGE, prop, currentProp, prop, newProp);
        return false;
    }

    private static boolean compareCollections(Collection<Concept> currentProp, Collection<Concept> newProp, String prop) {
        Set<String> newIriSet;
        if (currentProp == null || newProp == null) {
            ConceptsJsonObjectComparator.log(COMPARE_CURRENT_AND_NEW_MESSAGE, prop, currentProp, prop, newProp);
            return false;
        }
        Set<String> currentIriSet = currentProp.stream().map(Concept::getIRI).collect(Collectors.toSet());
        KeyComparator keyComparator = new KeyComparator(currentIriSet, newIriSet = newProp.stream().map(Concept::getIRI).collect(Collectors.toSet()));
        if (keyComparator.isDiff()) {
            ConceptsJsonObjectComparator.logKeyDiff(keyComparator, prop);
            return false;
        }
        return true;
    }

    private static void log(String s, Object ... params) {
        builder.append(String.format(s, params));
        builder.append("\n");
    }

    private static void logKeyDiff(KeyComparator keyComparator, String context) {
        Set<String> currentOnly = keyComparator.getCurrentOnly();
        Set<String> newOnly = keyComparator.getNewOnly();
        Set<String> inCommon = keyComparator.getInCommon();
        ConceptsJsonObjectComparator.log("  Only in the current %s(%d):  \n  %s\n  Only in the new %s(%d):  \n  %s\n  Rest of (%d) are in both %s", context, currentOnly.size(), currentOnly, context, newOnly.size(), newOnly, inCommon.size(), context);
    }

    public static class Result {
        private boolean isSame;
        private String report;

        Result(boolean isSame, String report) {
            this.isSame = isSame;
            this.report = report;
        }

        public boolean isSame() {
            return this.isSame;
        }

        String getReport() {
            return this.report;
        }
    }

    static class KeyComparator {
        private Set<String> currentOnly;
        private Set<String> newOnly;
        private Set<String> inCommon;

        KeyComparator(Set<String> currentKeys, Set<String> newKeys) {
            this.split(new HashSet<String>(currentKeys), new HashSet<String>(newKeys));
        }

        private void split(Set<String> currentKeys, Set<String> newKeys) {
            HashSet<String> originalCurrent = new HashSet<String>(currentKeys);
            currentKeys.retainAll(newKeys);
            this.inCommon = currentKeys;
            originalCurrent.removeAll(this.inCommon);
            newKeys.removeAll(this.inCommon);
            this.currentOnly = originalCurrent;
            this.newOnly = newKeys;
        }

        Set<String> getCurrentOnly() {
            return this.currentOnly;
        }

        Set<String> getNewOnly() {
            return this.newOnly;
        }

        Set<String> getInCommon() {
            return this.inCommon;
        }

        boolean isDiff() {
            return !this.currentOnly.isEmpty() || !this.newOnly.isEmpty();
        }
    }
}

