/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.schema.resolution;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.entity.EntityFactory;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Constraint;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Resolution {
    private final List<Entity> entities = new ArrayList<Entity>();
    private final String moduleId;
    private final String datasetId;
    private final ColumnInfo columnInfo;
    private final String resolutionType;
    private String colId;
    private List<Constraint> constraints = new ArrayList<Constraint>();

    public Resolution(Entity nluEntity, String moduleId, String datasetId, ColumnInfo columnInfo, String resolutionType) {
        this.entities.add(nluEntity);
        this.moduleId = moduleId;
        this.datasetId = datasetId;
        this.columnInfo = columnInfo;
        this.resolutionType = resolutionType;
    }

    public Resolution(List<Entity> nluEntities, String moduleId, String datasetId, ColumnInfo columnInfo, String resolutionType) {
        this.entities.addAll(nluEntities);
        this.moduleId = moduleId;
        this.datasetId = datasetId;
        this.columnInfo = columnInfo;
        this.resolutionType = resolutionType;
    }

    public List<Entity> getEntities() {
        return Collections.unmodifiableList(this.entities);
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public String getColId() {
        return this.colId;
    }

    public void setColId(String colId) {
        this.colId = colId;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<Constraint> constraints) {
        this.constraints.addAll(constraints);
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public ColumnInfo getColumnInfo() {
        return this.columnInfo;
    }

    public String getResolutionType() {
        return this.resolutionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Resolution)) {
            return false;
        }
        Resolution that = (Resolution)o;
        return Objects.equals(this.getEntities(), that.getEntities()) && Objects.equals(this.getModuleId(), that.getModuleId()) && Objects.equals(this.getDatasetId(), that.getDatasetId()) && Objects.equals(this.getResolutionType(), that.getResolutionType()) && Objects.equals(this.getColId(), that.getColId()) && Objects.equals(this.getConstraints(), that.getConstraints());
    }

    public int hashCode() {
        return Objects.hash(this.getEntities(), this.getModuleId(), this.getDatasetId(), this.getResolutionType(), this.getColId(), this.getConstraints());
    }

    public String toString() {
        return "Resolution{entities=" + this.entities + ", moduleId='" + this.moduleId + '\'' + ", datasetId='" + this.datasetId + '\'' + ", resolutionType='" + this.resolutionType + '\'' + ", colId='" + this.colId + '\'' + ", constraints=" + this.constraints + '}';
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        JSONArray jsonEntities = new JSONArray();
        this.entities.forEach(e -> jsonEntities.add((Object)e.toJSON()));
        json.put((Object)"entities", (Object)jsonEntities);
        json.put((Object)"moduleId", (Object)this.moduleId);
        json.put((Object)"datasetId", (Object)this.datasetId);
        if (this.columnInfo != null) {
            try {
                json.put((Object)"columnInfo", (Object)JAXBHelper.marshalToJSON((Object)this.columnInfo));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        json.put((Object)"resolutionType", (Object)this.resolutionType);
        json.put((Object)"colId", (Object)this.colId);
        if (!this.constraints.isEmpty()) {
            JSONArray jsonConstraints = new JSONArray();
            this.constraints.forEach(c -> jsonConstraints.add((Object)c.toJSONObject()));
            json.put((Object)"constraints", (Object)jsonConstraints);
        }
        return json;
    }

    public static Resolution fromJSONObject(JSONObject jsonObject) {
        JSONArray jsonEntityList = (JSONArray)jsonObject.get((Object)"entities");
        ArrayList<Entity> nluEntities = new ArrayList<Entity>();
        for (Object obj : jsonEntityList) {
            JSONObject object = (JSONObject)obj;
            Entity entity = EntityFactory.createEntityFromJSON((JSONObject)object);
            nluEntities.add(entity);
        }
        String moduleId = (String)jsonObject.get((Object)"moduleId");
        String datasetId = (String)jsonObject.get((Object)"datasetId");
        ColumnInfo columnInfo = null;
        String jsonColumnInfo = (String)jsonObject.get((Object)"columnInfo");
        if (jsonColumnInfo != null) {
            try {
                columnInfo = (ColumnInfo)JAXBHelper.unmarshalFromJSON(ColumnInfo.class, (String)jsonColumnInfo);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String resolutionType = (String)jsonObject.get((Object)"resolutionType");
        String colId = (String)jsonObject.get((Object)"colId");
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        JSONArray jsonConstraintList = (JSONArray)jsonObject.get((Object)"constraints");
        if (jsonConstraintList != null) {
            for (Object obj : jsonConstraintList) {
                Constraint constraint = Constraint.fromJSONObject((JSONObject)obj);
                constraints.add(constraint);
            }
        }
        Resolution resolution = new Resolution(nluEntities, moduleId, datasetId, columnInfo, resolutionType);
        resolution.setConstraints(constraints);
        resolution.setColId(colId);
        return resolution;
    }
}

