/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.schema.resolution;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.entity.EntityFactory;
import com.ibm.smarts.nlu.resolver.schema.resolution.SentenceResolution;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ResolutionResponse {
    private final String moduleId;
    private final List<Entity> nluEntities = new ArrayList<Entity>();
    private final SentenceResolution resolutionInModule;
    private final List<SentenceResolution> globalCandidates = new ArrayList<SentenceResolution>();
    private final List<Entity> unsupportedEntities = new ArrayList<Entity>();

    public ResolutionResponse(List<SentenceResolution> globalCandidates) {
        this.moduleId = null;
        this.resolutionInModule = null;
        this.globalCandidates.addAll(globalCandidates);
    }

    public List<Entity> getNluEntities() {
        return this.nluEntities;
    }

    public ResolutionResponse(String moduleId, List<Entity> nluEntities, SentenceResolution resolutionInModule, List<SentenceResolution> globalCandidates, List<Entity> unsupportedEntities) {
        this.moduleId = moduleId;
        this.nluEntities.addAll(nluEntities);
        this.resolutionInModule = resolutionInModule;
        if (globalCandidates != null) {
            this.globalCandidates.addAll(globalCandidates);
        }
        this.unsupportedEntities.addAll(unsupportedEntities);
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public SentenceResolution getResolutionInModule() {
        return this.resolutionInModule;
    }

    public List<SentenceResolution> getGlobalCandidates() {
        return this.globalCandidates;
    }

    public List<Entity> getUnsupportedEntities() {
        return this.unsupportedEntities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolutionResponse)) {
            return false;
        }
        ResolutionResponse that = (ResolutionResponse)o;
        return Objects.equals(this.getModuleId(), that.getModuleId()) && Objects.equals(this.getNluEntities(), that.getNluEntities()) && Objects.equals(this.getResolutionInModule(), that.getResolutionInModule()) && Objects.equals(this.getGlobalCandidates(), that.getGlobalCandidates()) && Objects.equals(this.getUnsupportedEntities(), that.getUnsupportedEntities());
    }

    public int hashCode() {
        return Objects.hash(this.getModuleId(), this.getNluEntities(), this.getResolutionInModule(), this.getGlobalCandidates(), this.getUnsupportedEntities());
    }

    public String toString() {
        return "ResolutionResponse{moduleId='" + this.moduleId + '\'' + ", nluEntities=" + this.nluEntities + ", resolutionInModule=" + this.resolutionInModule + ", globalCandidates=" + this.globalCandidates + ", unsupportedEntities=" + this.unsupportedEntities + '}';
    }

    private JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        json.put((Object)"moduleId", (Object)this.moduleId);
        if (this.resolutionInModule != null) {
            json.put((Object)"resolutionInModule", (Object)this.resolutionInModule.toJSONObject());
        }
        JSONArray jsonGlobalCandidates = new JSONArray();
        this.globalCandidates.forEach(g -> jsonGlobalCandidates.add((Object)g.toJSONObject()));
        json.put((Object)"globalCandidates", (Object)jsonGlobalCandidates);
        JSONArray jsonEntities = new JSONArray();
        this.unsupportedEntities.forEach(e -> jsonEntities.add((Object)e.toJSON()));
        json.put((Object)"unsupportedEntities", (Object)jsonEntities);
        JSONArray jsonnluEntities = new JSONArray();
        this.nluEntities.forEach(e -> jsonnluEntities.add((Object)e.toJSON()));
        json.put((Object)"nluEntities", (Object)jsonnluEntities);
        return json;
    }

    public String toJSON() {
        JSONObject jsonObject = this.toJSONObject();
        return jsonObject.toString();
    }

    public static ResolutionResponse fromJSONObject(JSONObject jsonObject) {
        String moduleId = (String)jsonObject.get((Object)"moduleId");
        JSONObject jsonResolutionInModule = (JSONObject)jsonObject.get((Object)"resolutionInModule");
        SentenceResolution resolutionInModule = null;
        if (jsonResolutionInModule != null) {
            resolutionInModule = SentenceResolution.fromJSONObject(jsonResolutionInModule);
        }
        ArrayList<SentenceResolution> globalCandidates = new ArrayList<SentenceResolution>();
        JSONArray jsonGlobalCandidates = (JSONArray)jsonObject.get((Object)"globalCandidates");
        if (jsonGlobalCandidates != null) {
            for (Object obj : jsonGlobalCandidates) {
                SentenceResolution resolution = SentenceResolution.fromJSONObject((JSONObject)obj);
                globalCandidates.add(resolution);
            }
        }
        ArrayList<Entity> unsupportedEntities = new ArrayList<Entity>();
        JSONArray jsonUnsupportedEntities = (JSONArray)jsonObject.get((Object)"unsupportedEntities");
        if (jsonUnsupportedEntities != null) {
            for (Object obj : jsonUnsupportedEntities) {
                Entity entity = EntityFactory.createEntityFromJSON((JSONObject)((JSONObject)obj));
                unsupportedEntities.add(entity);
            }
        }
        ArrayList<Entity> nluEntities = new ArrayList<Entity>();
        JSONArray jsonNluEntities = (JSONArray)jsonObject.get((Object)"nluEntities");
        if (jsonNluEntities != null) {
            for (Object obj : jsonNluEntities) {
                Entity entity = EntityFactory.createEntityFromJSON((JSONObject)((JSONObject)obj));
                nluEntities.add(entity);
            }
        }
        return new ResolutionResponse(moduleId, nluEntities, resolutionInModule, globalCandidates, unsupportedEntities);
    }
}

