/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.schema.resolution;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.entity.EntityFactory;
import com.ibm.smarts.nlu.resolver.schema.resolution.Resolution;
import com.ibm.smarts.nlu.resolver.schema.resolution.UnResolvedEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SentenceResolution {
    private final String moduleId;
    private final String sentence;
    private final List<Entity> nluEntities;
    private final double confidence;
    private List<Resolution> resolutions = new ArrayList<Resolution>();
    private List<UnResolvedEntity> unresolved = new ArrayList<UnResolvedEntity>();
    private boolean isUnjoinable = false;

    public SentenceResolution(String moduleId, String sentence, List<Entity> nluEntities, double confidence) {
        this.moduleId = moduleId;
        this.sentence = sentence;
        this.nluEntities = nluEntities;
        this.confidence = confidence;
    }

    public SentenceResolution(String moduleId, String sentence, List<Entity> nluEntities, double confidence, boolean isJoinable) {
        this(moduleId, sentence, nluEntities, confidence);
        this.isUnjoinable = isJoinable;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getSentence() {
        return this.sentence;
    }

    public List<Entity> getNluEntities() {
        return this.nluEntities;
    }

    public List<UnResolvedEntity> getUnresolved() {
        return this.unresolved;
    }

    public void addNluResolutions(List<Resolution> resolutions) {
        this.resolutions.addAll(resolutions);
    }

    public List<Resolution> getResolutions() {
        return this.resolutions;
    }

    public void setUnresolved(List<UnResolvedEntity> unresolved) {
        this.unresolved = unresolved;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public boolean isUnjoinable() {
        return this.isUnjoinable;
    }

    public void setUnjoinable(boolean unjoinable) {
        this.isUnjoinable = unjoinable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SentenceResolution)) {
            return false;
        }
        SentenceResolution that = (SentenceResolution)o;
        return Double.compare(that.getConfidence(), this.getConfidence()) == 0 && this.isUnjoinable() == that.isUnjoinable() && Objects.equals(this.getModuleId(), that.getModuleId()) && Objects.equals(this.getSentence(), that.getSentence()) && Objects.equals(this.getNluEntities(), that.getNluEntities()) && Objects.equals(this.getResolutions(), that.getResolutions()) && Objects.equals(this.getUnresolved(), that.getUnresolved());
    }

    public int hashCode() {
        return Objects.hash(this.getModuleId(), this.getSentence(), this.getNluEntities(), this.getConfidence(), this.getResolutions(), this.getUnresolved(), this.isUnjoinable());
    }

    public String toString() {
        return "SentenceResolution{moduleId='" + this.moduleId + '\'' + ", sentence='" + this.sentence + '\'' + ", nluEntities=" + this.nluEntities + ", confidence=" + this.confidence + ", resolutions=" + this.resolutions + ", unresolved=" + this.unresolved + '}';
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        json.put((Object)"moduleId", (Object)this.moduleId);
        json.put((Object)"sentence", (Object)this.sentence);
        if (this.nluEntities != null) {
            JSONArray jsonEntities = new JSONArray();
            this.nluEntities.forEach(e -> jsonEntities.add((Object)e.toJSON()));
            json.put((Object)"entities", (Object)jsonEntities);
        }
        json.put((Object)"confidence", (Object)this.confidence);
        if (this.resolutions != null) {
            JSONArray jsonResolutions = new JSONArray();
            this.resolutions.forEach(r -> jsonResolutions.add((Object)r.toJSONObject()));
            json.put((Object)"resolutions", (Object)jsonResolutions);
        }
        if (this.unresolved != null) {
            JSONArray jsonUnresolved = new JSONArray();
            this.unresolved.forEach(e -> jsonUnresolved.add((Object)e.toJSONObject()));
            json.put((Object)"unresolved", (Object)jsonUnresolved);
        }
        json.put((Object)"isUnjoinable", (Object)this.isUnjoinable);
        return json;
    }

    public static SentenceResolution fromJSONObject(JSONObject jsonObject) {
        String moduleId = (String)jsonObject.get((Object)"moduleId");
        String sentence = (String)jsonObject.get((Object)"sentence");
        ArrayList<Entity> nluEntities = new ArrayList<Entity>();
        JSONArray jsonEntityList = (JSONArray)jsonObject.get((Object)"entities");
        for (Object obj : jsonEntityList) {
            Entity entity = EntityFactory.createEntityFromJSON((JSONObject)((JSONObject)obj));
            nluEntities.add(entity);
        }
        double confidence = (Double)jsonObject.get((Object)"confidence");
        JSONArray jsonResolutionList = (JSONArray)jsonObject.get((Object)"resolutions");
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        for (Object obj : jsonResolutionList) {
            Resolution resolution = Resolution.fromJSONObject((JSONObject)obj);
            resolutions.add(resolution);
        }
        ArrayList<UnResolvedEntity> unresolved = new ArrayList<UnResolvedEntity>();
        JSONArray jsonUnresolvedList = (JSONArray)jsonObject.get((Object)"unresolved");
        for (Object obj : jsonUnresolvedList) {
            unresolved.add(UnResolvedEntity.fromJSONObject((JSONObject)obj));
        }
        boolean isUnjoinable = false;
        if (jsonObject.get((Object)"isUnjoinable") != null) {
            isUnjoinable = (Boolean)jsonObject.get((Object)"isUnjoinable");
        }
        SentenceResolution sentenceResolution = new SentenceResolution(moduleId, sentence, nluEntities, confidence, isUnjoinable);
        sentenceResolution.addNluResolutions(resolutions);
        sentenceResolution.setUnresolved(unresolved);
        return sentenceResolution;
    }
}

