/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.schema.resolution;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.entity.EntityFactory;
import com.ibm.smarts.nlu.resolver.schema.resolution.UnResolvedReason;
import java.util.Objects;

public class UnResolvedEntity {
    private Entity unresolved;
    private Entity relatedEntity;
    private String relatedEntityResolution;
    private UnResolvedReason reason;

    public UnResolvedEntity(Entity unresolved) {
        this.unresolved = unresolved;
        this.reason = UnResolvedReason.UNKNOWN_ENTITY;
    }

    public UnResolvedEntity(Entity unresolved, Entity relatedEntity, String relatedEntityResolution, UnResolvedReason reason) {
        this.unresolved = unresolved;
        this.relatedEntity = relatedEntity;
        this.relatedEntityResolution = relatedEntityResolution;
        this.reason = reason;
    }

    public Entity getUnresolvedEntity() {
        return this.unresolved;
    }

    public void setUnresolvedEntity(Entity unresolvedEntity) {
        this.unresolved = unresolvedEntity;
    }

    public Entity getRelatedEntity() {
        return this.relatedEntity;
    }

    public void setRelatedEntity(Entity relatedEntity) {
        this.relatedEntity = relatedEntity;
    }

    public UnResolvedReason getReason() {
        return this.reason;
    }

    public void setReason(UnResolvedReason reason) {
        this.reason = reason;
    }

    public String getRelatedEntityResolution() {
        return this.relatedEntityResolution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnResolvedEntity)) {
            return false;
        }
        UnResolvedEntity that = (UnResolvedEntity)o;
        return Objects.equals(this.unresolved, that.unresolved) && Objects.equals(this.getRelatedEntity(), that.getRelatedEntity()) && Objects.equals(this.getRelatedEntityResolution(), that.getRelatedEntityResolution()) && this.getReason() == that.getReason();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unresolved, this.getRelatedEntity(), this.getRelatedEntityResolution(), this.getReason()});
    }

    public String toString() {
        return "UnResolvedEntity{unresolved=" + this.unresolved + ", relatedEntity=" + this.relatedEntity + ", relatedEntityResolution='" + this.relatedEntityResolution + '\'' + ", reason=" + (Object)((Object)this.reason) + '}';
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        if (this.unresolved != null) {
            json.put((Object)"unresolved", (Object)this.unresolved.toJSON());
        }
        if (this.relatedEntity != null) {
            json.put((Object)"relatedEntity", (Object)this.relatedEntity.toJSON());
        }
        if (this.relatedEntityResolution != null) {
            json.put((Object)"relatedEntityResolution", (Object)this.relatedEntityResolution);
        }
        json.put((Object)"reason", (Object)this.reason.name());
        return json;
    }

    public static UnResolvedEntity fromJSONObject(JSONObject jsonObject) {
        JSONObject unresolved = (JSONObject)jsonObject.get((Object)"unresolved");
        Entity unresolvedEntity = null;
        if (unresolved != null) {
            unresolvedEntity = EntityFactory.createEntityFromJSON((JSONObject)unresolved);
        }
        JSONObject related = (JSONObject)jsonObject.get((Object)"relatedEntity");
        Entity relatedEntity = null;
        if (related != null) {
            relatedEntity = EntityFactory.createEntityFromJSON((JSONObject)related);
        }
        String relatedEntityResolution = (String)jsonObject.get((Object)"relatedEntityResolution");
        String reason = (String)jsonObject.get((Object)"reason");
        UnResolvedReason unResolvedReason = UnResolvedReason.valueOf(reason);
        return new UnResolvedEntity(unresolvedEntity, relatedEntity, relatedEntityResolution, unResolvedReason);
    }
}

