/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.entity.EntityFactory;
import com.ibm.smarts.conversation.nlu.schema.intent.Aggregator;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Constraint;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.ConstraintType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class Aggregation
extends Constraint {
    private static final EnumSet<Aggregator> measureAggregations = EnumSet.of(Aggregator.AVG, new Aggregator[]{Aggregator.MIN, Aggregator.MAX, Aggregator.SUM, Aggregator.COUNT, Aggregator.COUNT_DISTINCT});
    private static final EnumSet<Aggregator> categoricalAggregations = EnumSet.of(Aggregator.COUNT, Aggregator.COUNT_DISTINCT);
    private Aggregator aggregator;

    public Aggregation(Entity entity, Aggregator aggregator) {
        super(entity, ConstraintType.AGGREGATION);
        this.aggregator = aggregator;
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public static Set<Aggregator> getMeasureAgg() {
        return measureAggregations;
    }

    public static Set<Aggregator> getCategoricalAgg() {
        return categoricalAggregations;
    }

    public void setAggregator(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Aggregation)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Aggregation that = (Aggregation)o;
        return this.getAggregator() == that.getAggregator();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAggregator());
    }

    @Override
    public String toString() {
        return "Aggregation{aggregator=" + this.aggregator + '}';
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject json = super.toJSONObject();
        json.put((Object)"aggregator", (Object)this.aggregator.name());
        return json;
    }

    public static Constraint fromJSONObject(JSONObject jsonObject) {
        Aggregator aggregator = Aggregator.fromName((String)((String)jsonObject.get((Object)"aggregator")));
        JSONArray jsonEntityList = (JSONArray)jsonObject.get((Object)"entities");
        ArrayList<Entity> nluEntities = new ArrayList<Entity>();
        for (Object obj : jsonEntityList) {
            JSONObject object = (JSONObject)obj;
            Entity entity = EntityFactory.createEntityFromJSON((JSONObject)object);
            nluEntities.add(entity);
        }
        return new Aggregation((Entity)nluEntities.get(0), aggregator);
    }
}

