/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Aggregation;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.ConstraintType;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Expression;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Membership;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.OrderBy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Constraint {
    protected final List<Entity> entities = new ArrayList<Entity>();
    protected final ConstraintType constraintType;

    public Constraint(Entity entity, ConstraintType constraintType) {
        this.entities.add(entity);
        this.constraintType = constraintType;
    }

    public Constraint(List<Entity> entities, ConstraintType constraintType) {
        this.entities.addAll(entities);
        this.constraintType = constraintType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Constraint)) {
            return false;
        }
        Constraint that = (Constraint)o;
        return Objects.equals(this.getEntities(), that.getEntities()) && this.getConstraintType() == that.getConstraintType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getEntities(), this.getConstraintType()});
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public String toString() {
        return "Constraint{entities=" + this.entities + ", constraintType=" + (Object)((Object)this.constraintType) + '}';
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        json.put((Object)"constraintType", (Object)this.constraintType.name());
        JSONArray jsonEntities = new JSONArray();
        this.entities.forEach(c -> jsonEntities.add((Object)c.toJSON()));
        json.put((Object)"entities", (Object)jsonEntities);
        return json;
    }

    public static Constraint fromJSONObject(JSONObject jsonObject) {
        String jsonType = (String)jsonObject.get((Object)"constraintType");
        if (jsonType != null) {
            ConstraintType type = ConstraintType.valueOf(jsonType);
            switch (type) {
                case EXPRESSION: {
                    return Expression.fromJSONObject(jsonObject);
                }
                case ORDER: {
                    return OrderBy.fromJSONObject(jsonObject);
                }
                case AGGREGATION: {
                    return Aggregation.fromJSONObject(jsonObject);
                }
                case MEMBERSHIP: {
                    return Membership.fromJSONObject(jsonObject);
                }
            }
        }
        return null;
    }
}

