/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.entity.EntityFactory;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Constraint;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.ConstraintType;
import java.util.ArrayList;
import java.util.Objects;

public class Expression
extends Constraint {
    private final Entity operator;
    private final Entity value;

    @JsonCreator
    public Expression(@JsonProperty(value="operator") Entity entity, @JsonProperty(value="value") Entity operator, Entity value) {
        super(entity, ConstraintType.EXPRESSION);
        this.operator = operator;
        this.value = value;
        this.entities.add(operator);
        this.entities.add(value);
    }

    public Entity getOperator() {
        return this.operator;
    }

    public Entity getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Expression)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Expression that = (Expression)o;
        return Objects.equals(this.getOperator(), that.getOperator()) && Objects.equals(this.getValue(), that.getValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getOperator(), this.getValue());
    }

    @Override
    public String toString() {
        return "Expression{operator=" + this.operator + ", value='" + this.value + '\'' + '}';
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject json = super.toJSONObject();
        json.put((Object)"operator", (Object)this.operator.toJSON());
        json.put((Object)"value", (Object)this.value.toJSON());
        return json;
    }

    public static Constraint fromJSONObject(JSONObject jsonObject) {
        JSONArray jsonEntityList = (JSONArray)jsonObject.get((Object)"entities");
        ArrayList<Entity> nluEntities = new ArrayList<Entity>();
        for (Object obj : jsonEntityList) {
            JSONObject object = (JSONObject)obj;
            Entity entity = EntityFactory.createEntityFromJSON((JSONObject)object);
            nluEntities.add(entity);
        }
        Entity operator = new Entity((JSONObject)jsonObject.get((Object)"operator"));
        Entity value = new Entity((JSONObject)jsonObject.get((Object)"value"));
        if (!nluEntities.isEmpty()) {
            return new Expression((Entity)nluEntities.get(0), operator, value);
        }
        return null;
    }
}

