/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.entity.EntityFactory;
import com.ibm.smarts.nlu.resolver.schema.StringUtil;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Constraint;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.ConstraintType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Membership
extends Constraint {
    private static final List<String> EXCLUSIONS = Arrays.asList("exclude", "excluding", "without", "outside", "not in", "not on", "not for", "not including", "not from");
    private static final List<String> INCLUSIONS = Arrays.asList("in", "for", "on", "include", "including", "with", "inside", "from");
    private final List<String> members = new ArrayList<String>();
    private final boolean isInclusion;

    public static boolean isInclusionMembership(String sentence, Entity entity) {
        String subSentence = sentence.substring(0, (int)entity.getStart());
        boolean isInclusion = StringUtil.endsWithAnyPhrase(subSentence.trim(), EXCLUSIONS) ? false : (StringUtil.endsWithAnyPhrase(subSentence.trim(), INCLUSIONS) ? true : StringUtil.findMatchingKeyword(subSentence.trim(), EXCLUSIONS) == null);
        return isInclusion;
    }

    public Membership(List<Entity> entities, String sentence, List<String> members) {
        super(entities, ConstraintType.MEMBERSHIP);
        this.isInclusion = Membership.isInclusionMembership(sentence, entities.get(0));
        this.members.addAll(members);
    }

    public Membership(List<Entity> entities, List<String> members, boolean isInclusion) {
        super(entities, ConstraintType.MEMBERSHIP);
        this.isInclusion = isInclusion;
        this.members.addAll(members);
    }

    public boolean isInclusion() {
        return this.isInclusion;
    }

    public List<String> getMembers() {
        return this.members;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Membership)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Membership that = (Membership)o;
        return this.isInclusion() == that.isInclusion() && Objects.equals(this.getMembers(), that.getMembers());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMembers(), this.isInclusion());
    }

    @Override
    public String toString() {
        return super.toString() + "Membership{members=" + this.members + ", isInclusion=" + this.isInclusion + '}';
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject json = super.toJSONObject();
        JSONArray jsonMembers = new JSONArray();
        jsonMembers.addAll(this.members);
        json.put((Object)"members", (Object)jsonMembers);
        json.put((Object)"isInclusion", (Object)this.isInclusion);
        return json;
    }

    public static Constraint fromJSONObject(JSONObject jsonObject) {
        JSONArray jsonEntityList = (JSONArray)jsonObject.get((Object)"entities");
        ArrayList<Entity> nluEntities = new ArrayList<Entity>();
        for (Object obj : jsonEntityList) {
            JSONObject object = (JSONObject)obj;
            Entity entity = EntityFactory.createEntityFromJSON((JSONObject)object);
            nluEntities.add(entity);
        }
        ArrayList<String> members = new ArrayList<String>();
        if (jsonObject.get((Object)"members") != null) {
            JSONArray jsonMembers = (JSONArray)jsonObject.get((Object)"members");
            for (Object obj : jsonMembers) {
                members.add((String)obj);
            }
        }
        boolean isInclusion = (Boolean)jsonObject.get((Object)"isInclusion");
        if (!nluEntities.isEmpty()) {
            return new Membership(nluEntities, members, isInclusion);
        }
        return null;
    }
}

