/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.entity.EntityFactory;
import com.ibm.smarts.conversation.nlu.schema.intent.Aggregator;
import com.ibm.smarts.conversation.nlu.schema.intent.Limit;
import com.ibm.smarts.conversation.nlu.schema.intent.Order;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Constraint;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.ConstraintType;
import java.util.ArrayList;
import java.util.Objects;

public class OrderBy
extends Constraint {
    private Order order;
    private String orderedById;
    private String orderedByName;
    private Aggregator orderByAggregator;
    private Limit limit = new Limit("10", false);
    private boolean limitWithoutOrder;

    public OrderBy(Entity entity, Order order, Limit limit) {
        super(entity, ConstraintType.ORDER);
        this.order = order;
        if (limit != null) {
            this.limit = limit;
        }
    }

    public OrderBy(Entity entity, Limit limit) {
        this(entity, Order.DESC, limit);
        this.limitWithoutOrder = true;
    }

    public OrderBy(Entity entity, Order order, String orderedById, String orderedByName, Aggregator orderByAggregator, Limit limit) {
        super(entity, ConstraintType.ORDER);
        this.order = order;
        this.orderedById = orderedById;
        this.orderedByName = orderedByName;
        this.orderByAggregator = orderByAggregator;
        if (limit != null) {
            this.limit = limit;
        }
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public String getOrderedById() {
        return this.orderedById;
    }

    public void setOrderedById(String orderedById) {
        this.orderedById = orderedById;
    }

    public Aggregator getOrderByAggregator() {
        return this.orderByAggregator;
    }

    public void setOrderByAggregator(Aggregator orderByAggregator) {
        this.orderByAggregator = orderByAggregator;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public boolean isLimitWithoutOrder() {
        return this.limitWithoutOrder;
    }

    public void setLimitWithoutOrder(boolean limitWithoutOrder) {
        this.limitWithoutOrder = limitWithoutOrder;
    }

    public String getOrderedByName() {
        return this.orderedByName;
    }

    public void setOrderedByName(String orderedByName) {
        this.orderedByName = orderedByName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrderBy)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrderBy orderBy = (OrderBy)o;
        return this.isLimitWithoutOrder() == orderBy.isLimitWithoutOrder() && this.getOrder() == orderBy.getOrder() && Objects.equals(this.getOrderedById(), orderBy.getOrderedById()) && Objects.equals(this.getOrderedByName(), orderBy.getOrderedByName()) && this.getOrderByAggregator() == orderBy.getOrderByAggregator() && (this.getLimit() == null && orderBy.getLimit() == null || this.getLimit().getNumber().equals(orderBy.getLimit().getNumber()) && this.getLimit().isPercent() == orderBy.getLimit().isPercent());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getOrder(), this.getOrderedById(), this.getOrderedByName(), this.getOrderByAggregator(), this.getLimit(), this.isLimitWithoutOrder());
    }

    @Override
    public String toString() {
        return "OrderBy{order=" + this.order + ", orderedById='" + this.orderedById + '\'' + ", orderedByName='" + this.orderedByName + '\'' + ", orderByAggregator=" + this.orderByAggregator + ", limit=" + this.limit + ", limitWithoutOrder=" + this.limitWithoutOrder + '}';
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject json = super.toJSONObject();
        json.put((Object)"order", (Object)this.order.name());
        if (this.orderedById != null) {
            json.put((Object)"orderedById", (Object)this.orderedById);
        }
        if (this.orderedByName != null) {
            json.put((Object)"orderedByName", (Object)this.orderedByName);
        }
        if (this.orderByAggregator != null) {
            json.put((Object)"orderByAggregator", (Object)this.orderByAggregator.name());
        }
        if (this.limit != null) {
            json.put((Object)"limit", (Object)this.limit.toJSON());
        }
        return json;
    }

    public static Constraint fromJSONObject(JSONObject jsonObject) {
        JSONArray jsonEntityList = (JSONArray)jsonObject.get((Object)"entities");
        ArrayList<Entity> nluEntities = new ArrayList<Entity>();
        for (Object obj : jsonEntityList) {
            JSONObject object = (JSONObject)obj;
            Entity entity = EntityFactory.createEntityFromJSON((JSONObject)object);
            nluEntities.add(entity);
        }
        Order order = Order.fromName((String)((String)jsonObject.get((Object)"order")));
        String orderedById = (String)jsonObject.get((Object)"orderedById");
        String orderedByName = (String)jsonObject.get((Object)"orderedByName");
        String jsonOrderByAggregator = (String)jsonObject.get((Object)"orderByAggregator");
        Aggregator orderByAggregator = null;
        if (jsonOrderByAggregator != null) {
            orderByAggregator = Aggregator.fromName((String)jsonOrderByAggregator);
        }
        JSONObject jsonLimit = (JSONObject)jsonObject.get((Object)"limit");
        Limit limit = null;
        if (jsonLimit != null) {
            limit = new Limit(jsonLimit);
        }
        if (!nluEntities.isEmpty()) {
            OrderBy orderBy = new OrderBy((Entity)nluEntities.get(0), order, orderedById, orderedByName, orderByAggregator, limit);
            nluEntities.remove(0);
            if (!nluEntities.isEmpty()) {
                orderBy.getEntities().addAll(nluEntities);
            }
            return orderBy;
        }
        return null;
    }
}

