/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.model.value.decor;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.smarts.model.value.decor.DecorationType;
import com.ibm.smarts.model.value.decor.PercentDecorationDeserializer;
import com.ibm.smarts.model.value.decor.PercentDecorationSerializer;
import com.ibm.smarts.model.value.decor.ValueDecoration;

@JsonSerialize(using=PercentDecorationSerializer.class)
@JsonDeserialize(using=PercentDecorationDeserializer.class)
public final class PercentDecoration
extends ValueDecoration {
    public static final String NAME = "PercentDecoration";
    public static final String FORMAT = "PercentDecoration(%s)";
    private char percentSymbol;

    public PercentDecoration(char percentSymbol) {
        this.percentSymbol = percentSymbol;
    }

    PercentDecoration() {
    }

    @Override
    public DecorationType getType() {
        return DecorationType.PERCENT;
    }

    @Override
    public boolean isPercent() {
        return true;
    }

    public char getPercentSymbol() {
        return this.percentSymbol;
    }

    public String toString() {
        return String.format(FORMAT, Character.toString(this.percentSymbol));
    }

    public int hashCode() {
        return this.getType().hashCode() + this.percentSymbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PercentDecoration)) {
            return false;
        }
        PercentDecoration other = (PercentDecoration)o;
        return this.percentSymbol == other.percentSymbol;
    }
}

