/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.combinations.generator.internal;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.combinations.generator.internal.CombinationIterable;
import com.ibm.smarts.combinations.generator.internal.DataCombinationStatus;
import com.ibm.smarts.combinations.generator.util.CombinationSpec;
import com.ibm.smarts.combinations.generator.util.ElementSpec;
import com.ibm.smarts.combinations.generator.util.FilteringSpec;
import com.ibm.smarts.combinations.generator.util.GroupSpec;
import com.ibm.smarts.combinations.generator.util.api.ICombinationSpec;
import com.ibm.smarts.combinations.generator.validator.spi.ValidatorService;
import com.ibm.smarts.core.exceptions.InternalException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItemComb {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItemComb.class);
    private ValidatorService validatorService;
    Map<Integer, Set<String>> sizeToConceptsMap = new HashMap<Integer, Set<String>>();

    public DataItemComb() {
        this.validatorService = ValidatorService.getInstance();
    }

    public List<CompletableFuture<DataCombinationStatus<IDataColumn>>> getCombsAsynch(List<IDataColumn> arr, FilteringSpec filter, int minCombSize, int maxCombSize, ExecutorService executor, long timeoutMS) {
        if (timeoutMS <= 0L) {
            throw new InternalException("Data Combinations timeout has to be greater than zero", new Object[0]);
        }
        if (maxCombSize > arr.size() || maxCombSize <= 0) {
            throw new InternalException("Max combination size " + maxCombSize + " has to to be between 1 and element's size " + arr.size(), new Object[0]);
        }
        if (minCombSize > arr.size() || minCombSize <= 0) {
            throw new InternalException("Max combination size " + minCombSize + " has to to be between 1 and element's size " + arr.size(), new Object[0]);
        }
        if (minCombSize > maxCombSize) {
            throw new InternalException("Min combination size " + minCombSize + " has to to be greater than or equal max combination size " + maxCombSize, new Object[0]);
        }
        ArrayList<CompletableFuture<DataCombinationStatus<IDataColumn>>> cfList = new ArrayList<CompletableFuture<DataCombinationStatus<IDataColumn>>>();
        ArrayList<CombinationIterable<IDataColumn>> combsList = new ArrayList<CombinationIterable<IDataColumn>>();
        for (int i = minCombSize; i <= maxCombSize; ++i) {
            combsList.add(new CombinationIterable<IDataColumn>(arr, i));
        }
        long startTime = System.currentTimeMillis();
        combsList.forEach(combs -> cfList.add(CompletableFuture.supplyAsync(() -> {
            ArrayList res = new ArrayList();
            Iterator combsIterator = combs.iterator();
            boolean isInterrupted = false;
            while (combsIterator.hasNext()) {
                List<IDataColumn> combsListRes = combsIterator.next();
                if (timeoutMS > 0L && System.currentTimeMillis() - startTime > timeoutMS) {
                    isInterrupted = true;
                    break;
                }
                if (!this.validateCombination(filter, combsListRes)) continue;
                res.add(combsListRes);
            }
            return new DataCombinationStatus(res, isInterrupted);
        }, executor)));
        return cfList;
    }

    private boolean validateCombination(FilteringSpec filter, List<IDataColumn> combination) {
        if (combination.stream().anyMatch(c -> c.getFlatListOfConcepts().isEmpty())) {
            return true;
        }
        if (filter != null && this.validateAgainstSpecs(filter, combination)) {
            return true;
        }
        if (this.validatorService.hasValidators()) {
            return this.validatorService.validate(combination);
        }
        return true;
    }

    private synchronized boolean validateAgainstSpecs(FilteringSpec filter, List<IDataColumn> combination) {
        Set<String> conceptsFromSpec;
        int comboSize = combination.size();
        GroupSpec filterGroup = filter.getAllowedGroup(comboSize);
        if (filterGroup == null) {
            return false;
        }
        List<ICombinationSpec> filterCombos = filterGroup.getValidCombinations();
        if (this.sizeToConceptsMap.containsKey(comboSize)) {
            conceptsFromSpec = this.sizeToConceptsMap.get(comboSize);
        } else {
            conceptsFromSpec = this.getSetOfConcepts(filterCombos);
            this.sizeToConceptsMap.put(combination.size(), conceptsFromSpec);
        }
        HashMap<String, Integer> elementSpecsMap = new HashMap<String, Integer>();
        combination.forEach(column -> column.getFlatListOfConcepts().forEach(concept -> {
            String conceptId = concept;
            if (conceptsFromSpec.contains(conceptId)) {
                if (!elementSpecsMap.containsKey(conceptId)) {
                    elementSpecsMap.put(conceptId, 1);
                } else {
                    int value = (Integer)elementSpecsMap.get(conceptId) + 1;
                    elementSpecsMap.put(conceptId, value);
                }
            }
        }));
        ArrayList<ElementSpec> l = new ArrayList<ElementSpec>();
        elementSpecsMap.forEach((key, value) -> l.add(new ElementSpec((String)key, (int)value)));
        CombinationSpec tc = new CombinationSpec(l);
        for (ICombinationSpec fc : filterCombos) {
            if (!fc.equals(tc)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getSetOfConcepts(List<ICombinationSpec> combos) {
        HashSet<String> set = new HashSet<String>();
        for (ICombinationSpec combo : combos) {
            set.addAll(combo.getConcepts());
        }
        return set;
    }

    public DataCombinationStatus<IDataColumn> getCombs(List<IDataColumn> arr, int min, int max, ExecutorService executor, long timeoutMS) {
        return this.getCombsInternal(arr, min, max, null, executor, timeoutMS);
    }

    public DataCombinationStatus<IDataColumn> getCombs(List<IDataColumn> arr, FilteringSpec filter, ExecutorService executor, long timeoutMS) {
        return this.getCombsInternal(arr, filter.getMin(), filter.getMax(), filter, executor, timeoutMS);
    }

    public DataCombinationStatus<IDataColumn> getCombsInternal(List<IDataColumn> arr, int min, int max, FilteringSpec filter, ExecutorService executor, long timeoutMS) {
        List<CompletableFuture<DataCombinationStatus<IDataColumn>>> cfs = this.getCombsAsynch(arr, filter, min, max > arr.size() ? arr.size() : max, executor, timeoutMS);
        ArrayList res = new ArrayList();
        AtomicBoolean isInterrupted = new AtomicBoolean(false);
        cfs.forEach(cf -> {
            try {
                DataCombinationStatus dComb = (DataCombinationStatus)cf.get();
                res.addAll(dComb.getCombinations());
                if (dComb.isInterrupted()) {
                    isInterrupted.set(true);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("internal combinations error", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        });
        return new DataCombinationStatus<IDataColumn>(res, isInterrupted.get());
    }
}

