/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.schema;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.schema.action.Source;
import java.util.ArrayList;
import java.util.List;

public class AppContext {
    List<Source> sources = new ArrayList<Source>();
    List<String> includedList = new ArrayList<String>();
    List<String> excludedList = new ArrayList<String>();

    public AppContext(JSONObject json) {
        if (json != null) {
            JSONArray excludedCharts;
            JSONArray includedCharts;
            JSONArray jsonSources = (JSONArray)json.get((Object)"sources");
            if (jsonSources != null) {
                for (int i = 0; i < jsonSources.size(); ++i) {
                    Source source = new Source((JSONObject)jsonSources.get(i));
                    this.sources.add(source);
                }
            }
            if ((includedCharts = (JSONArray)json.get((Object)"includedCharts")) != null) {
                for (int i = 0; i < includedCharts.size(); ++i) {
                    String included = includedCharts.get(i).toString();
                    this.includedList.add(included);
                }
            }
            if ((excludedCharts = (JSONArray)json.get((Object)"excludedCharts")) != null) {
                for (int i = 0; i < excludedCharts.size(); ++i) {
                    String excluded = excludedCharts.get(i).toString();
                    this.excludedList.add(excluded);
                }
            }
        }
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public List<String> getIncludedCharts() {
        return this.includedList;
    }

    public List<String> getExcludedCharts() {
        return this.excludedList;
    }

    public Source getActiveSource() {
        if (this.sources != null && !this.sources.isEmpty()) {
            for (Source source : this.sources) {
                if (!source.isActive()) continue;
                return source;
            }
        }
        return null;
    }
}

