/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.schema;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class ClientContext {
    private String moduleId;
    private String type;
    private String moduleName;
    private String lastAction;
    private Map<String, Object> events;
    private Stack<JSONObject> intentStack = new Stack();
    private boolean restart = false;
    private String lockedSkillId = null;

    public ClientContext() {
    }

    public ClientContext(JSONObject json) {
        if (json != null) {
            JSONArray jsonHandlers;
            this.restart = json.get((Object)"restart") != null;
            this.moduleId = (String)json.get((Object)"module");
            this.type = (String)json.get((Object)"type");
            this.moduleName = (String)json.get((Object)"name");
            this.lastAction = (String)json.get((Object)"last_action");
            this.lockedSkillId = (String)json.get((Object)"lockedSkillId");
            JSONArray jsonEvents = (JSONArray)json.get((Object)"events");
            if (jsonEvents != null && !jsonEvents.isEmpty()) {
                this.events = new HashMap<String, Object>();
                for (Object obj : jsonEvents) {
                    JSONObject jsonEvent = (JSONObject)obj;
                    this.events.put((String)jsonEvent.get((Object)"name"), jsonEvent.get((Object)"value"));
                }
            }
            if ((jsonHandlers = (JSONArray)json.get((Object)"handlers")) != null && !jsonHandlers.isEmpty()) {
                this.intentStack.clear();
                for (Object obj : jsonHandlers) {
                    this.intentStack.add((JSONObject)obj);
                }
            }
        }
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        if (this.restart) {
            json.put((Object)"restart", (Object)this.restart);
        }
        json.put((Object)"module", (Object)this.moduleId);
        json.put((Object)"type", (Object)this.type);
        json.put((Object)"name", (Object)this.moduleName);
        json.put((Object)"last_action", (Object)this.lastAction);
        if (this.lockedSkillId != null) {
            json.put((Object)"lockedSkillId", (Object)this.lockedSkillId);
        }
        if (this.events != null && !this.events.isEmpty()) {
            JSONArray jsonEvents = new JSONArray();
            for (Map.Entry<String, Object> entry : this.events.entrySet()) {
                JSONObject jsonEvent = new JSONObject();
                jsonEvent.put((Object)"name", (Object)entry.getKey());
                jsonEvent.put((Object)"value", entry.getValue());
                jsonEvents.add((Object)jsonEvent);
            }
            json.put((Object)"events", (Object)jsonEvents);
        }
        if (this.intentStack != null && !this.intentStack.isEmpty()) {
            JSONArray jsonHandlers = new JSONArray();
            for (JSONObject intentHandler : this.intentStack) {
                jsonHandlers.add((Object)intentHandler);
            }
            json.put((Object)"handlers", (Object)jsonHandlers);
        }
        return json;
    }

    public void setContext(String moduleId, String type, String moduleName) {
        this.moduleId = moduleId;
        this.type = type;
        this.moduleName = moduleName;
    }

    public void clearContext() {
        this.moduleId = null;
        this.type = null;
        this.moduleName = null;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String id) {
        this.moduleId = id;
    }

    public String getModuleType() {
        return this.type;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String name) {
        this.moduleName = name;
    }

    public void setModuleType(String type) {
        this.type = type;
    }

    public String getLastAction() {
        return this.lastAction;
    }

    public boolean isRestartRequired() {
        return this.restart;
    }

    public void setRestart(boolean restart) {
        this.restart = restart;
    }

    public void setLastAction(String executedAction) {
        this.lastAction = executedAction;
    }

    public void pushIntent(JSONObject jsonObject) {
        if (this.intentStack == null) {
            this.intentStack = new Stack();
        }
        this.intentStack.push(jsonObject);
    }

    public JSONObject popIntent() {
        if (this.intentStack != null && !this.intentStack.isEmpty()) {
            return this.intentStack.pop();
        }
        return null;
    }

    public void clearIntentStack() {
        this.intentStack.clear();
    }

    public void addEvent(String name, Object value) {
        if (this.events == null) {
            this.events = new HashMap<String, Object>();
        }
        this.events.put(name, value);
    }

    public Map<String, Object> getEvents() {
        return this.events;
    }

    public void clearEvents() {
        this.events = null;
        this.setRestart(false);
    }

    public void lockSkill(String skillId) {
        this.lockedSkillId = skillId;
    }

    public void unlockSkill() {
        this.lockedSkillId = null;
    }

    public String getLockedSkill() {
        return this.lockedSkillId;
    }
}

