/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.schema.action;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.schema.action.Section;
import com.ibm.smarts.conversation.schema.action.ShowGlobalSearchSourcesHelper;
import com.ibm.smarts.conversation.schema.action.Source;
import com.ibm.smarts.conversation.schema.action.SourceListSection;
import com.ibm.smarts.conversation.schema.action.TextSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Action {
    public static final String SYSTEM_SKILL_ID = "pre.system";
    public static final int CLICK_SKILL_IDX = 0;
    public static final int CLICK_INTENT_IDX = 0;
    public static final int CLICK_MODULE_INFO_IDX = 1;
    public static final int CLICK_ID_START_IDX = 2;
    protected String id;
    protected String type;
    private List<String> sentences;
    private ShowGlobalSearchSourcesHelper globalSearchSources;
    private JSONArray moduleClickParams = new JSONArray();

    public Action(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public List<Section> getSections() {
        return Collections.emptyList();
    }

    public JSONObject toJSON() {
        JSONObject action = new JSONObject();
        action.put((Object)"id", (Object)this.id);
        List<Section> sections = this.getSections();
        if (!sections.isEmpty()) {
            JSONArray jsonSections = new JSONArray();
            for (Section section : sections) {
                jsonSections.add((Object)section.toJSON());
            }
            action.put((Object)"sections", (Object)jsonSections);
        }
        return action;
    }

    protected void addGlobalSearchSections(List<Section> sections) {
        if (this.globalSearchSources != null && this.globalSearchSources.hasSources()) {
            sections.add(new TextSection(this.globalSearchSources.getSroucesSentence()));
            sections.add(new SourceListSection(this.globalSearchSources.getSources(), this.globalSearchSources.getSourcesTemplate(), this.globalSearchSources.getClickIntent()));
        }
    }

    public void addSources(List<Source> sources, String sentence, String clickIntent) {
        this.addSources(sources, sentence, null, clickIntent);
    }

    public void addSources(List<Source> sources, String sentence, String message, String clickIntent) {
        if (sources != null && !sources.isEmpty()) {
            this.globalSearchSources = new ShowGlobalSearchSourcesHelper(sources, sentence, message, clickIntent);
        }
    }

    public void addSentence(String sentence) {
        if (this.sentences == null) {
            this.sentences = new ArrayList<String>();
        }
        this.sentences.add(sentence);
    }

    public void addModuleInfo(String moduleId, String moduleName, String moduleType) {
        Source src = new Source(moduleName, moduleId, moduleType, null);
        this.moduleClickParams.add((Object)src.toJSON().toString());
        this.type = moduleType;
    }

    public String getModuleType() {
        return this.type;
    }

    public JSONArray getModuleClickParams() {
        return this.moduleClickParams;
    }
}

