/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.schema.action;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.schema.action.Section;
import com.ibm.smarts.conversation.schema.intent.Column;
import com.ibm.smarts.visualization.recommender.schema.VisRecommendation;
import java.util.Collection;
import java.util.List;

public class ChartsSection
extends Section {
    private List<VisRecommendation> visRecs;
    private List<Column> columns;
    private String moduleId;
    private String moduleType;

    public List<Column> getVisMods() {
        return this.columns;
    }

    public ChartsSection(List<VisRecommendation> visRecs, List<Column> columns, String moduleId, String moduleType) {
        super("charts");
        this.visRecs = visRecs;
        this.columns = columns;
        this.moduleId = moduleId;
        this.moduleType = moduleType;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject section = super.toJSON();
        JSONArray jsonRecs = new JSONArray();
        for (VisRecommendation visRec : this.visRecs) {
            jsonRecs.add((Object)visRec.toJSONObject());
        }
        if (this.columns != null) {
            JSONArray jsonMods = new JSONArray();
            JSONArray jsonFilters = new JSONArray();
            JSONArray jsonFilterDescriptions = new JSONArray();
            for (Column column : this.columns) {
                if (column.isModified()) {
                    jsonMods.add((Object)column.getModifiersJSON());
                }
                if (column.isFiltered()) {
                    jsonFilters.addAll((Collection)column.getFiltersJSON());
                }
                List<String> discs = column.getFilterDescription();
                jsonFilterDescriptions.addAll(discs);
            }
            if (!jsonMods.isEmpty()) {
                section.put((Object)"vis_modifiers", (Object)jsonMods);
            }
            if (!jsonFilters.isEmpty()) {
                section.put((Object)"vis_filters", (Object)jsonFilters);
            }
            if (!jsonFilterDescriptions.isEmpty()) {
                section.put((Object)"vis_filter_description", (Object)jsonFilterDescriptions);
            }
        }
        section.put((Object)"vis_recommendations", (Object)jsonRecs);
        section.put((Object)"module_id", (Object)this.moduleId);
        section.put((Object)"module_type", (Object)this.moduleType);
        return section;
    }
}

