/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.schema.action;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.UsageType;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class QueryItemInfo {
    ColumnInfo columnInfo;
    String datasetId;

    public QueryItemInfo(ColumnInfo columnInfo, String datasetId) {
        this.columnInfo = columnInfo;
        this.datasetId = datasetId;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"label", (Object)this.columnInfo.getName());
        json.put((Object)"type", (Object)this.columnInfo.getDataType().getBaseType().toString());
        json.put((Object)"id", (Object)this.columnInfo.getIdForExpression());
        json.put((Object)"datasetId", (Object)this.datasetId);
        json.put((Object)"concepts", (Object)this.getConcepts());
        json.put((Object)"statistics", (Object)this.getStatistics());
        json.put((Object)"properties", (Object)this.getProperties());
        return json;
    }

    private JSONArray getStatistics() {
        JSONArray allStats = new JSONArray();
        for (Statistic stat : this.columnInfo.getStatistics()) {
            if (stat.getValue() == null || stat.getType() == null) continue;
            JSONObject json = new JSONObject();
            String type = stat.getType().value();
            json.put((Object)"type", (Object)type);
            json.put((Object)"value", (Object)stat.getValue().stringValue());
            json.put((Object)"label", (Object)Messages.getString("Statistics." + type));
            allStats.add((Object)json);
        }
        return allStats;
    }

    public JSONArray getProperties() {
        JSONArray allProps = new JSONArray();
        JSONObject usageJson = new JSONObject();
        usageJson.put((Object)"label", (Object)Messages.getString("Properties.usage"));
        usageJson.put((Object)"type", (Object)"usage");
        UsageType colUsage = this.columnInfo.getUsage();
        if (colUsage != null) {
            String usageValue = colUsage.toString();
            if (usageValue != null && !usageValue.isEmpty()) {
                usageJson.put((Object)"value", (Object)Messages.getString("Usage." + usageValue));
            } else {
                usageJson.put((Object)"value", (Object)"");
            }
        }
        allProps.add((Object)usageJson);
        JSONObject aggregateJson = new JSONObject();
        aggregateJson.put((Object)"label", (Object)Messages.getString("Properties.aggregate"));
        aggregateJson.put((Object)"type", (Object)"aggregate");
        AggregationType colAggregation = this.columnInfo.getDefaultAggregation();
        if (colAggregation != null) {
            String aggregateValue = this.columnInfo.getDefaultAggregation().toString();
            if (aggregateValue != null && !aggregateValue.isEmpty()) {
                aggregateJson.put((Object)"value", (Object)Messages.getString("Aggregate." + aggregateValue));
            } else {
                aggregateJson.put((Object)"value", (Object)"");
            }
        }
        allProps.add((Object)aggregateJson);
        JSONObject representsJson = new JSONObject();
        representsJson.put((Object)"label", (Object)Messages.getString("Properties.represents"));
        representsJson.put((Object)"type", (Object)"represents");
        if (this.columnInfo.getSemanticInfo() != null) {
            ConceptInfo representsConcept = this.getRepresentsConcepts();
            String repValue = ConceptsUtil.getConceptName((ConceptInfo)representsConcept);
            if (repValue != null && !repValue.isEmpty()) {
                representsJson.put((Object)"value", (Object)Messages.getString("Represents." + repValue));
            } else {
                representsJson.put((Object)"value", (Object)"");
            }
        }
        allProps.add((Object)representsJson);
        JSONObject dataTypeJson = new JSONObject();
        dataTypeJson.put((Object)"label", (Object)Messages.getString("Properties.dataType"));
        dataTypeJson.put((Object)"type", (Object)"dataType");
        String typeValue = this.columnInfo.getDataType().getBaseType().name();
        if (typeValue != null && !typeValue.isEmpty()) {
            dataTypeJson.put((Object)"value", (Object)Messages.getString("Datatype." + typeValue));
        } else {
            dataTypeJson.put((Object)"value", (Object)"");
        }
        allProps.add((Object)dataTypeJson);
        JSONObject conceptsJson = new JSONObject();
        conceptsJson.put((Object)"label", (Object)Messages.getString("Properties.concepts"));
        conceptsJson.put((Object)"type", (Object)"concepts");
        conceptsJson.put((Object)"value", (Object)this.getConcepts());
        allProps.add((Object)conceptsJson);
        return allProps;
    }

    private ConceptInfo getRepresentsConcepts() {
        ConceptInfo res = new ConceptInfo();
        for (ConceptInfo concept : this.columnInfo.getSemanticInfo().getConcepts()) {
            if (!ConceptsUtil.isRepresentsConcept((ConceptInfo)concept)) continue;
            res = concept;
        }
        return res;
    }

    private JSONArray getConcepts() {
        List concepts;
        JSONArray jsonConcepts = new JSONArray();
        SemanticInfo si = this.columnInfo.getSemanticInfo();
        if (si != null && (concepts = si.getConcepts()) != null) {
            Collections.sort(concepts, new Comparator<ConceptInfo>(){

                @Override
                public int compare(ConceptInfo o1, ConceptInfo o2) {
                    return o1.getConfidence() < o2.getConfidence() ? 1 : (o1.getConfidence() > o2.getConfidence() ? -1 : ConceptsUtil.getConceptName((ConceptInfo)o1).compareTo(ConceptsUtil.getConceptName((ConceptInfo)o2)));
                }
            });
            for (ConceptInfo ci : concepts) {
                jsonConcepts.add((Object)ConceptsUtil.getConceptName((ConceptInfo)ci));
            }
        }
        return jsonConcepts;
    }

    public static JSONArray getClickParams() {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)"id");
        jsonArray.add((Object)"datasetId");
        return jsonArray;
    }
}

