/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.schema.action;

import com.ibm.json.java.JSONArray;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.action.Action;
import com.ibm.smarts.conversation.schema.action.ChartsSection;
import com.ibm.smarts.conversation.schema.action.Section;
import com.ibm.smarts.conversation.schema.action.Source;
import com.ibm.smarts.conversation.schema.action.TextSection;
import com.ibm.smarts.conversation.schema.intent.Column;
import com.ibm.smarts.conversation.schema.utils.EscapeUtils;
import com.ibm.smarts.visualization.recommender.schema.VisRecommendation;
import java.util.ArrayList;
import java.util.List;

public class ShowChartAction
extends Action {
    String moduleId;
    String moduleType;
    String visSentence;
    List<VisRecommendation> visRecs;
    List<Column> visMods;
    boolean canAuthorDashboard = true;

    public ShowChartAction(String moduleId, String moduleType, List<VisRecommendation> visRecs, boolean canAuthorDashboard) {
        super("show_chart");
        this.moduleId = moduleId;
        this.moduleType = moduleType;
        this.visRecs = visRecs;
        this.canAuthorDashboard = canAuthorDashboard;
    }

    public ShowChartAction(String moduleId, String moduleType, List<VisRecommendation> visRecs, List<Column> visMods, boolean canAuthorDashboard) {
        super("show_chart");
        this.moduleId = moduleId;
        this.moduleType = moduleType;
        this.visRecs = visRecs;
        this.visMods = visMods;
        this.canAuthorDashboard = canAuthorDashboard;
    }

    public ShowChartAction(String moduleId, String moduleType, String moduleName, List<VisRecommendation> visRecs, List<Column> visMods, List<Source> sources, String sentence, boolean canAuthorDashboard) {
        this(moduleId, moduleType, visRecs, visMods, canAuthorDashboard);
        this.visSentence = String.format(Messages.getString("ShowChartAction.VizInfo"), EscapeUtils.markdown(moduleName));
        this.addSources(sources, sentence, "show");
    }

    @Override
    public List<Section> getSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        if (this.visSentence != null) {
            sections.add(new TextSection(this.visSentence));
        }
        sections.add(new ChartsSection(this.visRecs, this.visMods, this.moduleId, this.moduleType));
        sections.add(new TextSection(Messages.getString("ShowChartAction.RelatedViz")));
        if (this.canAuthorDashboard) {
            sections.add(new TextSection(String.format(Messages.getString("ShowChartAction.GenerateDashboard"), new Object[0]), this.getGenerateDashboardClickParams()));
        }
        this.addGlobalSearchSections(sections);
        return sections;
    }

    private JSONArray getGenerateDashboardClickParams() {
        JSONArray generateDashboardClickParams = new JSONArray();
        generateDashboardClickParams.add((Object)"pre.system");
        generateDashboardClickParams.add((Object)"generate_dashboard_context");
        return generateDashboardClickParams;
    }
}

