/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.schema.action;

import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.action.Action;
import com.ibm.smarts.conversation.schema.action.ChartsSection;
import com.ibm.smarts.conversation.schema.action.Section;
import com.ibm.smarts.conversation.schema.action.Source;
import com.ibm.smarts.conversation.schema.action.TextSection;
import com.ibm.smarts.conversation.schema.intent.Column;
import com.ibm.smarts.conversation.schema.utils.EscapeUtils;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.Statistic;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.visualization.recommender.schema.VisColumn;
import com.ibm.smarts.visualization.recommender.schema.VisRecommendation;
import java.util.ArrayList;
import java.util.List;

public class ShowModifiedItemAction
extends Action {
    private List<Column> items;
    private String moduleId;
    private String moduleType;
    private String moduleName;
    private static final String SINGLETON = "Singleton";
    private static final String LIST = "List";
    private static final String VALUE_SLOT = "VALUE";
    private static final String LIST_SLOT = "ANY";

    public ShowModifiedItemAction(List<Column> items, String moduleName, String moduleId, String moduleType, List<Source> sources, String sentence) {
        super("show_modified_column_info");
        this.items = items;
        this.moduleName = moduleName;
        this.moduleId = moduleId;
        this.moduleType = moduleType;
        this.addModuleInfo(moduleId, moduleName, moduleType);
        this.addSources(sources, sentence, "show");
    }

    @Override
    public List<Section> getSections() {
        String infoLabel;
        String label;
        String slot;
        String chartType;
        ArrayList<Section> sections = new ArrayList<Section>();
        Column item = this.getFirstExplicitItem(this.items);
        String itemName = item.getName();
        ColumnInfo columnInfo = item.getColumnInfo();
        if (item.isModified()) {
            if (item.isAggregated()) {
                chartType = SINGLETON;
                slot = VALUE_SLOT;
                String modifiedSingleton = Messages.getString("ShowModifiedItemAction.Singleton." + item.getAggregator());
                label = String.format(modifiedSingleton, itemName);
                infoLabel = String.format(modifiedSingleton.toLowerCase(), itemName);
            } else {
                String modifiedList;
                chartType = LIST;
                slot = LIST_SLOT;
                if (item.getLimit() == null) {
                    modifiedList = Messages.getString("ShowModifiedItemAction.List." + item.getOrder() + ".NoLimit");
                    label = String.format(modifiedList, itemName);
                    infoLabel = String.format(modifiedList.toLowerCase(), itemName);
                } else {
                    modifiedList = Messages.getString("ShowModifiedItemAction.List." + item.getOrder());
                    label = String.format(modifiedList, item.getLimit().getNumber(), itemName);
                    infoLabel = String.format(modifiedList.toLowerCase(), item.getLimit().getNumber(), itemName);
                }
            }
        } else {
            label = itemName;
            if (UsageType.FACT == columnInfo.getUsage() && AggregationType.NONE != columnInfo.getDefaultAggregation()) {
                chartType = SINGLETON;
                slot = VALUE_SLOT;
                infoLabel = String.format(Messages.getString("ShowModifiedItemAction.Singleton"), itemName);
            } else {
                chartType = LIST;
                slot = LIST_SLOT;
                infoLabel = String.format(Messages.getString("ShowModifiedItemAction.List"), itemName);
            }
        }
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(item.getId());
        VisColumn visCol = new VisColumn(ids, slot, null);
        ArrayList<VisColumn> visCols = new ArrayList<VisColumn>(1);
        visCols.add(visCol);
        VisRecommendation visRec = new VisRecommendation(chartType, label, "", this.getDescription(columnInfo), visCols, 1.0);
        ArrayList<VisRecommendation> visRecs = new ArrayList<VisRecommendation>(1);
        visRecs.add(visRec);
        sections.add(new TextSection(String.format(Messages.getString("ShowModifiedItemAction.InfoSentence." + chartType), EscapeUtils.markdown(infoLabel), EscapeUtils.markdown(this.moduleName))));
        sections.add(new ChartsSection(visRecs, this.items, this.moduleId, this.moduleType));
        this.addGlobalSearchSections(sections);
        return sections;
    }

    private Column getFirstExplicitItem(List<Column> items) {
        for (Column item : items) {
            if (!item.isExplicit()) continue;
            return item;
        }
        return null;
    }

    private String getDescription(ColumnInfo columnInfo) {
        boolean isNullable = false;
        long uniqueValues = 0L;
        long minValue = 0L;
        long maxValue = 0L;
        String measureConcept = "Measure";
        String categoryConcept = "Category";
        for (Statistic stat : columnInfo.getStatistics()) {
            if (stat.getType().equals((Object)StatisticType.NULLABLE) && stat.getValue() != null) {
                isNullable = stat.getValue().booleanValue();
                continue;
            }
            if (stat.getType().equals((Object)StatisticType.DISTINCT_COUNT) && stat.getValue() != null) {
                uniqueValues = stat.getValue().longValue();
                continue;
            }
            if (stat.getType().equals((Object)StatisticType.MIN_VALUE) && stat.getValue() != null) {
                minValue = stat.getValue().longValue();
                continue;
            }
            if (!stat.getType().equals((Object)StatisticType.MAX_VALUE) || stat.getValue() == null) continue;
            maxValue = stat.getValue().longValue();
        }
        String ret = columnInfo.getUsage().equals((Object)UsageType.FACT) ? (isNullable ? String.format(Messages.getString("ChartDescription.MeasureWithNulls"), columnInfo.getName(), measureConcept, minValue, maxValue) : String.format(Messages.getString("ChartDescription.Measure"), columnInfo.getName(), measureConcept, minValue, maxValue)) : (isNullable ? String.format(Messages.getString("ChartDescription.CategoryWithNulls"), columnInfo.getName(), categoryConcept, uniqueValues) : String.format(Messages.getString("ChartDescription.Category"), columnInfo.getName(), categoryConcept, uniqueValues));
        return ret;
    }
}

