/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.schema.action;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.action.Action;
import com.ibm.smarts.conversation.schema.action.ColumnListSection;
import com.ibm.smarts.conversation.schema.action.PropertyListSection;
import com.ibm.smarts.conversation.schema.action.QueryItemInfo;
import com.ibm.smarts.conversation.schema.action.Section;
import com.ibm.smarts.conversation.schema.action.Source;
import com.ibm.smarts.conversation.schema.action.TextSection;
import com.ibm.smarts.conversation.schema.intent.Column;
import com.ibm.smarts.conversation.schema.provider.ConversationColumnInfo;
import com.ibm.smarts.conversation.schema.utils.EscapeUtils;
import com.ibm.smarts.schema.UsageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ShowQueryItemInfoAction
extends Action {
    private Column item;
    private List<ConversationColumnInfo> relatedColumns;
    private String currentIntent;
    private String moduleName;
    private List<String> insights;

    public ShowQueryItemInfoAction(Column item, List<ConversationColumnInfo> relatedColumns, String intent, String moduleName, String moduleId, String moduleType, List<Source> sources, List<String> insights, String sentence) {
        super("show_column_info");
        this.currentIntent = intent;
        this.relatedColumns = relatedColumns;
        this.item = item;
        this.moduleName = moduleName;
        this.insights = insights;
        this.addModuleInfo(moduleId, moduleName, moduleType);
        this.addSources(sources, sentence, this.isShowIntent() ? "show" : "showinfluencer");
    }

    @Override
    public List<Section> getSections() {
        String msg;
        String itemName = this.item.getName();
        ArrayList<Section> sections = new ArrayList<Section>();
        if (this.isShowIntent()) {
            sections.add(new TextSection(String.format(Messages.getString("ShowQueryItemInfoAction.InfoSentence"), EscapeUtils.markdown(this.moduleName), EscapeUtils.markdown(itemName))));
            sections.add(new PropertyListSection(new QueryItemInfo(this.item.getColumnInfo(), this.item.getDatasetId()).getProperties()));
            if (!this.relatedColumns.isEmpty()) {
                msg = String.format(Messages.getString("ShowQueryItemInfoAction.InterestingFields"), EscapeUtils.markdown(itemName), EscapeUtils.markdown(this.moduleName)) + Messages.getString("ShowQueryItemInfoAction.SelectOne");
                sections.add(new TextSection(msg));
            }
        } else {
            msg = String.format(Messages.getString("ShowQueryItemInfoAction.AllFields"), EscapeUtils.markdown(itemName), EscapeUtils.markdown(this.moduleName)) + Messages.getString("ShowQueryItemInfoAction.SelectOne");
            sections.add(new TextSection(msg));
        }
        if (!this.relatedColumns.isEmpty()) {
            sections.add(new ColumnListSection(this.relatedColumns, this.getClickTemplate(), this.getClickParams(), this.getClickTemplateParams()));
        }
        if (this.isShowIntent() && this.item.getColumnInfo().getUsage() == UsageType.FACT) {
            sections.add(new TextSection(String.format(Messages.getString("ShowQueryItemInfoAction.WhatInfluence"), EscapeUtils.markdown(this.encodeColumnName())), this.getInfluencerClickParams()));
        }
        if (this.insights != null && !this.insights.isEmpty()) {
            sections.add(new TextSection("Did you know?"));
            for (String insight : this.insights) {
                sections.add(new TextSection(insight));
            }
        }
        this.addGlobalSearchSections(sections);
        return sections;
    }

    private String getClickTemplate() {
        return String.format(Messages.getString("ShowQueryItemInfoAction.Template"), this.item.getName(), "{{label}}");
    }

    private JSONArray getClickParams() {
        return this.getIntentSpecificParams("show");
    }

    private JSONArray getClickTemplateParams() {
        return QueryItemInfo.getClickParams();
    }

    private JSONArray getInfluencerClickParams() {
        return this.getIntentSpecificParams("showinfluencer");
    }

    private JSONArray getIntentSpecificParams(String intent) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)"pre.system");
        jsonArray.add((Object)intent);
        jsonArray.addAll((Collection)this.getModuleClickParams());
        JSONObject columnIdObj = new JSONObject();
        columnIdObj.put((Object)"id", (Object)this.item.getId());
        columnIdObj.put((Object)"datasetId", (Object)this.item.getDatasetId());
        jsonArray.add((Object)columnIdObj.toString());
        return jsonArray;
    }

    private boolean isShowIntent() {
        return "show".equals(this.currentIntent);
    }

    public String encodeColumnName() {
        return this.item.getName().replace("{", "&#123;").replace("|", "&#124;").replace("}", "&#125;");
    }
}

