/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.schema.action;

import com.ibm.json.java.JSONArray;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.action.Action;
import com.ibm.smarts.conversation.schema.action.ColumnListSection;
import com.ibm.smarts.conversation.schema.action.QueryItemInfo;
import com.ibm.smarts.conversation.schema.action.Section;
import com.ibm.smarts.conversation.schema.action.TextSection;
import com.ibm.smarts.conversation.schema.provider.ConversationColumnInfo;
import com.ibm.smarts.conversation.schema.utils.EscapeUtils;
import com.ibm.smarts.conversation.schema.utils.QuestionGeneratorUtility;
import com.ibm.smarts.model.qg.Question;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ShowQueryItemsAction
extends Action {
    private List<ConversationColumnInfo> columns;
    private List<Question> questions;
    private boolean isInteresting;
    private boolean isPartial;
    private String moduleLabel;

    public ShowQueryItemsAction(List<ConversationColumnInfo> columns, String moduleId, String moduleLabel, String moduleType, boolean isInteresting, boolean isPartial) {
        this(columns, Collections.emptyList(), moduleId, moduleLabel, moduleType, isInteresting, isPartial);
    }

    public ShowQueryItemsAction(List<ConversationColumnInfo> columns, List<Question> questions, String moduleId, String moduleLabel, String moduleType, boolean isInteresting, boolean isPartial) {
        super("show_query_items");
        this.columns = columns;
        this.questions = questions;
        this.isInteresting = isInteresting;
        this.isPartial = isPartial;
        this.moduleLabel = moduleLabel;
        this.addModuleInfo(moduleId, moduleLabel, moduleType);
    }

    @Override
    public List<Section> getSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        String msgId = this.isInteresting ? (this.isPartial ? "ShowQueryItemsAction.InterestingFields.Partial" : "ShowQueryItemsAction.InterestingFields") : (this.isPartial ? "ShowQueryItemsAction.AllFields.Partial" : "ShowQueryItemsAction.AllFields");
        sections.add(new TextSection(String.format(Messages.getString(msgId), EscapeUtils.markdown(this.moduleLabel))));
        sections.add(new ColumnListSection(this.columns, this.getRelatedQueryItemTemplate(), this.getClickParams(), this.getClickTemplateParams()));
        if (this.questions != null && !this.questions.isEmpty()) {
            sections.addAll(QuestionGeneratorUtility.convertQuestionsToTextSections(this.questions, this.getModuleClickParams()));
        }
        return sections;
    }

    private String getRelatedQueryItemTemplate() {
        return String.format(Messages.getString("ShowQueryItemsAction.Template"), "{{label}}");
    }

    private JSONArray getClickParams() {
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)"pre.system");
        jsonArray.add((Object)"show");
        jsonArray.addAll((Collection)this.getModuleClickParams());
        return jsonArray;
    }

    private JSONArray getClickTemplateParams() {
        return QueryItemInfo.getClickParams();
    }
}

