/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.schema.intent;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.conversation.nlu.schema.intent.Aggregator;
import com.ibm.smarts.conversation.nlu.schema.intent.Limit;
import com.ibm.smarts.conversation.nlu.schema.intent.Operator;
import com.ibm.smarts.conversation.nlu.schema.intent.Order;
import com.ibm.smarts.conversation.schema.Messages;
import com.ibm.smarts.conversation.schema.utils.EscapeUtils;
import com.ibm.smarts.generated.parser.ParseException;
import com.ibm.smarts.nlg.api.SmartsNLGApiImpl;
import com.ibm.smarts.schema.ColumnInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Column {
    private String id;
    private String name;
    private String datasetId;
    private String moduleId;
    private ColumnInfo colInfo;
    private boolean isExplicit;
    private List<String> includeFilters;
    private List<String> excludeFilters;
    private Order order;
    private String orderById;
    private String orderByName;
    private Aggregator orderByAggregator;
    private Aggregator aggregator;
    private Limit limit;
    private long start;
    private long end;
    private Operator expressionOperator;
    private String expressionValue;
    private static final String CONDITION = "condition";
    private static final Logger LOGGER = LoggerFactory.getLogger(Column.class);

    public Column(String id, String datasetId, String moduleId) {
        this.id = id;
        this.datasetId = datasetId;
        this.moduleId = moduleId;
        this.isExplicit = true;
    }

    public Column(String id, String datasetId, String moduleId, ColumnInfo colInfo, boolean isExplicit) {
        this.id = id;
        this.datasetId = datasetId;
        this.moduleId = moduleId;
        this.colInfo = colInfo;
        this.isExplicit = isExplicit;
    }

    public Column(JSONObject jsonObject, String moduleId) {
        String aggregate;
        JSONObject jsonLimit;
        String order;
        String datasetId;
        this.id = (String)jsonObject.get((Object)"id");
        this.moduleId = moduleId;
        Boolean isExplicit = (Boolean)jsonObject.get((Object)"isExplicit");
        this.isExplicit = isExplicit != null ? isExplicit : true;
        String name = (String)jsonObject.get((Object)"name");
        if (name != null) {
            this.name = name;
        }
        if ((datasetId = (String)jsonObject.get((Object)"datasetId")) != null) {
            this.datasetId = datasetId;
        }
        if ((order = (String)jsonObject.get((Object)"order")) != null) {
            this.order = Order.fromValue((String)order);
        }
        if ((jsonLimit = (JSONObject)jsonObject.get((Object)"limit")) != null) {
            this.limit = new Limit(jsonLimit);
        }
        if ((aggregate = (String)jsonObject.get((Object)"aggregate")) != null) {
            this.aggregator = Aggregator.fromValue((String)aggregate);
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.colInfo != null) {
            return this.colInfo.getName();
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public String getId() {
        return this.id;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public void setOrderBy(String orderById, String orderByName, Aggregator orderByAggregator) {
        this.orderById = orderById;
        this.orderByName = orderByName;
        this.orderByAggregator = orderByAggregator;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setAggregator(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public boolean isExcludeFilter() {
        return this.excludeFilters != null;
    }

    public void addFilter(String filter, boolean isExclude) {
        if (isExclude) {
            if (this.excludeFilters == null) {
                this.excludeFilters = new ArrayList<String>();
            }
            this.excludeFilters.add(filter);
        } else {
            if (this.includeFilters == null) {
                this.includeFilters = new ArrayList<String>();
            }
            this.includeFilters.add(filter);
        }
    }

    public List<String> getFilters(Boolean isExclude) {
        return isExclude != false ? this.excludeFilters : this.includeFilters;
    }

    private void copyFilters(Column srcItem, boolean isExclude) {
        List<String> srcFilters = srcItem.getFilters(isExclude);
        if (srcFilters != null) {
            for (String filter : srcFilters) {
                this.addFilter(filter, isExclude);
            }
        }
    }

    public void copyFilters(Column srcItem) {
        this.copyFilters(srcItem, true);
        this.copyFilters(srcItem, false);
    }

    public ColumnInfo getColumnInfo() {
        return this.colInfo;
    }

    public void setColumnInfo(ColumnInfo colInfo) {
        this.colInfo = colInfo;
    }

    public JSONObject getModifiersJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"id", (Object)this.id);
        if (this.aggregator != null) {
            json.put((Object)"aggregate", (Object)this.aggregator.value());
        }
        if (this.order != null) {
            this.putOrderAndLimitInfo(json, this.order, this.limit);
        } else if (this.limit != null) {
            this.putOrderAndLimitInfo(json, Order.DESC, this.limit);
        }
        return json;
    }

    private void putOrderAndLimitInfo(JSONObject json, Order order, Limit limit) {
        json.put((Object)"type", (Object)this.getOrderType(order));
        if (limit != null) {
            json.put((Object)"value", (Object)limit.getNumber());
        } else {
            json.put((Object)"value", (Object)"10");
        }
        this.putOrderByInfo(json);
    }

    private void putOrderByInfo(JSONObject json) {
        if (this.orderById != null) {
            json.put((Object)"by", (Object)this.orderById);
            if (this.orderByAggregator != null) {
                json.put((Object)"by_aggregate", (Object)this.orderByAggregator.value());
            }
        }
    }

    private String getOrderType(Order order) {
        boolean isPercent;
        boolean bl = isPercent = this.limit != null && this.limit.isPercent();
        if (Order.DESC.equals((Object)order)) {
            return isPercent ? "toppercent" : "topcount";
        }
        return isPercent ? "bottompercent" : "bottomcount";
    }

    public JSONArray getFiltersJSON() {
        JSONArray filters = new JSONArray();
        if (this.hasExpression()) {
            JSONObject json = new JSONObject();
            json.put((Object)"id", (Object)this.id);
            json.put((Object)CONDITION, (Object)this.expressionOperator.value());
            JSONArray jsonValues = new JSONArray();
            jsonValues.add((Object)this.expressionValue);
            json.put((Object)"values", (Object)jsonValues);
            filters.add((Object)json);
        } else {
            JSONArray jsonValues;
            JSONObject json;
            if (this.excludeFilters != null) {
                json = new JSONObject();
                json.put((Object)"id", (Object)this.id);
                json.put((Object)CONDITION, (Object)"notcontains");
                jsonValues = new JSONArray();
                for (String value : this.excludeFilters) {
                    jsonValues.add((Object)value);
                }
                json.put((Object)"values", (Object)jsonValues);
                filters.add((Object)json);
            }
            if (this.includeFilters != null) {
                json = new JSONObject();
                json.put((Object)"id", (Object)this.id);
                json.put((Object)CONDITION, (Object)"orcontains");
                jsonValues = new JSONArray();
                for (String value : this.includeFilters) {
                    jsonValues.add((Object)value);
                }
                json.put((Object)"values", (Object)jsonValues);
                filters.add((Object)json);
            }
        }
        return filters;
    }

    public List<String> getFilterDescription() {
        String colName = this.getName();
        if (colName == null || !this.isFiltered() && !this.isModified()) {
            return Collections.emptyList();
        }
        List<String> descriptions = this.buildFilterDescriptions(colName);
        if (this.isModified()) {
            String description = null;
            if (this.order != null) {
                String limitStr;
                if (this.limit != null) {
                    limitStr = this.limit.getNumber();
                    if (this.limit.isPercent()) {
                        limitStr = limitStr + "%";
                    }
                } else {
                    limitStr = "10";
                }
                description = this.orderById != null ? String.format(Messages.getString("Column.Modifier.By." + this.order), colName, limitStr, this.orderByName) : String.format(Messages.getString("Column.Modifier." + this.order), colName, limitStr);
            } else if (this.limit != null) {
                String limitStr = this.limit.getNumber();
                description = this.orderById != null ? String.format(Messages.getString("Column.Modifier.By.DESC"), colName, limitStr, this.orderByName) : String.format(Messages.getString("Column.Modifier.DESC"), colName, limitStr);
            }
            if (description != null) {
                descriptions.add(description);
            }
        }
        return descriptions;
    }

    List<String> buildFilterDescriptions(String colName) {
        ArrayList<String> descriptions = new ArrayList<String>();
        if (this.isFiltered()) {
            SmartsNLGApiImpl realiser = new SmartsNLGApiImpl();
            if (this.hasExpression()) {
                descriptions.add(String.format(Messages.getString("Column.Filter.Expresion." + this.expressionOperator), colName, this.expressionValue));
            } else {
                String format;
                String errorFormat = null;
                ArrayList<List<String>> params = new ArrayList<List<String>>();
                ArrayList<String> errorParams = new ArrayList<String>();
                params.add(Arrays.asList(EscapeUtils.nlgRealiser(colName)));
                errorParams.add(colName);
                if (this.includeFilters != null && this.excludeFilters != null) {
                    format = "Column.Filter.ContainsAndNotContains";
                    errorFormat = "Column.Filter.ContainsAndNotContains.Error";
                    params.add(EscapeUtils.nlgRealiser(this.includeFilters));
                    params.add(EscapeUtils.nlgRealiser(this.excludeFilters));
                    errorParams.add(String.join((CharSequence)", ", this.includeFilters));
                    errorParams.add(String.join((CharSequence)", ", this.excludeFilters));
                } else if (this.includeFilters != null) {
                    format = "Column.Filter.Contains";
                    errorFormat = "Column.Filter.Contains.Error";
                    params.add(EscapeUtils.nlgRealiser(this.includeFilters));
                    errorParams.add(String.join((CharSequence)", ", this.includeFilters));
                } else {
                    format = "Column.Filter.NotContains";
                    errorFormat = "Column.Filter.NotContains.Error";
                    params.add(EscapeUtils.nlgRealiser(this.excludeFilters));
                    errorParams.add(String.join((CharSequence)", ", this.excludeFilters));
                }
                try {
                    descriptions.add(realiser.realise(Messages.getString(format), new Object[]{params}));
                }
                catch (ParseException e) {
                    descriptions.add(String.format(Messages.getString(errorFormat), errorParams.toArray()));
                    LOGGER.error("NLG Parser error", (Throwable)e);
                    return descriptions;
                }
            }
        }
        return descriptions;
    }

    public boolean isModified() {
        return this.aggregator != null || this.limit != null || this.order != null;
    }

    public boolean isAggregated() {
        return this.aggregator != null;
    }

    public boolean isAggregatedByCountOrDistinct() {
        return Aggregator.COUNT == this.aggregator || Aggregator.COUNT_DISTINCT == this.aggregator;
    }

    public boolean isFiltered() {
        return this.includeFilters != null || this.excludeFilters != null || this.hasExpression();
    }

    public void setExplicit(boolean isExplicit) {
        this.isExplicit = isExplicit;
    }

    public boolean isExplicit() {
        return this.isExplicit;
    }

    public void setExpression(Operator operator, String value) {
        this.expressionOperator = operator;
        this.expressionValue = value;
    }

    public Operator getExpressionOperator() {
        return this.expressionOperator;
    }

    public String getExpressionValue() {
        return this.expressionValue;
    }

    public boolean hasExpression() {
        return this.expressionOperator != null;
    }

    public String toString() {
        return "Column [id: " + this.id + ", start: " + this.start + ", end: " + this.end + ", filtered: " + this.isFiltered() + ", explicit: " + this.isExplicit() + "]";
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"id", (Object)this.id);
        json.put((Object)"name", (Object)this.name);
        json.put((Object)"datasetId", (Object)this.datasetId);
        json.put((Object)"moduleId", (Object)this.moduleId);
        json.put((Object)"isExplicit", (Object)this.isExplicit);
        if (this.order != null) {
            json.put((Object)"order", (Object)this.order.value());
        }
        if (this.aggregator != null) {
            json.put((Object)"aggregator", (Object)this.aggregator.value());
        }
        if (this.limit != null) {
            json.put((Object)"limit", (Object)this.limit.toJSON());
        }
        return json;
    }
}

