/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.conversation.schema.utils;

import com.ibm.json.java.JSONArray;
import com.ibm.smarts.conversation.nlu.schema.intent.Limit;
import com.ibm.smarts.conversation.nlu.schema.intent.Order;
import com.ibm.smarts.conversation.schema.action.TextSection;
import com.ibm.smarts.conversation.schema.utils.EscapeUtils;
import com.ibm.smarts.model.qg.Column;
import com.ibm.smarts.model.qg.Modifier;
import com.ibm.smarts.model.qg.Question;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class QuestionGeneratorUtility {
    private QuestionGeneratorUtility() {
    }

    public static List<TextSection> convertQuestionsToTextSections(List<Question> questions, JSONArray moduleClickParams) {
        ArrayList<TextSection> sections = new ArrayList<TextSection>();
        for (Question question : questions) {
            String questionText = "{{" + EscapeUtils.markdown(question.getText()) + "}}";
            sections.add(new TextSection(questionText, QuestionGeneratorUtility.getClickParamsForQG(question, moduleClickParams)));
        }
        return sections;
    }

    private static JSONArray getClickParamsForQG(Question question, JSONArray moduleClickParams) {
        JSONArray clickParams = new JSONArray();
        clickParams.add((Object)"pre.system");
        if (question.getIQR().getQuestionIntent() != null) {
            clickParams.add((Object)question.getIQR().getQuestionIntent().value());
        }
        clickParams.addAll((Collection)moduleClickParams);
        for (Column qgColumn : question.getIQR().getColumns()) {
            com.ibm.smarts.conversation.schema.intent.Column column = new com.ibm.smarts.conversation.schema.intent.Column(qgColumn.getColumnIdForExpression(), qgColumn.getDatasetId(), qgColumn.getSmartsModuleId());
            column.setName(qgColumn.getPrettyName());
            Modifier modifier = qgColumn.getModifier();
            if (modifier != null) {
                String limit;
                if (modifier.getOrder() != null) {
                    column.setOrder(Order.fromValue((String)modifier.getOrder().value()));
                }
                if ((limit = modifier.getLimit()) != null && !StringUtils.isBlank((CharSequence)limit)) {
                    column.setLimit(new Limit(limit, modifier.isPercent()));
                }
            }
            column.setExplicit(column.isExplicit());
            clickParams.add((Object)column.toJSON().toString());
        }
        return clickParams;
    }
}

