/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.postprocesor;

import com.ibm.bi.platform.moser.common.utils.JoinGraph;
import com.ibm.smarts.nlu.resolver.internal.postprocesor.IPostProcessor;
import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.internal.utils.ResolverUtil;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityResolution;
import com.ibm.smarts.nlu.resolver.resolution.entity.ResolverEntity;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.UsageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

abstract class BaseAltSolutionsPostProcessor
implements IPostProcessor {
    static final int MAX_RESOLUTION_PER_ENTITY = 30;
    static final double MAX_CONFIDENCE_GAP = 0.2;

    BaseAltSolutionsPostProcessor() {
    }

    static <T> List<List<T>> cartesianProduct(List<List<T>> tuples) {
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        if (tuples.isEmpty()) {
            results.add(Collections.emptyList());
            return results;
        }
        List<T> first = tuples.get(0);
        List innerProducts = BaseAltSolutionsPostProcessor.cartesianProduct(tuples.subList(1, tuples.size()));
        return first.stream().flatMap(e -> innerProducts.stream().map(inner -> {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(e);
            result.addAll((Collection<Object>)inner);
            return result;
        })).collect(Collectors.toList());
    }

    boolean isValidSolution(ResolutionContext resolutionContext, List<EntityResolution> candidateSolution, Map<ResolverEntity, EntityResolution> original) {
        List<String> columnIds = candidateSolution.stream().map(c -> c.getMatchedFeature().getFeature().getIdForExpression()).collect(Collectors.toList());
        JoinGraph joinGraph = resolutionContext.getJoinGraph();
        if (!ResolverUtil.isJoined(joinGraph, columnIds)) {
            return false;
        }
        return candidateSolution.stream().allMatch(candidate -> {
            EntityResolution originalResolution = (EntityResolution)original.get(candidate.getNluEntity());
            if (originalResolution == null) {
                return false;
            }
            ColumnInfo originalColumn = originalResolution.getColInfo();
            ColumnInfo column = candidate.getColInfo();
            if (column == null && originalColumn == null) {
                return true;
            }
            if (column == null || originalColumn == null) {
                return false;
            }
            if (column.getUsage().equals((Object)UsageType.FACT) || originalColumn.getUsage().equals((Object)UsageType.FACT)) {
                return column.getUsage().equals((Object)originalColumn.getUsage());
            }
            return !(originalResolution.getMatchConfidence() > candidate.getMatchConfidence()) || !(originalResolution.getMatchConfidence() - candidate.getMatchConfidence() > 0.2);
        });
    }
}

