/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.postprocesor;

import com.ibm.smarts.nlu.resolver.internal.postprocesor.IPostProcessor;
import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.resolution.entity.ResolverEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class FilterCombiner
implements IPostProcessor {
    @Override
    public ResolutionContext apply(ResolutionContext context) {
        Set<ResolverEntity> filters = context.getFilterResolutionMap().keySet();
        Map<String, List<ResolverEntity>> resolutionFilterMap = filters.stream().filter(context.getEntityResolutionMap()::containsKey).collect(Collectors.groupingBy(f -> context.getEntityResolutionMap().get(f).getMatchedFeature().getFeature().getIdForExpression()));
        Set<ResolverEntity> filterCombinationKeys = context.getFilterCombinationMap().keySet();
        Collection<List<ResolverEntity>> combinations = resolutionFilterMap.values();
        combinations.forEach(list -> {
            list.sort(Comparator.comparingLong(ResolverEntity::getStart));
            Optional<ResolverEntity> headFilterOpt = list.stream().filter(filterCombinationKeys::contains).findFirst();
            headFilterOpt.ifPresent(headFilter -> {
                List combined = context.getFilterCombinationMap().computeIfAbsent((ResolverEntity)headFilter, f -> new ArrayList());
                for (ResolverEntity filter : list) {
                    if (filter.equals(headFilter) || combined.contains(filter)) continue;
                    combined.add(filter);
                    combined.addAll(context.getFilterCombinationMap().getOrDefault(filter, Collections.emptyList()));
                    context.getFilterCombinationMap().remove(filter);
                }
            });
        });
        return context;
    }
}

