/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.postprocesor;

import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityResolution;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityType;
import com.ibm.smarts.nlu.resolver.resolution.entity.ResolverEntity;
import com.ibm.smarts.schema.MatchReason;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class FilterPostProcessor
implements UnaryOperator<ResolutionContext> {
    private static final double FILTER_ALLOW_THRESHOLD = 0.1;

    @Override
    public ResolutionContext apply(ResolutionContext resolutionContext) {
        List filters = resolutionContext.getNluEntities().stream().filter(e -> e.getType().equals((Object)EntityType.FILTER)).collect(Collectors.toList());
        Map<ResolverEntity, EntityResolution> resolution = resolutionContext.getEntityResolutionMap();
        Map<ResolverEntity, List<EntityResolution>> candidatesMap = resolutionContext.getEntityCandidateMap();
        Set projectionSet = resolution.entrySet().stream().filter(e -> ((ResolverEntity)e.getKey()).getType().equals((Object)EntityType.COLUMN)).map(e -> ((EntityResolution)e.getValue()).getMatchedFeature().getFeature().getIdForExpression()).collect(Collectors.toSet());
        for (ResolverEntity filter : filters) {
            EntityResolution selected = resolution.get(filter);
            if (selected == null || projectionSet.contains(selected.getMatchedFeature().getFeature().getIdForExpression())) continue;
            Optional<EntityResolution> candidateOpt = candidatesMap.get(filter).stream().filter(r -> r.getMatchReason().equals((Object)MatchReason.DATA_VALUE)).filter(r -> projectionSet.contains(r.getMatchedFeature().getFeature().getIdForExpression())).min(Comparator.comparingDouble(EntityResolution::getCost));
            candidateOpt.ifPresent(candidate -> {
                if (selected.getCost() > 0.0) {
                    double ratio = Math.abs(candidate.getMatchConfidence() - selected.getMatchConfidence());
                    if (ratio < 0.1) {
                        resolution.put(filter, (EntityResolution)candidate);
                    }
                } else if (candidate.getCost() == 0.0) {
                    resolution.put(filter, (EntityResolution)candidate);
                }
            });
        }
        return resolutionContext;
    }
}

