/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.postprocesor;

import com.ibm.smarts.nlu.resolver.internal.postprocesor.BaseAltSolutionsPostProcessor;
import com.ibm.smarts.nlu.resolver.internal.processor.ProcessingRules;
import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityResolution;
import com.ibm.smarts.nlu.resolver.resolution.entity.ResolverEntity;
import com.ibm.smarts.nlu.resolver.schema.StringUtil;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.MatchReason;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;

public class MinDatasetsPostProcessor
extends BaseAltSolutionsPostProcessor {
    private static final double MAX_CONFIDENCE = 1.0;

    long getTableNum(Map<ResolverEntity, EntityResolution> resolution) {
        return resolution.values().stream().map(EntityResolution::getDatasetId).distinct().count();
    }

    long getTableNum(List<EntityResolution> candidateSolution) {
        return candidateSolution.stream().map(EntityResolution::getDatasetId).distinct().count();
    }

    private Map<ResolverEntity, List<EntityResolution>> getCandidates(ResolutionContext resolutionContext, Map<ResolverEntity, EntityResolution> resolution) {
        HashMap<ResolverEntity, List<EntityResolution>> resolutionCandidates = new HashMap<ResolverEntity, List<EntityResolution>>();
        Predicate<EntityResolution> isKeyTextContained = entityResolution -> {
            String featureLC = entityResolution.getMatchedFeature().getFeature().getFeatureKeyLC();
            Locale locale = resolutionContext.getLocale();
            return featureLC != null && StringUtil.stripText((String)featureLC, (Locale)locale).contains(StringUtil.stripText((String)entityResolution.getNluEntity().getText().toLowerCase(locale), (Locale)locale));
        };
        Predicate<EntityResolution> isEffictiveFullMatch = entityResolution -> entityResolution.getApplicableRules().contains((Object)ProcessingRules.FULL_LEXICAL_MATCH) || entityResolution.getApplicableRules().contains((Object)ProcessingRules.PART_LEXICAL_DATASET_FIELD_MATCH);
        for (Map.Entry<ResolverEntity, EntityResolution> entry : resolution.entrySet()) {
            MatchReason reason = entry.getValue().getMatchReason();
            FeatureType type = entry.getValue().getType();
            List resolutions = resolutionContext.getEntityCandidateMap().getOrDefault(entry.getKey(), Collections.emptyList());
            boolean invokeKeyTextContained = isKeyTextContained.test(entry.getValue());
            boolean invokeEffictiveFullMatch = isEffictiveFullMatch.test(entry.getValue());
            List candidates = resolutions.stream().filter(r -> r.getType().equals((Object)type) && r.getMatchReason().equals((Object)reason)).filter(r -> !invokeKeyTextContained || isKeyTextContained.test((EntityResolution)r)).filter(r -> !invokeEffictiveFullMatch || isEffictiveFullMatch.test((EntityResolution)r)).sorted(Comparator.comparingDouble(EntityResolution::getCost).reversed()).limit(30L).collect(Collectors.toList());
            resolutionCandidates.put(entry.getKey(), candidates);
        }
        return resolutionCandidates;
    }

    @Override
    public ResolutionContext apply(ResolutionContext resolutionContext) {
        Map<ResolverEntity, EntityResolution> resolution = resolutionContext.getEntityResolutionMap();
        ToDoubleFunction<List> calculateCost = solution -> solution.stream().map(EntityResolution::getCost).reduce(0.0, (c1, c2) -> c1 + c2);
        int resolutionSize = resolution.size();
        long minDataset = this.getTableNum(resolution);
        double minDataSetCost = calculateCost.applyAsDouble(new ArrayList<EntityResolution>(resolution.values()));
        List<EntityResolution> bestSolution = new ArrayList<EntityResolution>(resolution.values());
        List highConfidenceResolutions = bestSolution.stream().filter(e -> (double)e.getMatchedFeature().getConfidence() == 1.0).collect(Collectors.toList());
        Map<ResolverEntity, List<EntityResolution>> resolutionCandidates = this.getCandidates(resolutionContext, resolution);
        ArrayList resolutions = new ArrayList(resolutionCandidates.values());
        List candidateSolutions = MinDatasetsPostProcessor.cartesianProduct(resolutions).stream().filter(r -> r.size() == resolutionSize).collect(Collectors.toList());
        boolean solutionChanged = false;
        for (List candidateSolution : candidateSolutions) {
            if (!this.isValidSolution(resolutionContext, candidateSolution, resolution)) continue;
            long numOfDatasets = this.getTableNum(candidateSolution);
            double candidateCost = calculateCost.applyAsDouble(candidateSolution);
            if (numOfDatasets >= minDataset && (!solutionChanged || numOfDatasets != minDataset || Double.compare(minDataSetCost, candidateCost) <= 0)) continue;
            Set highConfidenceSet = highConfidenceResolutions.stream().map(EntityResolution::getNluEntity).collect(Collectors.toSet());
            if (!candidateSolution.stream().allMatch(s -> !highConfidenceSet.contains(s.getNluEntity()) || (double)s.getMatchedFeature().getConfidence() == 1.0)) continue;
            solutionChanged = true;
            minDataset = numOfDatasets;
            bestSolution = candidateSolution;
            minDataSetCost = candidateCost;
        }
        Map<ResolverEntity, EntityResolution> bestEntityMap = bestSolution.stream().collect(Collectors.toMap(EntityResolution::getNluEntity, Function.identity(), (r1, r2) -> r1));
        resolutionContext.setEntityResolutionMap(bestEntityMap);
        return resolutionContext;
    }
}

