/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.processor;

import com.ibm.smarts.conversation.nlu.schema.intent.Aggregator;
import com.ibm.smarts.nlu.resolver.internal.processor.IProcessor;
import com.ibm.smarts.nlu.resolver.internal.processor.ProcessingRules;
import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.internal.utils.Pair;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityResolution;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Aggregation;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Constraint;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.ConstraintType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;

public class AggregationLexicalProcessor
implements IProcessor {
    private static EnumMap<Aggregator, List<String>> aggregatorSynonymMap = new EnumMap(Aggregator.class);

    @Override
    public Pair<ResolutionContext, EntityResolution> apply(Pair<ResolutionContext, EntityResolution> pair) {
        EntityResolution entityResolution = pair.getRight();
        ResolutionContext context = pair.getLeft();
        Optional<Constraint> aggregationOpt = context.getConstraints(entityResolution.getNluEntity()).stream().filter(c -> c.getConstraintType() == ConstraintType.AGGREGATION).findFirst();
        if (aggregationOpt.isPresent()) {
            Aggregation aggregation = (Aggregation)aggregationOpt.get();
            Aggregator aggregator = aggregation.getAggregator();
            String featureName = entityResolution.getMatchedFeature().getFeature().getFeatureKeyLC();
            if (featureName != null) {
                if (aggregatorSynonymMap.getOrDefault(aggregator, Collections.emptyList()).stream().anyMatch(featureName::contains)) {
                    entityResolution.addRule(ProcessingRules.PART_LEXICAL_AGGREGATOR_FIELD_MATCH);
                }
            }
        }
        return pair;
    }

    static {
        aggregatorSynonymMap.put(Aggregator.AVG, Arrays.asList("average", "avg"));
        aggregatorSynonymMap.put(Aggregator.COUNT, Arrays.asList("count", "count of", "how many", "number of"));
        aggregatorSynonymMap.put(Aggregator.MIN, Arrays.asList("min", "minimal", "minimum"));
        aggregatorSynonymMap.put(Aggregator.MAX, Arrays.asList("max", "maximal", "maximum"));
        aggregatorSynonymMap.put(Aggregator.SUM, Arrays.asList("sum", "total"));
    }
}

