/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.processor;

import com.ibm.smarts.nlu.resolver.internal.processor.IProcessor;
import com.ibm.smarts.nlu.resolver.internal.processor.ProcessingRules;
import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.internal.utils.Pair;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityResolution;

public class CostEvaluatorProcessor
implements IProcessor {
    private static final double MATCH_CONFIDENCE_WEIGHT = 0.25;
    private static final double LEXICAL_COST = 1.0;

    @Override
    public Pair<ResolutionContext, EntityResolution> apply(Pair<ResolutionContext, EntityResolution> pair) {
        EntityResolution entityResolution = pair.getRight();
        double rulesCost = entityResolution.getApplicableRules().stream().filter(rule -> !rule.equals((Object)ProcessingRules.PART_LEXICAL_MATCH) && !rule.equals((Object)ProcessingRules.PART_LEMMA_MATCH) && !rule.equals((Object)ProcessingRules.PART_LEXICAL_DATASET_FIELD_MATCH) && !rule.equals((Object)ProcessingRules.PART_LEXICAL_AGGREGATOR_FIELD_MATCH)).map(ProcessingRules::getCost).reduce(0.0, (c1, c2) -> c1 + c2);
        double confidenceCost = 1.0 - entityResolution.getMatchConfidence();
        double maxCost = ProcessingRules.getMaxCost() + 1.0;
        double lexicalCost = entityResolution.getLexicalDistance();
        if (entityResolution.getApplicableRules().contains((Object)ProcessingRules.PART_LEXICAL_DATASET_FIELD_MATCH)) {
            confidenceCost = Math.min(lexicalCost *= ProcessingRules.PART_LEXICAL_DATASET_FIELD_MATCH.getCost(), confidenceCost);
        } else {
            lexicalCost = entityResolution.getApplicableRules().contains((Object)ProcessingRules.PART_LEXICAL_AGGREGATOR_FIELD_MATCH) ? (lexicalCost *= ProcessingRules.PART_LEXICAL_AGGREGATOR_FIELD_MATCH.getCost()) : (entityResolution.getApplicableRules().contains((Object)ProcessingRules.PART_LEMMA_MATCH) ? (lexicalCost *= ProcessingRules.PART_LEMMA_MATCH.getCost()) : (entityResolution.getApplicableRules().contains((Object)ProcessingRules.PART_LEXICAL_MATCH) ? (lexicalCost *= ProcessingRules.PART_LEXICAL_MATCH.getCost()) : 0.0));
        }
        double cost = confidenceCost * 0.25 + (rulesCost + lexicalCost) / maxCost * 0.75;
        entityResolution.setCost(cost);
        return pair;
    }
}

