/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.processor;

import com.ibm.smarts.nlu.resolver.internal.processor.IProcessor;
import com.ibm.smarts.nlu.resolver.internal.processor.ProcessingRules;
import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.internal.utils.Pair;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityResolution;
import com.ibm.smarts.nlu.resolver.schema.StringUtil;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.MatchReason;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class LexicalMatchProcessor
implements IProcessor {
    private static int findLCS(String str1, String str2) {
        int[][] dp = new int[str1.length() + 1][str2.length() + 1];
        for (int i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                dp[i][j] = str1.charAt(i - 1) == str2.charAt(j - 1) ? dp[i - 1][j - 1] + 1 : Math.max(dp[i - 1][j], dp[i][j - 1]);
            }
        }
        return dp[str1.length()][str2.length()];
    }

    private static int findEditDistance(String str1, String str2) {
        int lcs = LexicalMatchProcessor.findLCS(str1, str2);
        return str1.length() + str2.length() - 2 * lcs;
    }

    private Optional<EntityResolution> getMatchingDataset(ResolutionContext context, EntityResolution entityResolution) {
        List<EntityResolution> candidates = context.getEntityCandidateMap().get(entityResolution.getNluEntity());
        return candidates.stream().filter(r -> r.getType().equals((Object)FeatureType.DATASET_NAME)).filter(r -> r.getDatasetId().equals(entityResolution.getDatasetId())).findFirst();
    }

    private boolean isEntityPartiallyContained(ResolutionContext context, EntityResolution entityResolution, String matchText) {
        String[] tokens = entityResolution.getNluEntity().getText().toLowerCase(context.getLocale()).split("\\s+");
        boolean entityPartiallyContained = true;
        for (String token : tokens) {
            if (matchText.contains(token)) continue;
            entityPartiallyContained = false;
            break;
        }
        return entityPartiallyContained;
    }

    @Override
    public Pair<ResolutionContext, EntityResolution> apply(Pair<ResolutionContext, EntityResolution> pair) {
        EntityResolution entityResolution = pair.getRight();
        if (!entityResolution.getType().equals((Object)FeatureType.COLUMN_NAME)) {
            return pair;
        }
        if (entityResolution.getMatchReason().equals((Object)MatchReason.PARTIAL_NAME) || entityResolution.getMatchReason().equals((Object)MatchReason.PARTIAL_LEMMA)) {
            String datasetText;
            Locale locale = pair.getLeft().getLocale();
            String entityText = StringUtil.stripText((String)entityResolution.getNluEntity().getText(), (Locale)locale);
            Optional<EntityResolution> datasetMatch = this.getMatchingDataset(pair.getLeft(), entityResolution);
            String matchText = StringUtil.stripText((String)entityResolution.getMatchedFeature().getFeature().getFeatureKeyLC(), (Locale)locale);
            boolean isDatasetFieldNameMatch = false;
            String combinedText = matchText;
            if (datasetMatch.isPresent() && !(datasetText = StringUtil.stripText((String)datasetMatch.get().getMatchedFeature().getFeature().getFeatureKeyLC(), (Locale)locale)).contains(entityText)) {
                combinedText = StringUtil.stripText((String)datasetMatch.get().getMatchedFeature().getFeature().getFeatureKeyLC(), (Locale)locale) + matchText;
                boolean bl = isDatasetFieldNameMatch = combinedText.contains(StringUtil.stripText((String)entityText, (Locale)locale)) || this.isEntityPartiallyContained(pair.getLeft(), entityResolution, combinedText);
            }
            if (isDatasetFieldNameMatch) {
                matchText = combinedText;
            }
            double cost = (double)LexicalMatchProcessor.findEditDistance(entityText, matchText) / (double)(entityText.length() + matchText.length());
            if (isDatasetFieldNameMatch) {
                entityResolution.removeRules(Arrays.asList(ProcessingRules.PART_LEXICAL_MATCH, ProcessingRules.PART_LEMMA_MATCH));
                entityResolution.addRule(ProcessingRules.PART_LEXICAL_DATASET_FIELD_MATCH);
                entityResolution.setLexicalDistance(cost);
            } else {
                entityResolution.setLexicalDistance(cost);
            }
        } else if (!entityResolution.getMatchReason().equals((Object)MatchReason.FULL)) {
            entityResolution.setLexicalDistance(1.0);
        }
        return pair;
    }
}

