/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.processor;

import com.ibm.smarts.nlu.resolver.internal.processor.IProcessor;
import com.ibm.smarts.nlu.resolver.internal.processor.ProcessingRules;
import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.internal.utils.Pair;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityResolution;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityType;
import com.ibm.smarts.nlu.resolver.resolution.entity.ResolverEntity;
import com.ibm.smarts.schema.MatchReason;

public class NERConformanceProcessor
implements IProcessor {
    private static final double COLUMN_OVERRIDE_THRESHOLD = 0.9;

    @Override
    public Pair<ResolutionContext, EntityResolution> apply(Pair<ResolutionContext, EntityResolution> pair) {
        EntityResolution entityResolution = pair.getRight();
        ResolverEntity entity = entityResolution.getNluEntity();
        MatchReason reason = entityResolution.getMatchReason();
        double confidence = entityResolution.getMatchConfidence();
        if (entity.getType().equals((Object)EntityType.COLUMN)) {
            if (reason.equals((Object)MatchReason.DATA_VALUE) && confidence < 0.9) {
                entityResolution.addRule(ProcessingRules.NER_CONFORMANCE);
            }
        } else if (entity.getType().equals((Object)EntityType.FILTER) && !reason.equals((Object)MatchReason.DATA_VALUE) && !entityResolution.getMatchReason().equals((Object)MatchReason.FULL)) {
            entityResolution.addRule(ProcessingRules.NER_CONFORMANCE);
        }
        return pair;
    }
}

