/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.processor;

import com.ibm.smarts.nlu.resolver.internal.processor.RuleGroup;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public enum ProcessingRules {
    NER_CONFORMANCE(RuleGroup.CONFORMANCE, 8.0),
    FULL_LEXICAL_MATCH(RuleGroup.MATCH_TYPE, 0.0),
    PART_LEXICAL_DATASET_FIELD_MATCH(RuleGroup.MATCH_TYPE, 1.0),
    PART_LEXICAL_AGGREGATOR_FIELD_MATCH(RuleGroup.MATCH_TYPE, 1.0),
    PART_LEXICAL_MATCH(RuleGroup.MATCH_TYPE, 2.0),
    PART_LEMMA_MATCH(RuleGroup.MATCH_TYPE, 3.0),
    FULL_CONCEPT_MATCH(RuleGroup.MATCH_TYPE, 1.0),
    PART_CONCEPT_MATCH(RuleGroup.MATCH_TYPE, 4.0);

    private double cost;
    private RuleGroup group;

    private ProcessingRules(RuleGroup group, double cost) {
        this.cost = cost;
        this.group = group;
    }

    public double getCost() {
        return this.cost;
    }

    public RuleGroup getGroup() {
        return this.group;
    }

    public static double getMaxCost() {
        Map<RuleGroup, List<ProcessingRules>> ruleGroupMap = Arrays.stream(ProcessingRules.values()).collect(Collectors.groupingBy(ProcessingRules::getGroup));
        return ruleGroupMap.values().stream().map(ruleList -> ruleList.stream().map(ProcessingRules::getCost).max(Comparator.comparingDouble(c -> c))).filter(Optional::isPresent).map(Optional::get).reduce(0.0, Double::sum);
    }
}

