/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.processor;

import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.conversation.nlu.schema.intent.Aggregator;
import com.ibm.smarts.nlu.resolver.internal.processor.IProcessor;
import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.internal.utils.Pair;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityResolution;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityType;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Aggregation;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Constraint;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.ConstraintType;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.UsageType;

public class ResolutionWithModifierProcessor
implements IProcessor {
    private void applyAggregationConstraints(EntityResolution entityResolution, Aggregation aggregation, ColumnInfo columnInfo) {
        if (!(columnInfo.getUsage().equals((Object)UsageType.FACT) || aggregation.getAggregator().equals((Object)Aggregator.COUNT_DISTINCT) || aggregation.getAggregator().equals((Object)Aggregator.COUNT))) {
            entityResolution.setCost(Double.MAX_VALUE);
        }
    }

    private void applyExpressionConstraints(EntityResolution entityResolution, ColumnInfo columnInfo) {
        if (columnInfo.getUsage() != UsageType.FACT) {
            entityResolution.setCost(Double.MAX_VALUE);
        }
    }

    @Override
    public Pair<ResolutionContext, EntityResolution> apply(Pair<ResolutionContext, EntityResolution> pair) {
        EntityResolution entityResolution = pair.getRight();
        if (entityResolution.getNluEntity().getType().equals((Object)EntityType.COLUMN) && entityResolution.getType().equals((Object)FeatureType.COLUMN_NAME)) {
            String columnInfoJson = entityResolution.getMatchedFeature().getFeature().getColumnInfo();
            if (columnInfoJson != null && !columnInfoJson.isEmpty()) {
                ColumnInfo columnInfo = (ColumnInfo)CommonJAXBHelper.unmarshalFromJSON(ColumnInfo.class, (String)columnInfoJson);
                for (Constraint constraint : pair.getLeft().getConstraints(entityResolution.getNluEntity())) {
                    if (constraint.getConstraintType().equals((Object)ConstraintType.AGGREGATION) && constraint instanceof Aggregation) {
                        this.applyAggregationConstraints(entityResolution, (Aggregation)constraint, columnInfo);
                        continue;
                    }
                    if (!constraint.getConstraintType().equals((Object)ConstraintType.EXPRESSION)) continue;
                    this.applyExpressionConstraints(entityResolution, columnInfo);
                }
            } else if (entityResolution.getMatchedFeature().getMatchReason() == MatchReason.DATA_VALUE && !pair.getLeft().getConstraints(entityResolution.getNluEntity()).isEmpty()) {
                entityResolution.setCost(Double.MAX_VALUE);
            }
        }
        return pair;
    }
}

