/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.resolver;

import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.intent.Aggregator;
import com.ibm.smarts.conversation.nlu.schema.intent.Order;
import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.internal.utils.TriFunction;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityResolution;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityType;
import com.ibm.smarts.nlu.resolver.resolution.entity.ResolverEntity;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Aggregation;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Constraint;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.ConstraintType;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Expression;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.OrderBy;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.UsageType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class ModifierExpressionAssociator {
    private ModifierExpressionAssociator() {
    }

    static void doBuildExpressions(ResolutionContext context) {
        List<ResolverEntity> operators = context.getNluEntities().stream().filter(e -> e.getType().equals((Object)EntityType.OPERATOR)).collect(Collectors.toList());
        Consumer<ResolverEntity> applyOperator = operator -> {
            int position = context.getEntityPosition((ResolverEntity)operator);
            ResolverEntity operand = null;
            if (position < context.getNluEntities().size() - 1) {
                operand = context.getNluEntities().get(position + 1);
            }
            if (operand != null && operand.getType().equals((Object)EntityType.NUMBER)) {
                Predicate<UsageType> validator;
                ResolverEntity constrained = context.getNluEntities().get(position - 1);
                List<EntityResolution> resolutions = context.getEntityCandidateMap().getOrDefault(constrained, Collections.emptyList());
                if (ModifierExpressionAssociator.isEntityResolvableWithUsage(resolutions, validator = usage -> usage == UsageType.FACT)) {
                    Expression expression = new Expression(constrained.getEntity(), operator.getEntity(), operand.getEntity());
                    context.addConstraint(constrained, (Constraint)expression);
                }
            }
        };
        operators.forEach(applyOperator);
    }

    private static long calculateDistance(Entity sourceEntity, Entity targetEntity) {
        if (sourceEntity.getStart() < targetEntity.getStart()) {
            return targetEntity.getStart() - sourceEntity.getEnd();
        }
        return sourceEntity.getStart() - targetEntity.getEnd();
    }

    static void doModifierAssociation(ResolutionContext context) {
        TriFunction<ResolverEntity, ResolverEntity, ResolutionContext, Boolean> targetSelector = (aColumn, aModifier, aContext) -> {
            List resolutions = aContext.getEntityCandidateMap().getOrDefault(aColumn, Collections.emptyList());
            Aggregator aggregator = aModifier.getAggregator();
            Order order = aModifier.getOrder();
            Predicate<Predicate> isCandidateFound = validator -> ModifierExpressionAssociator.isEntityResolvableWithUsage(resolutions, validator);
            if (aggregator != null) {
                Optional<Constraint> aggregation = aContext.getEntityConstraintMap().getOrDefault(aColumn, Collections.emptyList()).stream().filter(c -> c.getConstraintType() == ConstraintType.AGGREGATION).findAny();
                if (aggregation.isPresent()) {
                    long distance1 = ModifierExpressionAssociator.calculateDistance(aColumn.getEntity(), (Entity)aggregation.get().getEntities().get(0));
                    long distance2 = ModifierExpressionAssociator.calculateDistance(aColumn.getEntity(), aModifier.getEntity());
                    if (distance2 < distance1) {
                        aContext.getEntityConstraintMap().get(aColumn).remove(aggregation.get());
                        return true;
                    }
                    return false;
                }
                if (aggregator.equals((Object)Aggregator.COUNT) || aggregator.equals((Object)Aggregator.COUNT_DISTINCT)) {
                    return true;
                }
                if (Aggregation.getMeasureAgg().contains(aggregator)) {
                    return isCandidateFound.test(u -> u.equals((Object)UsageType.FACT));
                }
                return isCandidateFound.test(u -> !u.equals((Object)UsageType.FACT));
            }
            if (order != null && aModifier.getLimit() != null && aModifier.getLimit().isPercent()) {
                return isCandidateFound.test(u -> !u.equals((Object)UsageType.FACT));
            }
            return true;
        };
        BiPredicate<ResolverEntity, ResolutionContext> sourcesSelector = (entity, aContext) -> entity.getType().equals((Object)EntityType.MODIFIER);
        BiPredicate<ResolverEntity, ResolutionContext> candidatesSelector = (entity, aContext) -> entity.getType().equals((Object)EntityType.COLUMN) && !aContext.getEntityCandidateMap().getOrDefault(entity, Collections.emptyList()).isEmpty();
        BiConsumer<ResolverEntity, ResolverEntity> associator = (column, modifier) -> ModifierExpressionAssociator.addModifierConstraint(context, column, modifier);
        ModifierExpressionAssociator.associateTwoEntities(context, sourcesSelector, candidatesSelector, targetSelector, associator, false);
    }

    private static boolean isEntityResolvableWithUsage(List<EntityResolution> resolutions, Predicate<UsageType> validator) {
        return resolutions.stream().filter(r -> !r.getMatchReason().equals((Object)MatchReason.DATA_VALUE) && r.getType().equals((Object)FeatureType.COLUMN_NAME)).map(EntityResolution::getColInfo).filter(Objects::nonNull).anyMatch(col -> validator.test(col.getUsage()));
    }

    private static void associateLimitWithOrder(ResolutionContext context, ResolverEntity orderByColumn, ResolverEntity limitColumn) {
        Optional<Constraint> limitConstraintOpt;
        EntityResolution orderByResolution = context.getEntityResolutionMap().get(orderByColumn);
        EntityResolution limitResolution = context.getEntityResolutionMap().get(limitColumn);
        if (orderByResolution == null || limitResolution == null) {
            return;
        }
        OrderBy orderedColOrderBy = null;
        OrderBy limitColOrderBy = null;
        UsageType orderByUsage = orderByResolution.getColInfo().getUsage();
        Optional<Constraint> orderByConstraintOpt = context.getConstraints(orderByColumn).stream().filter(c -> c instanceof OrderBy).findFirst();
        if (orderByConstraintOpt.isPresent()) {
            orderedColOrderBy = (OrderBy)orderByConstraintOpt.get();
        }
        if ((limitConstraintOpt = context.getConstraints(limitColumn).stream().filter(c -> c instanceof OrderBy).findFirst()).isPresent()) {
            limitColOrderBy = (OrderBy)limitConstraintOpt.get();
        }
        if (orderedColOrderBy == null || limitColOrderBy == null) {
            return;
        }
        if (!orderByUsage.equals((Object)UsageType.FACT)) {
            String oderByColumnId = limitResolution.getColInfo().getIdForExpression();
            String oderByName = limitResolution.getColInfo().getName();
            orderedColOrderBy.setOrderedById(oderByColumnId);
            orderedColOrderBy.setOrderedByName(oderByName);
            Optional<Constraint> aggregationOpt = context.getConstraints(limitColumn).stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.AGGREGATION)).findFirst();
            if (aggregationOpt.isPresent() && aggregationOpt.get() instanceof Aggregation) {
                Aggregation aggregation = (Aggregation)aggregationOpt.get();
                orderedColOrderBy.setOrderByAggregator(aggregation.getAggregator());
            }
            orderedColOrderBy.setLimit(limitColOrderBy.getLimit());
            orderedColOrderBy.getEntities().addAll(limitColOrderBy.getEntities());
            List<Constraint> constraints = context.getEntityConstraintMap().get(limitColumn);
            constraints.remove(limitColOrderBy);
        } else {
            String oderByColumnId = orderByResolution.getColInfo().getIdForExpression();
            String oderByName = orderByResolution.getColInfo().getName();
            limitColOrderBy.setOrderedById(oderByColumnId);
            limitColOrderBy.setOrderedByName(oderByName);
            limitColOrderBy.setOrder(orderedColOrderBy.getOrder());
            Optional<Constraint> aggregationOpt = context.getConstraints(orderByColumn).stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.AGGREGATION)).findFirst();
            if (aggregationOpt.isPresent() && aggregationOpt.get() instanceof Aggregation) {
                Aggregation aggregation = (Aggregation)aggregationOpt.get();
                limitColOrderBy.setOrderByAggregator(aggregation.getAggregator());
            }
            limitColOrderBy.setLimitWithoutOrder(false);
            limitColOrderBy.getEntities().addAll(0, orderedColOrderBy.getEntities());
            List<Constraint> constraints = context.getEntityConstraintMap().get(orderByColumn);
            constraints.remove(orderedColOrderBy);
        }
    }

    static void doAssociateLimitsWithOrders(ResolutionContext context) {
        BiPredicate<ResolverEntity, ResolutionContext> sourcesSelector = (entity, aContext) -> {
            if (entity.getType().equals((Object)EntityType.COLUMN)) {
                return context.getConstraints((ResolverEntity)entity).stream().anyMatch(c -> c instanceof OrderBy && ((OrderBy)c).isLimitWithoutOrder());
            }
            return false;
        };
        BiPredicate<ResolverEntity, ResolutionContext> candidatesSelector = (entity, aContext) -> {
            if (entity.getType().equals((Object)EntityType.COLUMN)) {
                return context.getConstraints((ResolverEntity)entity).stream().noneMatch(c -> c instanceof OrderBy && ((OrderBy)c).isLimitWithoutOrder());
            }
            return false;
        };
        TriFunction<ResolverEntity, ResolverEntity, ResolutionContext, Boolean> targetSelector = (orderBy, limit, aContext) -> {
            EntityResolution orderByResolution = context.getEntityResolutionMap().get(orderBy);
            EntityResolution limitResolution = context.getEntityResolutionMap().get(limit);
            if (orderByResolution != null && limitResolution != null && orderByResolution.getColInfo() != null && limitResolution.getColInfo() != null) {
                UsageType limitUsage;
                UsageType orderByUsage = orderByResolution.getColInfo().getUsage();
                return orderByUsage != (limitUsage = limitResolution.getColInfo().getUsage());
            }
            return false;
        };
        BiConsumer<ResolverEntity, ResolverEntity> associator = (orderByColumn, limitColumn) -> ModifierExpressionAssociator.associateLimitWithOrder(context, orderByColumn, limitColumn);
        ModifierExpressionAssociator.associateTwoEntities(context, sourcesSelector, candidatesSelector, targetSelector, associator, true);
    }

    static void rejectOrderedEntityWithoutOrderBy(ResolutionContext context) {
        BiPredicate<ResolverEntity, ResolutionContext> sourcesSelector = (entity, aContext) -> {
            if (entity.getType().equals((Object)EntityType.COLUMN)) {
                Optional<Constraint> constraint = context.getConstraints((ResolverEntity)entity).stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.ORDER)).findFirst();
                Optional<Constraint> aggregationOpt = context.getConstraints((ResolverEntity)entity).stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.AGGREGATION)).findFirst();
                if (constraint.isPresent() && constraint.get().getConstraintType().equals((Object)ConstraintType.ORDER)) {
                    Aggregation aggregation;
                    Constraint aggConstraint;
                    EntityResolution resolution = context.getEntityResolutionMap().get(entity);
                    boolean isEffectivelyMeasure = false;
                    if (aggregationOpt.isPresent() && (aggConstraint = aggregationOpt.get()) instanceof Aggregation && ((aggregation = (Aggregation)aggConstraint).getAggregator() == Aggregator.COUNT || aggregation.getAggregator() == Aggregator.COUNT_DISTINCT)) {
                        isEffectivelyMeasure = true;
                    }
                    return resolution != null && resolution.getColInfo() != null && !resolution.getColInfo().getUsage().equals((Object)UsageType.FACT) && !isEffectivelyMeasure;
                }
            }
            return false;
        };
        context.getNluEntities().forEach(e -> {
            if (sourcesSelector.test((ResolverEntity)e, context)) {
                Optional<Constraint> orderOpt = context.getConstraints((ResolverEntity)e).stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.ORDER)).findFirst();
                orderOpt.ifPresent(constraint -> {
                    OrderBy order;
                    if (constraint instanceof OrderBy && (order = (OrderBy)constraint).getOrderedById() == null) {
                        context.getConstraints((ResolverEntity)e).remove(constraint);
                    }
                });
            }
        });
    }

    static void rejectSingleOrderedMeasureEntity(ResolutionContext context) {
        BiPredicate<ResolverEntity, ResolutionContext> sourcesSelector = (entity, aContext) -> {
            Optional<Constraint> constraint;
            if (entity.getType().equals((Object)EntityType.COLUMN) && (constraint = context.getConstraints((ResolverEntity)entity).stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.ORDER)).findFirst()).isPresent() && constraint.get().getConstraintType().equals((Object)ConstraintType.ORDER)) {
                EntityResolution resolution = context.getEntityResolutionMap().get(entity);
                return resolution != null && resolution.getColInfo() != null && resolution.getColInfo().getUsage().equals((Object)UsageType.FACT) && resolution.getColInfo().getDefaultAggregation() != AggregationType.NONE;
            }
            return false;
        };
        if (context.getSearchableEntities().size() == 1) {
            context.getNluEntities().forEach(e -> {
                if (sourcesSelector.test((ResolverEntity)e, context)) {
                    Optional<Constraint> orderOpt = context.getConstraints((ResolverEntity)e).stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.ORDER)).findFirst();
                    orderOpt.ifPresent(constraint -> {
                        OrderBy order;
                        if (constraint instanceof OrderBy && (order = (OrderBy)constraint).getOrderedById() == null) {
                            context.getConstraints((ResolverEntity)e).remove(constraint);
                        }
                    });
                }
            });
        }
    }

    static void doAssociateOrderedEntityWithOrderBy(ResolutionContext context) {
        BiPredicate<ResolverEntity, ResolutionContext> sourcesSelector = (entity, aContext) -> {
            Optional<Constraint> constraint;
            if (entity.getType().equals((Object)EntityType.COLUMN) && (constraint = context.getConstraints((ResolverEntity)entity).stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.ORDER)).findFirst()).isPresent() && constraint.get().getConstraintType().equals((Object)ConstraintType.ORDER)) {
                EntityResolution resolution = context.getEntityResolutionMap().get(entity);
                return resolution != null && resolution.getColInfo() != null && !resolution.getColInfo().getUsage().equals((Object)UsageType.FACT);
            }
            return false;
        };
        BiPredicate<ResolverEntity, ResolutionContext> candidatesSelector = (entity, aContext) -> {
            if (entity.getType().equals((Object)EntityType.COLUMN)) {
                EntityResolution resolution = context.getEntityResolutionMap().get(entity);
                return resolution != null && resolution.getColInfo() != null && (resolution.getColInfo().getUsage().equals((Object)UsageType.FACT) || aContext.getConstraints((ResolverEntity)entity).stream().anyMatch(c -> c.getConstraintType().equals((Object)ConstraintType.AGGREGATION) && c instanceof Aggregation && (((Aggregation)c).getAggregator().equals((Object)Aggregator.COUNT) || ((Aggregation)c).getAggregator().equals((Object)Aggregator.COUNT_DISTINCT))));
            }
            return false;
        };
        BiConsumer<ResolverEntity, ResolverEntity> associator = (orderBy, orderedColumn) -> ModifierExpressionAssociator.addOrderByToOrderedColumn(context, orderedColumn, orderBy);
        TriFunction<ResolverEntity, ResolverEntity, ResolutionContext, Boolean> targetSelector = (aColumn, aModifier, aContext) -> true;
        ModifierExpressionAssociator.associateTwoEntities(context, sourcesSelector, candidatesSelector, targetSelector, associator, true);
    }

    private static void addOrderByToOrderedColumn(ResolutionContext context, ResolverEntity orderedColumn, ResolverEntity orderedBy) {
        Optional<Constraint> constraintOpt = context.getConstraints(orderedColumn).stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.ORDER)).findFirst();
        if (constraintOpt.isPresent() && constraintOpt.get() instanceof OrderBy) {
            OrderBy orderBy = (OrderBy)constraintOpt.get();
            EntityResolution resolution = context.getEntityResolutionMap().get(orderedBy);
            if (resolution != null) {
                Optional<Constraint> orderedByConstraintOpt;
                String orderedById = resolution.getMatchedFeature().getFeature().getIdForExpression();
                orderBy.setOrderedById(orderedById);
                if (resolution.getColInfo() != null) {
                    String orderedByName = resolution.getColInfo().getName();
                    orderBy.setOrderedByName(orderedByName);
                }
                if ((orderedByConstraintOpt = context.getConstraints(orderedBy).stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.AGGREGATION)).findFirst()).isPresent() && orderedByConstraintOpt.get() instanceof Aggregation) {
                    Aggregator aggregator = ((Aggregation)orderedByConstraintOpt.get()).getAggregator();
                    orderBy.setOrderByAggregator(aggregator);
                }
            }
        }
    }

    private static int getCloserPosition(List<Long> positions, long target, int pos1, int pos2) {
        long diff2;
        long diff1 = Math.abs(positions.get(pos1) - target);
        if (diff1 < (diff2 = Math.abs(positions.get(pos2) - target))) {
            return pos1;
        }
        return pos2;
    }

    private static int binarySearch(List<Long> positions, long target) {
        int left = 0;
        int right = positions.size();
        int mid = 0;
        if (target <= positions.get(0)) {
            return 0;
        }
        if (target >= positions.get(positions.size() - 1)) {
            return positions.size() - 1;
        }
        IntPredicate isTargetInCurrentAndNextPos = position -> position < positions.size() - 1 && (Long)positions.get(position + 1) > target;
        IntPredicate isTargetInCurrentAndPreviousPos = position -> position > 0 && (Long)positions.get(position - 1) < target;
        while (left < right) {
            mid = left + (right - left) / 2;
            if (positions.get(mid) == target) {
                return mid;
            }
            if (positions.get(mid) < target) {
                if (isTargetInCurrentAndNextPos.test(mid)) {
                    return ModifierExpressionAssociator.getCloserPosition(positions, target, mid, mid + 1);
                }
                left = mid + 1;
                continue;
            }
            if (isTargetInCurrentAndPreviousPos.test(mid)) {
                return ModifierExpressionAssociator.getCloserPosition(positions, target, mid, mid - 1);
            }
            right = mid;
        }
        return mid;
    }

    private static boolean isCandidatePosValid(ResolverEntity candidate, ResolverEntity modifier, boolean isLeft) {
        return isLeft && candidate.getEnd() <= modifier.getStart() || !isLeft && candidate.getStart() >= modifier.getEnd();
    }

    private static boolean isSearchEnd(int position, boolean isLeft, List<Long> positions) {
        return position == 0 && isLeft || position == positions.size() - 1 && !isLeft;
    }

    private static long nextPosition(List<Long> positions, int currentPos, boolean isLeft) {
        if (isLeft) {
            if (currentPos > 0) {
                return positions.get(currentPos - 1);
            }
            return Long.MAX_VALUE;
        }
        if (currentPos < positions.size() - 1) {
            return positions.get(currentPos + 1);
        }
        return Long.MAX_VALUE;
    }

    private static int findClosestEntity(ResolverEntity modifier, List<Long> positions, Map<Long, ResolverEntity> entityMap, ResolutionContext context, TriFunction<ResolverEntity, ResolverEntity, ResolutionContext, Boolean> isValid, boolean isLeft, boolean skipEntities) {
        if (positions.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        long start = isLeft ? modifier.getStart() : modifier.getEnd();
        boolean isDone = false;
        while (!isDone) {
            int closer = ModifierExpressionAssociator.binarySearch(positions, start);
            ResolverEntity candidate = entityMap.get(positions.get(closer));
            if (ModifierExpressionAssociator.isCandidatePosValid(candidate, modifier, isLeft)) {
                if (isValid.apply(candidate, modifier, context).booleanValue()) {
                    return closer;
                }
                if (!skipEntities) {
                    return Integer.MAX_VALUE;
                }
                start = ModifierExpressionAssociator.nextPosition(positions, closer, isLeft);
                if (start == Long.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
            } else {
                isDone = true;
            }
            if (!ModifierExpressionAssociator.isSearchEnd(closer, isLeft, positions)) continue;
            isDone = true;
        }
        return Integer.MAX_VALUE;
    }

    public static ResolverEntity getClosestEntity(ResolutionContext context, ResolverEntity modifierOrOperator) {
        if (modifierOrOperator.getType() == EntityType.OPERATOR) {
            int position = context.getEntityPosition(modifierOrOperator);
            if (position > 0) {
                return context.getNluEntities().get(position - 1);
            }
            return null;
        }
        if (modifierOrOperator.getType() == EntityType.MODIFIER) {
            ArrayList<Long> startPositions = new ArrayList<Long>();
            ArrayList<Long> endPositions = new ArrayList<Long>();
            HashMap<Long, ResolverEntity> startEntityMap = new HashMap<Long, ResolverEntity>();
            HashMap<Long, ResolverEntity> endEntityMap = new HashMap<Long, ResolverEntity>();
            for (ResolverEntity searchable : context.getSearchableEntities()) {
                startPositions.add(searchable.getStart());
                endPositions.add(searchable.getEnd());
                startEntityMap.put(searchable.getStart(), searchable);
                endEntityMap.put(searchable.getEnd(), searchable);
            }
            long start = modifierOrOperator.getStart();
            long end = modifierOrOperator.getEnd();
            int lCloser = ModifierExpressionAssociator.binarySearch(endPositions, start);
            int rCloser = ModifierExpressionAssociator.binarySearch(startPositions, end);
            long lDistance = Long.MAX_VALUE;
            long rDistance = Long.MAX_VALUE;
            ResolverEntity lCandidate = null;
            ResolverEntity rCandidate = null;
            if (lCloser != Integer.MAX_VALUE) {
                lCandidate = (ResolverEntity)endEntityMap.get(endPositions.get(lCloser));
                lDistance = Math.abs((Long)endPositions.get(lCloser) - modifierOrOperator.getStart());
            }
            if (rCloser != Integer.MAX_VALUE) {
                rCandidate = (ResolverEntity)startEntityMap.get(startPositions.get(rCloser));
                rDistance = Math.abs((Long)startPositions.get(rCloser) - modifierOrOperator.getEnd());
            }
            if (lDistance < rDistance) {
                return lCandidate;
            }
            return rCandidate;
        }
        return null;
    }

    private static void associateTwoEntities(ResolutionContext context, BiPredicate<ResolverEntity, ResolutionContext> sourcesSelector, BiPredicate<ResolverEntity, ResolutionContext> candidatesSelector, TriFunction<ResolverEntity, ResolverEntity, ResolutionContext, Boolean> targetSelector, BiConsumer<ResolverEntity, ResolverEntity> associator, boolean skipEntities) {
        ArrayList<Long> startPositions = new ArrayList<Long>();
        ArrayList<Long> endPositions = new ArrayList<Long>();
        HashMap<Long, ResolverEntity> startEntityMap = new HashMap<Long, ResolverEntity>();
        HashMap<Long, ResolverEntity> endEntityMap = new HashMap<Long, ResolverEntity>();
        for (ResolverEntity searchable : context.getNluEntities()) {
            if (!candidatesSelector.test(searchable, context)) continue;
            startPositions.add(searchable.getStart());
            endPositions.add(searchable.getEnd());
            startEntityMap.put(searchable.getStart(), searchable);
            endEntityMap.put(searchable.getEnd(), searchable);
        }
        for (ResolverEntity modifier : context.getNluEntities()) {
            if (!sourcesSelector.test(modifier, context)) continue;
            int lCloser = ModifierExpressionAssociator.findClosestEntity(modifier, endPositions, endEntityMap, context, targetSelector, true, skipEntities);
            int rCloser = ModifierExpressionAssociator.findClosestEntity(modifier, startPositions, startEntityMap, context, targetSelector, false, skipEntities);
            long lDistance = Long.MAX_VALUE;
            long rDistance = Long.MAX_VALUE;
            ResolverEntity lCandidate = null;
            ResolverEntity rCandidate = null;
            if (lCloser != Integer.MAX_VALUE) {
                lCandidate = (ResolverEntity)endEntityMap.get(endPositions.get(lCloser));
                lDistance = Math.abs((Long)endPositions.get(lCloser) - modifier.getStart());
            }
            if (rCloser != Integer.MAX_VALUE) {
                rCandidate = (ResolverEntity)startEntityMap.get(startPositions.get(rCloser));
                rDistance = Math.abs((Long)startPositions.get(rCloser) - modifier.getEnd());
            }
            if (lDistance < rDistance) {
                associator.accept(lCandidate, modifier);
                continue;
            }
            associator.accept(rCandidate, modifier);
        }
    }

    private static void addOrderByConstraint(ResolutionContext context, ResolverEntity target, ResolverEntity modifier, Order order) {
        Optional<Object> presentConstraint = Optional.ofNullable(context.getConstraints(target).isEmpty() ? null : context.getConstraints(target).get(0));
        OrderBy limit = null;
        if (presentConstraint.isPresent() && presentConstraint.get() instanceof OrderBy) {
            limit = presentConstraint.get();
        }
        OrderBy ordering = new OrderBy(modifier.getEntity(), order, modifier.getLimit());
        if (limit != null) {
            ordering.getEntities().addAll(limit.getEntities());
            ordering.setLimit(limit.getLimit());
            context.getConstraints(target).remove(limit);
        }
        context.addConstraint(target, (Constraint)ordering);
    }

    public static boolean adjustAggregation(EntityResolution column, Aggregation aggregation) {
        if (aggregation.getAggregator().equals((Object)Aggregator.COUNT) && column.getColInfo() != null && column.getColInfo().getUsage() != UsageType.FACT) {
            aggregation.setAggregator(Aggregator.COUNT_DISTINCT);
            return true;
        }
        return false;
    }

    private static void addAggregationConstraint(ResolutionContext context, ResolverEntity target, ResolverEntity modifier, Aggregator aggregator) {
        Aggregation aggregation = new Aggregation(modifier.getEntity(), aggregator);
        context.addConstraint(target, (Constraint)aggregation);
    }

    private static void addLimitConstraint(ResolutionContext context, ResolverEntity target, ResolverEntity modifier) {
        OrderBy ordering = new OrderBy(modifier.getEntity(), modifier.getLimit());
        context.addConstraint(target, (Constraint)ordering);
    }

    private static void addModifierConstraint(ResolutionContext context, ResolverEntity target, ResolverEntity modifier) {
        Aggregator aggregator = modifier.getAggregator();
        Order order = modifier.getOrder();
        if (order != null) {
            ModifierExpressionAssociator.addOrderByConstraint(context, target, modifier, order);
        }
        if (aggregator != null) {
            ModifierExpressionAssociator.addAggregationConstraint(context, target, modifier, aggregator);
        }
        if (ModifierExpressionAssociator.isLimitModifier(modifier)) {
            ModifierExpressionAssociator.addLimitConstraint(context, target, modifier);
        }
    }

    private static boolean isLimitModifier(ResolverEntity modifier) {
        if (modifier.getType().equals((Object)EntityType.MODIFIER)) {
            return modifier.getOrder() == null && modifier.getLimit() != null;
        }
        return false;
    }
}

