/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.resolver;

import com.ibm.bi.platform.moser.common.utils.JoinGraph;
import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.conversation.nlu.schema.intent.Aggregator;
import com.ibm.smarts.nlu.resolver.internal.postprocesor.FilterCombiner;
import com.ibm.smarts.nlu.resolver.internal.postprocesor.FilterOverridePostProcessor;
import com.ibm.smarts.nlu.resolver.internal.postprocesor.FilterPostProcessor;
import com.ibm.smarts.nlu.resolver.internal.postprocesor.MinDatasetsPostProcessor;
import com.ibm.smarts.nlu.resolver.internal.processor.AggregationLexicalProcessor;
import com.ibm.smarts.nlu.resolver.internal.processor.CostEvaluatorProcessor;
import com.ibm.smarts.nlu.resolver.internal.processor.FilterCombinatorProcessor;
import com.ibm.smarts.nlu.resolver.internal.processor.LexicalMatchProcessor;
import com.ibm.smarts.nlu.resolver.internal.processor.MatchTypeProcessor;
import com.ibm.smarts.nlu.resolver.internal.processor.NERConformanceProcessor;
import com.ibm.smarts.nlu.resolver.internal.processor.ProcessingRules;
import com.ibm.smarts.nlu.resolver.internal.processor.ResolutionWithModifierProcessor;
import com.ibm.smarts.nlu.resolver.internal.resolver.ModifierExpressionAssociator;
import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.internal.resolver.strategies.DropFiltersStrategy;
import com.ibm.smarts.nlu.resolver.internal.resolver.strategies.IConstraintSatisfactionStrategy;
import com.ibm.smarts.nlu.resolver.internal.resolver.strategies.ReplaceUnknownsStrategy;
import com.ibm.smarts.nlu.resolver.internal.utils.Pair;
import com.ibm.smarts.nlu.resolver.internal.utils.ResolverUtil;
import com.ibm.smarts.nlu.resolver.internal.utils.graph.Graph;
import com.ibm.smarts.nlu.resolver.internal.utils.graph.Node;
import com.ibm.smarts.nlu.resolver.providers.search.IColumnSearch;
import com.ibm.smarts.nlu.resolver.providers.search.IFilterSearch;
import com.ibm.smarts.nlu.resolver.providers.search.SearchProcessor;
import com.ibm.smarts.nlu.resolver.resolution.INluResolver;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityResolution;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityType;
import com.ibm.smarts.nlu.resolver.resolution.entity.ResolverEntity;
import com.ibm.smarts.nlu.resolver.schema.IJoinGraphProvider;
import com.ibm.smarts.nlu.resolver.schema.IRequestConfig;
import com.ibm.smarts.nlu.resolver.schema.IUnknownEntityResolver;
import com.ibm.smarts.nlu.resolver.schema.UnknownEntityResponse;
import com.ibm.smarts.nlu.resolver.schema.resolution.Resolution;
import com.ibm.smarts.nlu.resolver.schema.resolution.ResolutionResponse;
import com.ibm.smarts.nlu.resolver.schema.resolution.SentenceResolution;
import com.ibm.smarts.nlu.resolver.schema.resolution.UnResolvedEntity;
import com.ibm.smarts.nlu.resolver.schema.resolution.UnResolvedReason;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Aggregation;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Constraint;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.ConstraintType;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Membership;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.OrderBy;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.MatchedEntity;
import com.ibm.smarts.schema.UsageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NluResolver
implements INluResolver {
    private final List<IFilterSearch> filterSearchers = new ArrayList<IFilterSearch>();
    private final List<IColumnSearch> columnSearchers = new ArrayList<IColumnSearch>();
    private IUnknownEntityResolver unknownEntityResolver;
    private IJoinGraphProvider joinGraphProvider;
    private final Function<Pair<ResolutionContext, EntityResolution>, Pair<ResolutionContext, EntityResolution>> processorsPipeline;
    private final Function<ResolutionContext, ResolutionContext> postProcessorsPipeline;
    private final SearchProcessor searchProcessor;
    private List<IConstraintSatisfactionStrategy> resolutionStrategies = new ArrayList<IConstraintSatisfactionStrategy>();
    private static final int MAX_CANDIDATE_SIZE = 30;
    private static final double FILTER_CONFIDENCE_THRESHOLD = 0.9;
    private static final Logger LOGGER = LoggerFactory.getLogger(NluResolver.class);

    public NluResolver(List<IColumnSearch> columnSearchers, List<IFilterSearch> filterSearchers, IUnknownEntityResolver unknownEntityResolver, IJoinGraphProvider iJoinGraphProvider) {
        this.filterSearchers.addAll(filterSearchers);
        this.columnSearchers.addAll(columnSearchers);
        this.joinGraphProvider = iJoinGraphProvider;
        this.searchProcessor = new SearchProcessor();
        this.processorsPipeline = new LexicalMatchProcessor().andThen(new NERConformanceProcessor()).andThen(new MatchTypeProcessor()).andThen(new AggregationLexicalProcessor()).andThen(new FilterCombinatorProcessor()).andThen(new CostEvaluatorProcessor()).andThen(new ResolutionWithModifierProcessor());
        this.postProcessorsPipeline = new MinDatasetsPostProcessor().andThen(new FilterPostProcessor()).andThen(new FilterOverridePostProcessor()).andThen(new FilterCombiner());
        this.unknownEntityResolver = unknownEntityResolver;
        if (unknownEntityResolver != null) {
            this.resolutionStrategies.add(new ReplaceUnknownsStrategy(unknownEntityResolver));
        }
        this.resolutionStrategies.add(new DropFiltersStrategy());
    }

    private static boolean isMultipleSearchableEntity(List<Entity> entities) {
        long searchableEntitiesNum = entities.stream().filter(entity -> entity.getId().equals("column") || entity.getId().equals("filter")).count();
        return searchableEntitiesNum > 1L;
    }

    @Override
    public ResolutionResponse resolve(Locale locale, String moduleId, String sentence, List<Entity> entities, IRequestConfig requestConfig, boolean checkJoins) {
        SentenceResolution sentenceResolution;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\n The moduleId is {}, Before processEntities\n{}", (Object)moduleId, (Object)entities.stream().map(Entity::toString).collect(Collectors.joining("\n")));
        }
        List<Entity> processedEntities = this.processEntities(entities, sentence);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\n The moduleId is {}, After processEntities\n{}", (Object)moduleId, (Object)processedEntities.stream().map(Entity::toString).collect(Collectors.joining("\n")));
        }
        List<ResolverEntity> nluEntities = processedEntities.stream().map(ResolverEntity::new).collect(Collectors.toList());
        HashMap<String, ResolutionContext> contextResolutionsMap = new HashMap<String, ResolutionContext>();
        Optional<SentenceResolution> optimalSolutionOpt = this.findOptimalSolution(locale, moduleId, sentence, nluEntities, contextResolutionsMap, () -> checkJoins && NluResolver.isMultipleSearchableEntity(processedEntities) ? this.joinGraphProvider.getJoinGraph(moduleId) : null);
        Optional specificContextOpt = Optional.ofNullable(contextResolutionsMap.get(moduleId));
        if (!optimalSolutionOpt.isPresent() || !optimalSolutionOpt.get().getUnresolved().isEmpty()) {
            ResolutionContext context2 = specificContextOpt.orElseGet(() -> new ResolutionContext(locale, moduleId, sentence, nluEntities, null));
            contextResolutionsMap.put(context2.getModule(), context2);
            Optional<SentenceResolution> strategySolutionOpt = this.runResolutionStrategies(context2.getModule(), requestConfig, contextResolutionsMap);
            if (strategySolutionOpt.isPresent()) {
                optimalSolutionOpt = strategySolutionOpt;
            }
        }
        List unsupportedList = Collections.emptyList();
        Collection globalContexts = contextResolutionsMap.values();
        if (!globalContexts.isEmpty()) {
            unsupportedList = ((ResolutionContext)globalContexts.iterator().next()).getUnsupportedEntities().stream().map(ResolverEntity::getEntity).collect(Collectors.toList());
        }
        List globalResolutions = contextResolutionsMap.entrySet().stream().filter(e -> !((String)e.getKey()).equals(moduleId)).map(Map.Entry::getValue).map(context -> {
            context.getNluEntities().removeIf(e -> e.getType().equals((Object)EntityType.FILTER));
            return this.getOptimalSolution(this.resolveContext((ResolutionContext)context));
        }).filter(Optional::isPresent).map(Optional::get).filter(res -> res.getResolutions().stream().anyMatch(r -> r.getResolutionType().equals("column"))).sorted(Comparator.comparingInt(sol -> sol.getUnresolved().size()).thenComparing(SentenceResolution::getConfidence)).collect(Collectors.toList());
        specificContextOpt = Optional.ofNullable(contextResolutionsMap.get(moduleId));
        ResolutionContext specificContext = specificContextOpt.orElseGet(() -> new ResolutionContext(locale, moduleId, sentence, nluEntities, null));
        if (optimalSolutionOpt.isPresent()) {
            sentenceResolution = optimalSolutionOpt.get();
            if (!sentenceResolution.getResolutions().isEmpty()) {
                sentenceResolution.getResolutions().sort(Comparator.comparingLong(r -> ((Entity)r.getEntities().get(0)).getStart()));
                sentenceResolution.getUnresolved().addAll(specificContext.getDroppedEntities().stream().map(ResolverEntity::getEntity).map(this::mapDroppedEntities).collect(Collectors.toList()));
            }
        } else {
            sentenceResolution = new SentenceResolution(specificContext.getModule(), specificContext.getSentence(), specificContext.getNluEntities().stream().map(ResolverEntity::getEntity).collect(Collectors.toList()), 0.0);
            List<ResolverEntity> unresolved = specificContext.getDroppedEntities();
            unresolved.addAll(this.getUnknowns(specificContext));
            if (unresolved.isEmpty()) {
                unresolved = specificContext.getNluEntities();
            }
            sentenceResolution.setUnresolved(unresolved.stream().map(ResolverEntity::getEntity).map(this::mapDroppedEntities).collect(Collectors.toList()));
        }
        ResolutionResponse nluResolutionResponse = new ResolutionResponse(moduleId, processedEntities, sentenceResolution, globalResolutions, unsupportedList);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\n NLU resolver resolution response when moduleId is {}\n{}", (Object)moduleId, (Object)nluResolutionResponse.toJSON());
        }
        return nluResolutionResponse;
    }

    @Override
    public ResolutionResponse resolve(Locale locale, String sentence, List<Entity> entities, IRequestConfig requestConfig, boolean checkJoins) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\n The moduleId is null, Before processEntities\n{}", (Object)entities.stream().map(Entity::toString).collect(Collectors.joining("\n")));
        }
        entities = this.processEntities(entities, sentence);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\n The moduleId is null, After processEntities\n{}", (Object)entities.stream().map(Entity::toString).collect(Collectors.joining("\n")));
        }
        List<ResolverEntity> nluEntities = entities.stream().map(ResolverEntity::new).collect(Collectors.toList());
        LinkedHashMap<String, ResolutionContext> moduleToResolutionContext = new LinkedHashMap<String, ResolutionContext>(this.doInitialSearch(locale, null, sentence, nluEntities, () -> null));
        BiPredicate<ResolutionContext, ResolverEntity> unknownInContext = (context, entity) -> context.getEntityCandidateMap().getOrDefault(entity, Collections.emptyList()).isEmpty();
        List columnEntities = nluEntities.stream().filter(e -> e.getType().equals((Object)EntityType.COLUMN) || e.getType().equals((Object)EntityType.FILTER)).collect(Collectors.toList());
        List<ResolverEntity> commonUnknowns = columnEntities.stream().filter(column -> moduleToResolutionContext.values().stream().allMatch(context -> unknownInContext.test((ResolutionContext)context, (ResolverEntity)column))).collect(Collectors.toList());
        if (!commonUnknowns.isEmpty() && this.unknownEntityResolver != null) {
            UnknownEntityResponse response = ResolverUtil.doReplaceUnknowns(this.unknownEntityResolver, commonUnknowns, sentence, requestConfig);
            List<ResolverEntity> updatedColumnEntities = response.getNewEntities().stream().map(ResolverEntity::new).collect(Collectors.toList());
            moduleToResolutionContext.clear();
            moduleToResolutionContext.putAll(this.doInitialSearch(locale, null, sentence, updatedColumnEntities, () -> null));
        }
        LinkedHashMap contextResolutionsMap = new LinkedHashMap();
        moduleToResolutionContext.values().forEach(context -> {
            Optional<SentenceResolution> bestResolutionOpt = this.resolveContext((ResolutionContext)context).stream().filter(res -> res.getResolutions().stream().anyMatch(r -> r.getResolutionType().equals("column"))).min(Comparator.comparingInt(r -> r.getUnresolved().size()).thenComparing(SentenceResolution::getConfidence));
            bestResolutionOpt.ifPresent(bestResolution -> contextResolutionsMap.put(context.getModule(), bestResolution));
        });
        double maxConfidene = Double.MIN_VALUE;
        int minUnresolved = Integer.MAX_VALUE;
        SentenceResolution bestResolution = null;
        for (Map.Entry entry : contextResolutionsMap.entrySet()) {
            Predicate<SentenceResolution> isCandidate = sentenceResolution -> ((SentenceResolution)entry.getValue()).getUnresolved().stream().allMatch(e -> e.getUnresolvedEntity().getId().equals("filter"));
            if ((!isCandidate.test((SentenceResolution)entry.getValue()) || ((SentenceResolution)entry.getValue()).getUnresolved().size() >= minUnresolved) && (((SentenceResolution)entry.getValue()).getUnresolved().size() != minUnresolved || !(((SentenceResolution)entry.getValue()).getConfidence() > maxConfidene))) continue;
            minUnresolved = ((SentenceResolution)entry.getValue()).getUnresolved().size();
            maxConfidene = ((SentenceResolution)entry.getValue()).getConfidence();
            bestResolution = (SentenceResolution)entry.getValue();
        }
        SentenceResolution sentenceResolution2 = null;
        if (bestResolution != null) {
            ResolutionContext topContext = (ResolutionContext)moduleToResolutionContext.get(bestResolution.getModuleId());
            contextResolutionsMap.remove(topContext.getModule());
            sentenceResolution2 = this.createSentenceResolution(topContext, checkJoins && NluResolver.isMultipleSearchableEntity(entities));
        }
        ArrayList globalResolutions = new ArrayList(contextResolutionsMap.values());
        ResolutionResponse nluResolutionResponse = new ResolutionResponse(null, entities, sentenceResolution2, globalResolutions, Collections.emptyList());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\n NLU resolver resolution response when moduleId is null\n{}", (Object)nluResolutionResponse.toJSON());
        }
        return nluResolutionResponse;
    }

    private SentenceResolution createSentenceResolution(ResolutionContext topContext, boolean checkJoins) {
        SentenceResolution sentenceResolution;
        JoinGraph joinGraph = checkJoins ? this.joinGraphProvider.getJoinGraph(topContext.getModule()) : null;
        ResolutionContext mainContext = new ResolutionContext(topContext.getLocale(), topContext.getModule(), topContext.getSentence(), topContext.getNluEntities(), joinGraph);
        mainContext.addEntityCandidateResolutions(topContext.getEntityCandidateMap());
        Optional<SentenceResolution> optimalSolutionOpt = this.getOptimalSolution(this.doCompleteResolution(mainContext));
        if (optimalSolutionOpt.isPresent()) {
            sentenceResolution = optimalSolutionOpt.get();
            if (!sentenceResolution.getResolutions().isEmpty()) {
                sentenceResolution.getResolutions().sort(Comparator.comparingLong(r -> ((Entity)r.getEntities().get(0)).getStart()));
                sentenceResolution.setUnresolved(mainContext.getDroppedEntities().stream().map(ResolverEntity::getEntity).map(this::mapDroppedEntities).collect(Collectors.toList()));
            }
        } else {
            sentenceResolution = new SentenceResolution(mainContext.getModule(), mainContext.getSentence(), mainContext.getNluEntities().stream().map(ResolverEntity::getEntity).collect(Collectors.toList()), 0.0);
            List<ResolverEntity> unresolved = mainContext.getDroppedEntities();
            unresolved.addAll(this.getUnknowns(mainContext));
            sentenceResolution.setUnresolved(unresolved.stream().map(ResolverEntity::getEntity).map(this::mapDroppedEntities).collect(Collectors.toList()));
        }
        return sentenceResolution;
    }

    private List<Entity> processEntities(List<Entity> inEntities, String sentence) {
        if (inEntities.isEmpty()) {
            Entity column = new Entity("column", sentence, 0L, (long)sentence.length(), null);
            ArrayList<Entity> entities = new ArrayList<Entity>();
            entities.add(column);
            return entities;
        }
        inEntities.sort(Comparator.comparing(Entity::getStart));
        HashSet<Entity> containedEntities = new HashSet<Entity>();
        for (int i = 0; i < inEntities.size(); ++i) {
            for (int j = i + 1; j < inEntities.size(); ++j) {
                if (inEntities.get(j).getStart() < inEntities.get(i).getStart() || inEntities.get(j).getEnd() > inEntities.get(i).getEnd() || !Objects.equals(inEntities.get(j).getExtractor(), inEntities.get(i).getExtractor())) continue;
                containedEntities.add(inEntities.get(j));
            }
        }
        inEntities.removeAll(containedEntities);
        return inEntities;
    }

    private List<ResolverEntity> getUnknowns(ResolutionContext context) {
        return context.getSearchableEntities().stream().filter(e -> context.entityCandidateMap.get(e) == null).collect(Collectors.toList());
    }

    private Optional<SentenceResolution> runResolutionStrategies(String moduleId, IRequestConfig requestConfig, Map<String, ResolutionContext> contextResolutionsMap) {
        Optional<SentenceResolution> optimalSolutionOpt = Optional.empty();
        for (IConstraintSatisfactionStrategy strategy : this.resolutionStrategies) {
            ResolutionContext context = contextResolutionsMap.get(moduleId);
            Map<Boolean, List<ResolverEntity>> entityPart = context.getSearchableEntities().stream().collect(Collectors.partitioningBy(r -> r.getType().equals((Object)EntityType.COLUMN)));
            List<ResolverEntity> unknowns = this.getUnknowns(context);
            ResolutionContext updatedContext = strategy.apply(context, requestConfig, unknowns, entityPart.get(true), entityPart.get(false));
            if (updatedContext.equals(context)) continue;
            contextResolutionsMap.put(moduleId, updatedContext);
            optimalSolutionOpt = this.findOptimalSolution(updatedContext.getLocale(), updatedContext.getModule(), updatedContext.getSentence(), updatedContext.getNluEntities(), contextResolutionsMap, updatedContext::getJoinGraph);
            if (!optimalSolutionOpt.isPresent()) continue;
            break;
        }
        return optimalSolutionOpt;
    }

    private void doColumnSearch(ResolutionContext context, List<ResolverEntity> searchableEntities) {
        for (IColumnSearch searcher : this.columnSearchers) {
            List<MatchedEntity> results = searcher.search(context.getModule(), searchableEntities.stream().map(ResolverEntity::getEntity).collect(Collectors.toList()));
            this.searchProcessor.accept(results, context);
        }
    }

    private double calculateCombinedResolutionCost(EntityResolution candidate1, EntityResolution candidate2) {
        if (candidate1.getCost() == Double.MAX_VALUE || candidate2.getCost() == Double.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        return candidate1.getCost() + candidate2.getCost();
    }

    private Optional<EntityResolution> getTopCandidate(List<EntityResolution> resolutions) {
        return resolutions.stream().filter(r -> r.getMatchReason() == MatchReason.DATA_VALUE && r.getMatchedFeature().getFeatureType() == FeatureType.COLUMN_NAME).max(Comparator.comparingDouble(EntityResolution::getMatchConfidence));
    }

    private boolean isFilterEntity(ResolutionContext context, ResolverEntity entity, EntityResolution topCandidate) {
        List candidates = context.getEntityCandidateMap().getOrDefault(entity, Collections.emptyList());
        Predicate<List> hasFullLexicalMatch = resolutions -> resolutions.stream().anyMatch(r -> r.getMatchReason() == MatchReason.FULL && r.getMatchedFeature().getFeatureType() == FeatureType.COLUMN_NAME);
        return entity.getType().equals((Object)EntityType.FILTER) && !hasFullLexicalMatch.test(candidates) || !entity.getType().equals((Object)EntityType.FILTER) && (topCandidate.getMatchConfidence() >= 0.9 || candidates.stream().allMatch(c -> c.getMatchReason() == MatchReason.DATA_VALUE));
    }

    private List<ResolverEntity> getTrueColumns(ResolutionContext context) {
        Map<Boolean, List<ResolverEntity>> partition = context.getSearchableEntities().stream().collect(Collectors.groupingBy(e -> {
            List<EntityResolution> candidates = context.getEntityCandidateMap().getOrDefault(e, Collections.emptyList());
            Optional<EntityResolution> topCandidateOpt = this.getTopCandidate(candidates);
            if (topCandidateOpt.isPresent()) {
                return this.isFilterEntity(context, (ResolverEntity)e, topCandidateOpt.get());
            }
            return e.getType() == EntityType.FILTER;
        }));
        return partition.getOrDefault(false, Collections.emptyList());
    }

    private Graph<EntityResolution> buildGraph(ResolutionContext context) {
        List<ResolverEntity> columns = this.getTrueColumns(context);
        List entities = context.getSearchableEntities().stream().filter(e -> columns.contains(e) || context.getFilterCombinationMap().containsKey(e)).sorted(Comparator.comparingLong(ResolverEntity::getStart)).collect(Collectors.toList());
        Graph<EntityResolution> graph = new Graph<EntityResolution>();
        for (ResolverEntity entity : entities) {
            for (EntityResolution resolution : context.getColumnEntityResolutions(entity)) {
                String id = resolution.getMatchedFeature().getFeature().getIdForExpression();
                graph.addNode(new Node<EntityResolution>(entity.getText() + entity.getStart(), id, resolution, resolution.getCost()));
            }
        }
        BiConsumer<ResolverEntity, ResolverEntity> connectEntities = (source, destination) -> {
            for (EntityResolution candidate1 : context.getColumnEntityResolutions((ResolverEntity)source)) {
                for (EntityResolution candidate2 : context.getColumnEntityResolutions((ResolverEntity)destination)) {
                    double cost;
                    String id2;
                    ArrayList<String> ids = new ArrayList<String>();
                    String id1 = candidate1.getMatchedFeature().getFeature().getIdForExpression();
                    if (id1.equals(id2 = candidate2.getMatchedFeature().getFeature().getIdForExpression()) && context.getEntityConstraintMap().getOrDefault(candidate2.getNluEntity(), Collections.emptyList()).stream().noneMatch(c -> c.getConstraintType() == ConstraintType.EXPRESSION) && !context.getFilterResolutionMap().containsKey(candidate2.getNluEntity())) continue;
                    ids.add(id1);
                    ids.add(id2);
                    if (!ResolverUtil.isJoined(context.getJoinGraph(), ids) || !((cost = this.calculateCombinedResolutionCost(candidate1, candidate2)) < Double.MAX_VALUE)) continue;
                    graph.addEdge(graph.getVertex(candidate1), graph.getVertex(candidate2), candidate1.getCost(), candidate2.getCost());
                }
            }
        };
        for (int i = 0; i < entities.size() - 1; ++i) {
            connectEntities.accept((ResolverEntity)entities.get(i), (ResolverEntity)entities.get(i + 1));
        }
        return graph;
    }

    private Resolution createFilterResolution(ResolutionContext context, EntityResolution entityResolution, List<ResolverEntity> combinedInclusions, List<ResolverEntity> combinedExclusions) {
        ArrayList entities = new ArrayList();
        Membership inclConstraint = null;
        Membership exclConstraint = null;
        if (!combinedInclusions.isEmpty()) {
            ArrayList inclMembers = new ArrayList();
            List inclEntities = combinedInclusions.stream().map(ResolverEntity::getEntity).collect(Collectors.toList());
            combinedInclusions.forEach(m -> inclMembers.add(m.getText()));
            inclConstraint = new Membership(inclEntities, context.getSentence(), inclMembers);
            entities.addAll(inclEntities);
        }
        if (!combinedExclusions.isEmpty()) {
            ArrayList exclMembers = new ArrayList();
            List exclEntities = combinedExclusions.stream().map(ResolverEntity::getEntity).collect(Collectors.toList());
            combinedExclusions.forEach(m -> exclMembers.add(m.getText()));
            exclConstraint = new Membership(exclEntities, context.getSentence(), exclMembers);
            entities.addAll(exclEntities);
        }
        Resolution resolution = new Resolution(entities.stream().distinct().collect(Collectors.toList()), context.getModule(), entityResolution.getDatasetId(), entityResolution.getColInfo(), EntityType.FILTER.getId());
        resolution.setColId(entityResolution.getMatchedFeature().getFeature().getIdForExpression());
        if (inclConstraint != null) {
            resolution.addConstraint((Constraint)inclConstraint);
        }
        if (exclConstraint != null) {
            resolution.addConstraint((Constraint)exclConstraint);
        }
        return resolution;
    }

    private List<Resolution> buildFilterResolutions(ResolutionContext context, List<EntityResolution> filters) {
        Function<EntityResolution, Stream> getFilterResolutions = filter -> {
            ArrayList<ResolverEntity> combinedInclusions = new ArrayList<ResolverEntity>();
            ArrayList<ResolverEntity> combinedExclusions = new ArrayList<ResolverEntity>();
            ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
            ArrayList<ResolverEntity> combinedFilters = new ArrayList<ResolverEntity>();
            combinedFilters.add(filter.getNluEntity());
            combinedFilters.addAll(context.getFilterCombinationMap().getOrDefault(filter.getNluEntity(), Collections.emptyList()));
            combinedFilters.forEach(f -> {
                if (Membership.isInclusionMembership((String)context.getSentence(), (Entity)f.getEntity())) {
                    combinedInclusions.add((ResolverEntity)f);
                } else {
                    combinedExclusions.add((ResolverEntity)f);
                }
            });
            if (!combinedInclusions.isEmpty() || !combinedExclusions.isEmpty()) {
                resolutions.add(this.createFilterResolution(context, (EntityResolution)filter, (List<ResolverEntity>)combinedInclusions, (List<ResolverEntity>)combinedExclusions));
            }
            return resolutions.stream();
        };
        return filters.stream().filter(f -> context.getFilterCombinationMap().containsKey(f.getNluEntity())).flatMap(getFilterResolutions).collect(Collectors.toList());
    }

    private Resolution buildColumnResolution(ResolutionContext context, EntityResolution target) {
        ArrayList<Entity> nluEntities = new ArrayList<Entity>();
        ResolverEntity nluEntity = target.getNluEntity();
        nluEntities.add(nluEntity.getEntity());
        List<Constraint> constraints = context.getConstraints(target.getNluEntity());
        Optional<Constraint> aggregationOpt = constraints.stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.AGGREGATION)).findFirst();
        if (aggregationOpt.isPresent() && target.getApplicableRules().contains((Object)ProcessingRules.PART_LEXICAL_AGGREGATOR_FIELD_MATCH)) {
            Aggregation aggregation = (Aggregation)aggregationOpt.get();
            constraints.remove(aggregation);
            nluEntities.addAll(aggregation.getEntities());
        }
        Resolution resolution = new Resolution(nluEntities, context.getModule(), target.getDatasetId(), target.getColInfo(), EntityType.COLUMN.getId());
        resolution.setColId(target.getMatchedFeature().getFeature().getIdForExpression());
        resolution.setConstraints(context.getConstraints(nluEntity));
        return resolution;
    }

    private List<Resolution> buildColumnResolutions(ResolutionContext context, List<EntityResolution> columns) {
        HashMap<String, Aggregator> colsWithChangedAggregation = new HashMap<String, Aggregator>();
        for (EntityResolution column : columns) {
            Aggregation aggregation;
            boolean adjustedAggregation;
            List<Constraint> constraints = context.getConstraints(column.getNluEntity());
            Optional<Constraint> isAggregationConstraint = constraints.stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.AGGREGATION)).findAny();
            if (!isAggregationConstraint.isPresent() || !(adjustedAggregation = ModifierExpressionAssociator.adjustAggregation(column, aggregation = (Aggregation)isAggregationConstraint.get()))) continue;
            colsWithChangedAggregation.put(column.getColInfo().getIdForExpression(), Aggregator.COUNT_DISTINCT);
        }
        context.getEntityConstraintMap().values().stream().flatMap(list -> list.stream().filter(c -> c.getConstraintType().equals((Object)ConstraintType.ORDER))).forEach(order -> {
            Aggregator byColAggr;
            OrderBy orderBy = (OrderBy)order;
            if (orderBy.getOrderedById() != null && (byColAggr = (Aggregator)colsWithChangedAggregation.get(orderBy.getOrderedById())) != null) {
                orderBy.setOrderByAggregator(byColAggr);
            }
        });
        return columns.stream().map(c -> this.buildColumnResolution(context, (EntityResolution)c)).collect(Collectors.toList());
    }

    private UnResolvedEntity createUnresolvedEntity(ResolutionContext context, ResolverEntity entity, List<EntityResolution> trueColumns) {
        if (entity.getType() == EntityType.MODIFIER || entity.getType() == EntityType.OPERATOR) {
            ResolverEntity relatedEntity = ModifierExpressionAssociator.getClosestEntity(context, entity);
            UnResolvedReason reason = UnResolvedReason.MODIFIED_ENTITY_NOT_FOUND;
            if (entity.getLimit() != null && entity.getLimit().isPercent()) {
                reason = UnResolvedReason.INVALID_PERCENTAGE_ORDER_CONSTRAINT;
            } else if (entity.getAggregator() != null) {
                reason = UnResolvedReason.INVALID_AGGREGATION_CONSTRAINT;
            } else if (entity.getOrder() != null && relatedEntity != null) {
                EntityResolution resolution = context.getEntityResolutionMap().get(relatedEntity);
                if (resolution != null && resolution.getColInfo() != null) {
                    reason = resolution.getColInfo().getUsage() != UsageType.FACT ? UnResolvedReason.MISSING_ORDER_BY_ENTITY_ORDER_CONSTRAINT : (trueColumns.size() == 1 ? UnResolvedReason.INVALID_SINGLE_MEASURE_ORDER_CONSTRAINT : UnResolvedReason.MISSING_ORDER_BY_ENTITY_ORDER_CONSTRAINT);
                }
            } else if (entity.getType() == EntityType.OPERATOR && relatedEntity != null) {
                reason = UnResolvedReason.INVALID_MEASURE_EXPRESSION_CONSTRAINT;
            }
            EntityResolution relatedEntityResolution = context.getEntityResolutionMap().get(relatedEntity);
            String relatedEntityResolutionId = null;
            if (relatedEntityResolution != null) {
                relatedEntityResolutionId = relatedEntityResolution.getMatchedFeature().getFeature().getIdForExpression();
                if (relatedEntityResolution.getColInfo() != null) {
                    relatedEntityResolutionId = relatedEntityResolution.getColInfo().getName();
                }
            }
            return new UnResolvedEntity(entity.getEntity(), relatedEntity != null ? relatedEntity.getEntity() : null, relatedEntityResolutionId, reason);
        }
        return new UnResolvedEntity(entity.getEntity());
    }

    private SentenceResolution buildSentenceResolution(ResolutionContext context) {
        boolean unjoinable = false;
        if (context.getEntityResolutionMap().isEmpty()) {
            HashMap<ResolverEntity, EntityResolution> entityResolutionMap = new HashMap<ResolverEntity, EntityResolution>();
            context.getNluEntities().forEach(e -> {
                List entityResolutions = context.getEntityCandidateMap().getOrDefault(e, Collections.emptyList());
                Optional<EntityResolution> bestResolutionOpt = entityResolutions.stream().filter(r -> r.getMatchedFeature().getFeatureType() == FeatureType.COLUMN_NAME).filter(r -> r.getCost() < Double.MAX_VALUE).min(Comparator.comparingDouble(EntityResolution::getCost));
                bestResolutionOpt.ifPresent(r -> entityResolutionMap.put((ResolverEntity)e, (EntityResolution)r));
            });
            context.setEntityResolutionMap(entityResolutionMap);
            unjoinable = context.getJoinGraph() != null && context.getSearchableEntities().size() == context.getEntityResolutionMap().size();
        }
        Map<Boolean, List<EntityResolution>> partition = context.getEntityResolutionMap().values().stream().collect(Collectors.partitioningBy(r -> r.getMatchedFeature().getMatchReason().equals((Object)MatchReason.DATA_VALUE)));
        List filterEntities = partition.getOrDefault(true, Collections.emptyList()).stream().map(e -> e.getNluEntity().getEntity()).collect(Collectors.toList());
        List<EntityResolution> trueColumns = partition.getOrDefault(false, Collections.emptyList()).stream().filter(c -> !filterEntities.contains(c.getNluEntity().getEntity())).collect(Collectors.toList());
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        resolutions.addAll(this.buildColumnResolutions(context, trueColumns));
        resolutions.addAll(this.buildFilterResolutions(context, partition.getOrDefault(true, Collections.emptyList())));
        Set constraints = resolutions.stream().flatMap(r -> r.getConstraints().stream()).filter(Objects::nonNull).flatMap(c -> c.getEntities().stream()).collect(Collectors.toSet());
        Predicate<ResolverEntity> isResolvedNumber = numberEntity -> {
            if (numberEntity.getType().equals((Object)EntityType.NUMBER)) {
                if (constraints.stream().anyMatch(c -> c.getStart() == numberEntity.getStart() && c.getEnd() == numberEntity.getEnd() && c.getText().equals(numberEntity.getText()))) {
                    return true;
                }
                return context.getNluEntities().stream().filter(r -> !r.getType().equals((Object)EntityType.NUMBER)).anyMatch(r -> r.getStart() <= numberEntity.getStart() && r.getEnd() >= numberEntity.getEnd());
            }
            return false;
        };
        Set containedInResolutions = resolutions.stream().flatMap(r -> r.getEntities().stream()).collect(Collectors.toSet());
        Set unresolved = context.getNluEntities().stream().filter(e -> !context.getEntityResolutionMap().containsKey(e)).filter(e -> !containedInResolutions.contains(e.getEntity()) && !constraints.contains(e.getEntity()) && !isResolvedNumber.test((ResolverEntity)e)).collect(Collectors.toSet());
        List unResolvedEntities = unresolved.stream().map(u -> this.createUnresolvedEntity(context, (ResolverEntity)u, trueColumns)).sorted(Comparator.comparingLong(e -> e.getUnresolvedEntity().getStart())).collect(Collectors.toList());
        unResolvedEntities.addAll(context.getDroppedEntities().stream().map(ResolverEntity::getEntity).map(this::mapDroppedEntities).collect(Collectors.toList()));
        double totalCost = context.getEntityResolutionMap().values().stream().map(EntityResolution::getCost).reduce(0.0, Double::sum);
        int numberOfResolutions = context.getEntityResolutionMap().values().size();
        double confidence = 0.0;
        if (totalCost < (double)numberOfResolutions && numberOfResolutions > 0) {
            confidence = ((double)numberOfResolutions - totalCost) / (double)numberOfResolutions;
        }
        SentenceResolution solution = new SentenceResolution(context.getModule(), context.getSentence(), context.getNluEntities().stream().map(ResolverEntity::getEntity).collect(Collectors.toList()), confidence);
        solution.addNluResolutions(resolutions);
        solution.setUnresolved(unResolvedEntities);
        solution.setUnjoinable(unjoinable);
        return solution;
    }

    private void doFilterSearch(ResolutionContext context, List<ResolverEntity> searchableEntities) {
        for (IFilterSearch searcher : this.filterSearchers) {
            List<MatchedEntity> results = searcher.search(context.getModule(), searchableEntities.stream().map(ResolverEntity::getEntity).collect(Collectors.toList()));
            this.searchProcessor.accept(results, context);
        }
    }

    private void doSearch(ResolutionContext context) {
        List<ResolverEntity> searchableEntities = context.getSearchableEntities();
        this.doColumnSearch(context, searchableEntities);
        this.doFilterSearch(context, searchableEntities);
    }

    private void doColumnSearch(ResolutionContext context) {
        List<ResolverEntity> searchableEntities = context.getSearchableEntities();
        for (IColumnSearch searcher : this.columnSearchers) {
            List<MatchedEntity> results = context.getModule() != null ? searcher.search(context.getModule(), searchableEntities.stream().map(ResolverEntity::getEntity).collect(Collectors.toList())) : searcher.search(searchableEntities.stream().map(ResolverEntity::getEntity).collect(Collectors.toList()));
            this.searchProcessor.accept(results, context);
        }
    }

    private void doProcessResolutionPipeline(ResolutionContext context) {
        context.getEntityCandidateMap().forEach((k, v) -> v.stream().map(c -> new Pair<ResolutionContext, EntityResolution>(context, (EntityResolution)c)).forEach(this.processorsPipeline::apply));
    }

    private void doOptimalResolution(ResolutionContext context, Map<ResolverEntity, EntityResolution> solution) {
        if (context.joinGraph == null) {
            List<ResolverEntity> entities = context.getSearchableEntities();
            entities.forEach(entity -> {
                Optional<EntityResolution> resolutionOpt = context.getColumnEntityResolutions((ResolverEntity)entity).stream().filter(r -> r.getCost() < Double.MAX_VALUE).min(Comparator.comparingDouble(EntityResolution::getCost));
                resolutionOpt.ifPresent(r -> solution.put((ResolverEntity)entity, (EntityResolution)r));
            });
        } else {
            Graph<EntityResolution> graph = this.buildGraph(context);
            List<EntityResolution> path = graph.findBestPath();
            solution.putAll(path.stream().collect(Collectors.toMap(EntityResolution::getNluEntity, Function.identity(), (r1, r2) -> r1)));
        }
    }

    private Map<ResolverEntity, EntityResolution> doContextResolution(ResolutionContext context) {
        this.doProcessResolutionPipeline(context);
        HashMap<ResolverEntity, EntityResolution> resolution = new HashMap<ResolverEntity, EntityResolution>();
        if (context.getSearchableEntities().size() == 1) {
            ResolverEntity entity2 = context.getSearchableEntities().get(0);
            Optional<EntityResolution> topResolution = context.getEntityCandidateMap().getOrDefault(entity2, Collections.emptyList()).stream().filter(e -> e.getMatchedFeature().getFeatureType().equals((Object)FeatureType.COLUMN_NAME)).min(Comparator.comparingDouble(EntityResolution::getCost));
            topResolution.ifPresent(top -> resolution.put(entity2, (EntityResolution)top));
        } else {
            context.getEntityCandidateMap().replaceAll((entity, candidates) -> candidates.stream().sorted(Comparator.comparingDouble(EntityResolution::getCost)).limit(30L).collect(Collectors.toList()));
            if (LOGGER.isDebugEnabled()) {
                Map<ResolverEntity, List<EntityResolution>> entityCandidateMap = context.getEntityCandidateMap();
                LOGGER.debug("\nCandidateMap is \n{}", (Object)entityCandidateMap.entrySet().stream().map(e -> "\nResolver for New Entity Start\n" + ((ResolverEntity)e.getKey()).toString() + "\n" + ((List)e.getValue()).stream().map(EntityResolution::toString).collect(Collectors.joining("\n"))).collect(Collectors.joining("\n")));
            }
            this.doOptimalResolution(context, resolution);
        }
        return resolution;
    }

    private SentenceResolution processResolutionContext(ResolutionContext context) {
        Map<ResolverEntity, EntityResolution> resolution = this.doContextResolution(context);
        context.setEntityResolutionMap(resolution);
        this.postProcessorsPipeline.apply(context);
        ModifierExpressionAssociator.doAssociateOrderedEntityWithOrderBy(context);
        ModifierExpressionAssociator.doAssociateLimitsWithOrders(context);
        ModifierExpressionAssociator.rejectOrderedEntityWithoutOrderBy(context);
        ModifierExpressionAssociator.rejectSingleOrderedMeasureEntity(context);
        return this.buildSentenceResolution(context);
    }

    private void combineSplitColumnWithLexicalMatch(ResolutionContext context, List<ResolverEntity> columns) {
        columns.sort(Comparator.comparingLong(ResolverEntity::getStart));
        Map<ResolverEntity, Optional> resolutionSetToLexicalMap = columns.stream().collect(Collectors.toMap(e -> e, e -> {
            List resolutions = context.getEntityCandidateMap().getOrDefault(e, Collections.emptyList()).stream().filter(r -> (r.getMatchReason().equals((Object)MatchReason.PARTIAL_NAME) || r.getMatchReason().equals((Object)MatchReason.FULL)) && r.getMatchedFeature().getFeatureType().equals((Object)FeatureType.COLUMN_NAME)).collect(Collectors.toList());
            Optional<Pair> maxLexicalMatchOpt = resolutions.stream().map(r -> {
                ResolverEntity column;
                String columnText;
                int containedEntityCount = 0;
                List columnsToExamine = columns.subList(columns.indexOf(e), columns.size());
                String matchedFeature = r.getMatchedFeature().getFeature().getFeatureKeyLC();
                Iterator iterator = columnsToExamine.iterator();
                while (iterator.hasNext() && matchedFeature.contains(columnText = (column = (ResolverEntity)iterator.next()).getText().toLowerCase())) {
                    ++containedEntityCount;
                }
                return new Pair<String, Integer>(matchedFeature, containedEntityCount);
            }).max(Comparator.comparingInt(pair -> {
                if (context.getSentence().toLowerCase().contains((CharSequence)pair.getLeft())) {
                    return 1;
                }
                return 0;
            }).thenComparing(Pair::getRight).thenComparing(Comparator.comparingInt(pair -> ((String)pair.getLeft()).length()).reversed()));
            if (maxLexicalMatchOpt.isPresent() && (Integer)maxLexicalMatchOpt.get().getRight() > 0) {
                return Optional.of(maxLexicalMatchOpt.get().getLeft());
            }
            return Optional.empty();
        }, (a, b) -> a));
        columns.sort(Comparator.comparingInt(col -> {
            Optional matchOpt = resolutionSetToLexicalMap.getOrDefault(col, Optional.empty());
            if (matchOpt.isPresent()) {
                return ((String)matchOpt.get()).length();
            }
            return 0;
        }).reversed());
        ArrayList<ResolverEntity> finalNluEntities = new ArrayList<ResolverEntity>();
        HashSet<ResolverEntity> processedNluEntities = new HashSet<ResolverEntity>();
        HashSet<ResolverEntity> containerEntities = new HashSet<ResolverEntity>();
        HashSet<ResolverEntity> containedModifiers = new HashSet<ResolverEntity>();
        ArrayList<ResolverEntity> copyColumns = new ArrayList<ResolverEntity>(context.getNluEntities());
        copyColumns.sort(Comparator.comparingLong(ResolverEntity::getStart));
        for (int i = 0; i < columns.size(); ++i) {
            ResolverEntity col2;
            String columnText;
            ResolverEntity column = columns.get(i);
            Optional matchTextOpt = resolutionSetToLexicalMap.getOrDefault(column, Optional.empty());
            if (!matchTextOpt.isPresent()) {
                processedNluEntities.add(column);
                finalNluEntities.add(column);
                continue;
            }
            String matchText = (String)matchTextOpt.get();
            List columnsToExamine = copyColumns.subList(copyColumns.indexOf(column), copyColumns.size());
            int startIndex = (int)((ResolverEntity)columnsToExamine.get(0)).getStart();
            int endIndex = (int)((ResolverEntity)columnsToExamine.get(0)).getEnd();
            Iterator iterator = columnsToExamine.iterator();
            while (iterator.hasNext() && matchText.contains(columnText = (col2 = (ResolverEntity)iterator.next()).getText().toLowerCase()) && this.canSwallow(matchText, columnText, context.getSentence().toLowerCase()) && !matchText.equals(columnText)) {
                endIndex = (int)col2.getEnd();
                if (col2.getType() != EntityType.MODIFIER && col2.getType() != EntityType.OPERATOR && col2.getType() != EntityType.NUMBER) continue;
                containedModifiers.add(col2);
                containerEntities.add(column);
            }
            if (processedNluEntities.contains(column)) continue;
            finalNluEntities.add(column);
            for (int j = i + 1; j < columns.size(); ++j) {
                ResolverEntity column2 = columns.get(j);
                if ((long)startIndex > column2.getStart() || column2.getEnd() > (long)endIndex || matchText.length() <= column2.getText().length()) continue;
                containerEntities.add(column);
                processedNluEntities.add(column2);
            }
        }
        finalNluEntities.forEach(entity -> {
            if (resolutionSetToLexicalMap.containsKey(entity) && ((Optional)resolutionSetToLexicalMap.get(entity)).isPresent()) {
                String longestMatchAvailable = (String)((Optional)resolutionSetToLexicalMap.get(entity)).get();
                if (containerEntities.contains(entity)) {
                    List matches = context.getEntityCandidateMap().getOrDefault(entity, Collections.emptyList()).stream().filter(e -> e.getMatchedFeature().getMatchReason() != MatchReason.DATA_VALUE && e.getMatchedFeature().getFeature().getFeatureKeyLC().equals(longestMatchAvailable)).collect(Collectors.toList());
                    context.getEntityCandidateMap().put((ResolverEntity)entity, matches);
                }
            }
        });
        HashSet newEntities = new HashSet();
        finalNluEntities.sort(Comparator.comparingLong(ResolverEntity::getStart));
        finalNluEntities.forEach(e -> {
            if (containerEntities.contains(e) && ((Optional)resolutionSetToLexicalMap.get(e)).isPresent()) {
                ResolverEntity entity;
                String matchText = (String)((Optional)resolutionSetToLexicalMap.get(e)).get();
                long start = e.getStart();
                long end = e.getEnd();
                List entitiesToCheck = copyColumns.subList(copyColumns.indexOf(e), copyColumns.size());
                Iterator iterator = entitiesToCheck.iterator();
                while (iterator.hasNext() && matchText.contains((entity = (ResolverEntity)iterator.next()).getText().toLowerCase()) && entity.getEnd() >= end) {
                    end = entity.getEnd();
                }
                ResolverEntity newEntity = new ResolverEntity(new Entity("column", matchText, start, end, e.getEntity().getExtractor()));
                if (newEntity.equals(e)) {
                    newEntities.add(e);
                } else {
                    if (newEntities.add(newEntity)) {
                        List<EntityResolution> candidates = context.getEntityCandidateMap().getOrDefault(e, Collections.emptyList());
                        candidates.forEach(c -> c.setNluEntity(newEntity));
                        context.getEntityCandidateMap().put(newEntity, candidates);
                    }
                    context.getEntityCandidateMap().remove(e);
                }
            } else if (((Optional)resolutionSetToLexicalMap.get(e)).isPresent() || newEntities.stream().noneMatch(ent -> ent.getStart() <= e.getStart() && ent.getEnd() >= e.getEnd())) {
                newEntities.add(e);
            }
        });
        newEntities.addAll(context.getNluEntities().stream().filter(e -> !columns.contains(e) && !containedModifiers.contains(e)).collect(Collectors.toList()));
        context.getNluEntities().clear();
        context.getNluEntities().addAll(newEntities);
        context.getNluEntities().sort(Comparator.comparingLong(ResolverEntity::getStart));
        context.getEntityCandidateMap().keySet().removeIf(resolverEntity -> !newEntities.contains(resolverEntity));
    }

    private boolean canSwallow(String matchText, String columnText, String sentence) {
        int index = matchText.indexOf(columnText);
        if (index == -1) {
            return false;
        }
        return sentence.contains(matchText.substring(0, Math.min(matchText.length(), columnText.length() + index)));
    }

    private ResolutionContext combineSplitColumnEntities(ResolutionContext context) {
        this.combineSplitColumnWithLexicalMatch(context, context.getSearchableEntities());
        List<ResolverEntity> columns = this.getTrueColumns(context);
        Map<Set, List<ResolverEntity>> resolutionSetToEntityMap = columns.stream().collect(Collectors.groupingBy(e -> context.getEntityCandidateMap().getOrDefault(e, Collections.emptyList()).stream().filter(c -> c.getMatchedFeature().getFeatureType() == FeatureType.COLUMN_NAME).map(h -> h.getMatchedFeature().getFeature().getIdForExpression()).collect(Collectors.toSet())));
        ArrayList<ResolverEntity> processedNluEntities = new ArrayList<ResolverEntity>();
        for (Map.Entry<Set, List<ResolverEntity>> entry : resolutionSetToEntityMap.entrySet()) {
            List<ResolverEntity> combinable = entry.getValue();
            if (combinable.size() > 1) {
                Optional<ResolverEntity> headOpt = combinable.stream().min(Comparator.comparingLong(ResolverEntity::getStart));
                if (!headOpt.isPresent()) continue;
                ResolverEntity head = headOpt.get();
                String sentence = context.getSentence();
                combinable.sort(Comparator.comparingLong(ResolverEntity::getStart));
                String combinedEntity = sentence.substring((int)combinable.get(0).getStart(), (int)combinable.get(combinable.size() - 1).getEnd());
                if (context.getEntityCandidateMap().getOrDefault(head, Collections.emptyList()).stream().filter(m -> m.getMatchedFeature().getFeatureType().equals((Object)FeatureType.COLUMN_NAME) && (m.getMatchReason().equals((Object)MatchReason.PARTIAL_NAME) || m.getMatchReason().equals((Object)MatchReason.FULL))).anyMatch(f -> f.getMatchedFeature().getFeature().getFeatureKeyLC().contains(combinedEntity.toLowerCase()))) {
                    combinable.remove(head);
                    processedNluEntities.add(head);
                    combinable.forEach(e -> {
                        if (!e.getText().equals(head.getText())) {
                            context.getEntityCandidateMap().remove(e);
                            context.getEntityPositionMap().remove(e);
                        } else {
                            processedNluEntities.add((ResolverEntity)e);
                        }
                    });
                    continue;
                }
                processedNluEntities.addAll(combinable);
                continue;
            }
            processedNluEntities.add(entry.getValue().get(0));
        }
        processedNluEntities.addAll(context.getNluEntities().stream().filter(e -> !columns.contains(e)).collect(Collectors.toList()));
        context.getNluEntities().clear();
        context.getNluEntities().addAll(processedNluEntities);
        context.getNluEntities().sort(Comparator.comparingLong(ResolverEntity::getStart));
        return context;
    }

    private ResolutionContext combineSimilarFilterEntities(ResolutionContext context) {
        HashMap<ResolverEntity, Set<EntityResolution>> filterTopCandidatesMap = new HashMap<ResolverEntity, Set<EntityResolution>>();
        HashMap filterTopConfidenceMap = new HashMap();
        HashMap<ResolverEntity, List<ResolverEntity>> filterCombinationMap = new HashMap<ResolverEntity, List<ResolverEntity>>();
        Function<List, Optional> getTopCandidate = resolutions -> resolutions.stream().filter(r -> r.getMatchReason() == MatchReason.DATA_VALUE && r.getMatchedFeature().getFeatureType() == FeatureType.COLUMN_NAME).max(Comparator.comparingDouble(EntityResolution::getMatchConfidence));
        BiFunction<List, Double, List> getCandidatesWithScore = (resolutions, score) -> resolutions.stream().filter(r -> r.getMatchReason() == MatchReason.DATA_VALUE && r.getMatchedFeature().getFeatureType() == FeatureType.COLUMN_NAME && Double.compare(r.getMatchConfidence(), score) == 0).collect(Collectors.toList());
        List filters = context.getSearchableEntities().stream().filter(e -> {
            List candidates = context.getEntityCandidateMap().getOrDefault(e, Collections.emptyList());
            Optional topCandidateOpt = (Optional)getTopCandidate.apply(candidates);
            if (topCandidateOpt.isPresent()) {
                EntityResolution topCandidate = (EntityResolution)topCandidateOpt.get();
                if (this.isFilterEntity(context, (ResolverEntity)e, topCandidate)) {
                    filterTopConfidenceMap.put(e, topCandidate.getMatchConfidence());
                    return true;
                }
                return false;
            }
            return e.getType() == EntityType.FILTER;
        }).collect(Collectors.toList());
        for (ResolverEntity filter2 : filters) {
            List candidates = context.getEntityCandidateMap().getOrDefault(filter2, Collections.emptyList());
            HashSet set = new HashSet(getCandidatesWithScore.apply(candidates, filterTopConfidenceMap.getOrDefault(filter2, 0.0)));
            filterTopCandidatesMap.put(filter2, set);
        }
        List sortedFilters = filterTopCandidatesMap.keySet().stream().sorted(Comparator.comparingDouble(filter -> filterTopConfidenceMap.getOrDefault(filter, 0.0)).thenComparing(filter -> filterTopCandidatesMap.getOrDefault(filter, Collections.emptySet()).size()).reversed()).collect(Collectors.toList());
        HashSet<ResolverEntity> resolved = new HashSet<ResolverEntity>();
        for (int i = 0; i < sortedFilters.size(); ++i) {
            ResolverEntity filter1 = (ResolverEntity)filters.get(i);
            if (resolved.contains(filter1)) continue;
            resolved.add(filter1);
            Set resolutions2 = filterTopCandidatesMap.getOrDefault(filter1, Collections.emptySet());
            List equivalencyList = filterCombinationMap.computeIfAbsent(filter1, k -> new ArrayList());
            for (int j = i + 1; j < sortedFilters.size(); ++j) {
                ResolverEntity filter2 = (ResolverEntity)filters.get(j);
                Set resolutions22 = filterTopCandidatesMap.getOrDefault(filter2, Collections.emptySet()).stream().map(r -> r.getMatchedFeature().getFeature().getIdForExpression()).collect(Collectors.toSet());
                Set common = resolutions2.stream().filter(r -> resolutions22.contains(r.getMatchedFeature().getFeature().getIdForExpression())).collect(Collectors.toSet());
                if (common.isEmpty()) continue;
                equivalencyList.add(filter2);
                resolved.add(filter2);
                resolutions2 = common;
                filterTopCandidatesMap.remove(filter2);
            }
            filterTopCandidatesMap.put(filter1, resolutions2);
        }
        context.setFilterCombinationMap(filterCombinationMap);
        context.setFilterResolutionMap(filterTopCandidatesMap);
        return context;
    }

    private List<ResolutionContext> preProcessContext(ResolutionContext initialContext) {
        ArrayList<ResolutionContext> contexts = new ArrayList<ResolutionContext>();
        this.combineSplitColumnEntities(initialContext);
        this.combineSimilarFilterEntities(initialContext);
        initialContext.buildEntityPositionMap();
        contexts.add(initialContext);
        return contexts;
    }

    private List<SentenceResolution> resolveContext(ResolutionContext context) {
        ArrayList<SentenceResolution> resolutions = new ArrayList<SentenceResolution>();
        List<ResolutionContext> contexts = this.preProcessContext(context);
        contexts.forEach(aContext -> {
            ModifierExpressionAssociator.doBuildExpressions(aContext);
            ModifierExpressionAssociator.doModifierAssociation(aContext);
            resolutions.add(this.processResolutionContext((ResolutionContext)aContext));
        });
        return resolutions;
    }

    private Map<String, ResolutionContext> doInitialSearch(Locale locale, String moduleId, String sentence, List<ResolverEntity> nluEntities, Supplier<JoinGraph> joinGraphSupplier) {
        ResolutionContext globalContext = new ResolutionContext(locale, moduleId, sentence, nluEntities, null);
        this.doColumnSearch(globalContext);
        LinkedHashMap<String, List> moduleEntityResolutions = new LinkedHashMap<String, List>();
        globalContext.getEntityCandidateMap().values().forEach(candidates -> {
            for (EntityResolution candidate : candidates) {
                List list = moduleEntityResolutions.computeIfAbsent(candidate.getModuleId(), k -> new ArrayList());
                list.add(candidate);
            }
        });
        ArrayList contexts = new ArrayList();
        moduleEntityResolutions.forEach((module, resolutions) -> {
            Map<ResolverEntity, List<EntityResolution>> entityCandidateMap = resolutions.stream().collect(Collectors.groupingBy(EntityResolution::getNluEntity));
            ResolutionContext context = new ResolutionContext(locale, (String)module, sentence, nluEntities, Objects.equals(module, moduleId) ? (JoinGraph)joinGraphSupplier.get() : null);
            context.addEntityCandidateResolutions(entityCandidateMap);
            context.setEntityConstraintMap(globalContext.getEntityConstraintMap());
            contexts.add(context);
        });
        return contexts.stream().collect(Collectors.toMap(ResolutionContext::getModule, Function.identity(), (r1, r2) -> r1, LinkedHashMap::new));
    }

    private static String findLongestCommonSubString(String entityText, String matchText) {
        int j;
        int i;
        int[][] dp = new int[entityText.length() + 1][matchText.length() + 1];
        int maxLength = 0;
        int end1 = 0;
        int end2 = 0;
        for (i = 1; i <= entityText.length(); ++i) {
            for (j = 1; j <= matchText.length(); ++j) {
                if (entityText.charAt(i - 1) == matchText.charAt(j - 1)) {
                    dp[i][j] = dp[i - 1][j - 1] + 1;
                    if (dp[i][j] <= maxLength) continue;
                    maxLength = dp[i][j];
                    end1 = i;
                    end2 = j;
                    continue;
                }
                dp[i][j] = 0;
            }
        }
        if (end1 > 0 && end2 > 0) {
            i = end1;
            for (j = end2; i > 0 && j > 0 && dp[i][j] > 0; --i, --j) {
            }
            return entityText.substring(i, end1);
        }
        return null;
    }

    private List<EntityResolution> collectPartialMatches(ResolutionContext context, ResolverEntity entity) {
        boolean hasFullMatch = false;
        ArrayList<EntityResolution> candidateResolutions = new ArrayList<EntityResolution>();
        for (EntityResolution resolution : context.getEntityCandidateMap().getOrDefault(entity, Collections.emptyList())) {
            if (resolution.getMatchReason() == MatchReason.FULL) {
                hasFullMatch = true;
                break;
            }
            if (resolution.getMatchedFeature().getFeatureType() != FeatureType.COLUMN_NAME || resolution.getMatchReason() != MatchReason.PARTIAL_NAME) continue;
            candidateResolutions.add(resolution);
        }
        if (hasFullMatch) {
            return Collections.emptyList();
        }
        return candidateResolutions;
    }

    private Pair<ResolverEntity, ResolverEntity> splitPartialEntity(ResolutionContext context, ResolverEntity entity, EntityResolution partial) {
        String matchTextLC = partial.getMatchedFeature().getFeature().getFeatureKeyLC();
        String entityTextLC = entity.getText().toLowerCase();
        if (matchTextLC.replaceAll(" ", "").equals(entityTextLC.replaceAll(" ", ""))) {
            return null;
        }
        String lcs = NluResolver.findLongestCommonSubString(entityTextLC, matchTextLC);
        if (lcs != null) {
            int index = entityTextLC.indexOf(lcs);
            if (index > 0) {
                String splitEntityText = entityTextLC.substring(0, index).trim();
                ResolverEntity counterPartSplit = new ResolverEntity(new Entity(entity.getEntity().getId(), splitEntityText, entity.getStart(), entity.getStart() + (long)splitEntityText.length(), entity.getEntity().getExtractor()));
                return new Pair<ResolverEntity, ResolverEntity>(entity, counterPartSplit);
            }
            if (index == 0) {
                String sentenceLC = context.getSentence().toLowerCase();
                int startIndex = sentenceLC.indexOf(lcs) + lcs.length();
                String splitEntityText = entityTextLC.substring(lcs.length()).trim();
                ResolverEntity counterPartSplit = new ResolverEntity(new Entity(entity.getEntity().getId(), splitEntityText, (long)startIndex, (long)(startIndex + splitEntityText.length()), entity.getEntity().getExtractor()));
                return new Pair<ResolverEntity, ResolverEntity>(entity, counterPartSplit);
            }
        }
        return null;
    }

    private List<SentenceResolution> doCompleteResolution(ResolutionContext context) {
        context.getSearchableEntities().forEach(e -> {
            List<EntityResolution> partialMatches = this.collectPartialMatches(context, (ResolverEntity)e);
            partialMatches.forEach(p -> {
                Pair<ResolverEntity, ResolverEntity> splitPair = this.splitPartialEntity(context, (ResolverEntity)e, (EntityResolution)p);
                if (splitPair != null) {
                    List splits = context.getEntityToFilterSplitCandidates().computeIfAbsent(splitPair.getLeft(), k -> new ArrayList());
                    splits.add(new Pair<EntityResolution, ResolverEntity>((EntityResolution)p, splitPair.getRight()));
                }
            });
        });
        ArrayList<ResolverEntity> searchableEntities = new ArrayList<ResolverEntity>(context.getSearchableEntities());
        searchableEntities.addAll(context.getEntityToFilterSplitCandidates().values().stream().flatMap(list -> list.stream().map(Pair::getRight)).distinct().collect(Collectors.toList()));
        if (NluResolver.isMultipleSearchableEntity(searchableEntities.stream().map(ResolverEntity::getEntity).collect(Collectors.toList()))) {
            this.doFilterSearch(context, searchableEntities);
        }
        return this.resolveContext(context);
    }

    public Optional<SentenceResolution> resolveLocal(Locale locale, String moduleId, String sentence, List<ResolverEntity> nluEntities, JoinGraph joinGraph) {
        ResolutionContext initialContext = new ResolutionContext(locale, moduleId, sentence, nluEntities, joinGraph);
        this.doSearch(initialContext);
        List<SentenceResolution> resolutions = this.resolveContext(initialContext);
        return resolutions.stream().min(Comparator.comparingInt(r -> r.getUnresolved().size()).thenComparing(SentenceResolution::getConfidence));
    }

    private Optional<SentenceResolution> getOptimalSolution(List<SentenceResolution> resolutions) {
        return resolutions.stream().min(Comparator.comparingInt(r -> r.getUnresolved().size()).thenComparing(SentenceResolution::getConfidence));
    }

    private Optional<SentenceResolution> findOptimalSolution(Locale locale, String moduleId, String sentence, List<ResolverEntity> nluEntities, Map<String, ResolutionContext> contextResolutionsMap, Supplier<JoinGraph> joinGraphSupplier) {
        boolean performSearch = true;
        Optional<ResolutionContext> specificContextOpt = Optional.ofNullable(contextResolutionsMap.get(moduleId));
        if (specificContextOpt.isPresent()) {
            boolean bl = performSearch = !this.getUnknowns(specificContextOpt.get()).isEmpty();
        }
        if (performSearch) {
            contextResolutionsMap.putAll(this.doInitialSearch(locale, moduleId, sentence, nluEntities, joinGraphSupplier));
            specificContextOpt = Optional.ofNullable(contextResolutionsMap.get(moduleId));
        }
        Optional<SentenceResolution> optimalSolutionOpt = Optional.empty();
        if (specificContextOpt.isPresent()) {
            optimalSolutionOpt = this.getOptimalSolution(this.doCompleteResolution(specificContextOpt.get()));
        }
        return optimalSolutionOpt;
    }

    private UnResolvedEntity mapDroppedEntities(Entity entity) {
        return new UnResolvedEntity(entity, entity, null, UnResolvedReason.DROPPED_ENTITY);
    }
}

