/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.resolver;

import com.ibm.bi.platform.moser.common.utils.JoinGraph;
import com.ibm.smarts.nlu.resolver.internal.resolver.BaseResolutionContext;
import com.ibm.smarts.nlu.resolver.internal.utils.Pair;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityResolution;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityType;
import com.ibm.smarts.nlu.resolver.resolution.entity.ResolverEntity;
import com.ibm.smarts.nlu.resolver.schema.resolution.entity.constraint.Constraint;
import com.ibm.smarts.schema.FeatureType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ResolutionContext
extends BaseResolutionContext {
    private final String module;
    private Map<ResolverEntity, EntityResolution> entityResolutionMap;
    private Map<ResolverEntity, List<Constraint>> entityConstraintMap = new HashMap<ResolverEntity, List<Constraint>>();
    private List<ResolverEntity> droppedEntities = new ArrayList<ResolverEntity>();
    protected final List<ResolverEntity> nluEntities = new ArrayList<ResolverEntity>();
    protected final Map<ResolverEntity, List<EntityResolution>> entityCandidateMap = new HashMap<ResolverEntity, List<EntityResolution>>();
    private Map<ResolverEntity, Integer> entityPositionMap = new HashMap<ResolverEntity, Integer>();
    private final List<ResolverEntity> unsupportedEntities = new ArrayList<ResolverEntity>();
    private Map<ResolverEntity, List<ResolverEntity>> filterCombinationMap = new HashMap<ResolverEntity, List<ResolverEntity>>();
    private Map<ResolverEntity, Set<EntityResolution>> filterResolutionMap = new HashMap<ResolverEntity, Set<EntityResolution>>();
    private Map<ResolverEntity, List<Pair<EntityResolution, ResolverEntity>>> entityToFilterSplitCandidates = new HashMap<ResolverEntity, List<Pair<EntityResolution, ResolverEntity>>>();

    public void buildEntityPositionMap() {
        this.entityPositionMap.clear();
        this.nluEntities.sort(Comparator.comparingLong(ResolverEntity::getStart));
        IntStream.range(0, this.nluEntities.size()).forEach(pos -> this.entityPositionMap.put(this.nluEntities.get(pos), pos));
    }

    public ResolutionContext(Locale locale, String module, String sentence, List<ResolverEntity> nluEntities, JoinGraph joinGraph) {
        super(locale, sentence, joinGraph);
        this.module = module;
        this.nluEntities.addAll(nluEntities.stream().filter(n -> !n.getType().equals((Object)EntityType.UNKNOWN)).collect(Collectors.toList()));
        this.buildEntityPositionMap();
    }

    List<EntityResolution> getColumnEntityResolutions(ResolverEntity entity) {
        return this.entityCandidateMap.getOrDefault(entity, Collections.emptyList()).stream().filter(r -> r.getType().equals((Object)FeatureType.COLUMN_NAME)).collect(Collectors.toList());
    }

    public String getModule() {
        return this.module;
    }

    public Map<ResolverEntity, EntityResolution> getEntityResolutionMap() {
        return this.entityResolutionMap;
    }

    public void setEntityResolutionMap(Map<ResolverEntity, EntityResolution> entityResolutionMap) {
        this.entityResolutionMap = entityResolutionMap;
    }

    void addConstraint(ResolverEntity entity, Constraint constraint) {
        List constraints = this.entityConstraintMap.computeIfAbsent(entity, k -> new ArrayList());
        constraints.add(constraint);
    }

    public List<Constraint> getConstraints(ResolverEntity entity) {
        return this.entityConstraintMap.getOrDefault(entity, Collections.emptyList());
    }

    Map<ResolverEntity, List<Constraint>> getEntityConstraintMap() {
        return this.entityConstraintMap;
    }

    void setEntityConstraintMap(Map<ResolverEntity, List<Constraint>> entityConstraintMap) {
        entityConstraintMap.forEach((entity, constraints) -> {
            List cfr_ignored_0 = this.entityConstraintMap.put((ResolverEntity)entity, new ArrayList(constraints));
        });
    }

    public Map<ResolverEntity, List<ResolverEntity>> getFilterCombinationMap() {
        return this.filterCombinationMap;
    }

    void setFilterCombinationMap(Map<ResolverEntity, List<ResolverEntity>> filterCombinationMap) {
        this.filterCombinationMap = filterCombinationMap;
    }

    public Map<ResolverEntity, Set<EntityResolution>> getFilterResolutionMap() {
        return this.filterResolutionMap;
    }

    public void setFilterResolutionMap(Map<ResolverEntity, Set<EntityResolution>> filterResolutionMap) {
        this.filterResolutionMap = filterResolutionMap;
    }

    public void addDroppedEntity(ResolverEntity unresolved) {
        this.droppedEntities.add(unresolved);
    }

    public List<ResolverEntity> getDroppedEntities() {
        return this.droppedEntities;
    }

    public List<ResolverEntity> getNluEntities() {
        return this.nluEntities;
    }

    public Map<ResolverEntity, List<EntityResolution>> getEntityCandidateMap() {
        return this.entityCandidateMap;
    }

    public List<ResolverEntity> getSearchableEntities() {
        return this.nluEntities.stream().filter(e -> e.getType().equals((Object)EntityType.COLUMN) || e.getType().equals((Object)EntityType.FILTER)).sorted(Comparator.comparingLong(ResolverEntity::getStart)).collect(Collectors.toList());
    }

    public void addEntityResolution(ResolverEntity nluEntity, EntityResolution match) {
        List resolutions = this.entityCandidateMap.computeIfAbsent(nluEntity, e -> new ArrayList());
        resolutions.add(match);
    }

    public void addEntityCandidateResolutions(ResolverEntity entity, List<EntityResolution> matches) {
        List resolutions = this.entityCandidateMap.computeIfAbsent(entity, e -> new ArrayList());
        resolutions.addAll(matches);
    }

    public void addEntityCandidateResolutions(Map<ResolverEntity, List<EntityResolution>> entityCandidateMap) {
        this.entityCandidateMap.putAll(entityCandidateMap);
    }

    int getEntityPosition(ResolverEntity entity) {
        return this.entityPositionMap.get(entity);
    }

    public Map<ResolverEntity, Integer> getEntityPositionMap() {
        return this.entityPositionMap;
    }

    public void setEntityPositionMap(Map<ResolverEntity, Integer> entityPositionMap) {
        this.entityPositionMap = entityPositionMap;
    }

    void setNluEntities(List<ResolverEntity> nluEntities) {
        this.nluEntities.clear();
        this.nluEntities.addAll(nluEntities);
        this.buildEntityPositionMap();
    }

    public List<ResolverEntity> getUnsupportedEntities() {
        return this.unsupportedEntities;
    }

    public Map<ResolverEntity, List<Pair<EntityResolution, ResolverEntity>>> getEntityToFilterSplitCandidates() {
        return this.entityToFilterSplitCandidates;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolutionContext)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResolutionContext context = (ResolutionContext)o;
        return Objects.equals(this.getModule(), context.getModule()) && Objects.equals(this.getEntityResolutionMap(), context.getEntityResolutionMap()) && Objects.equals(this.getEntityConstraintMap(), context.getEntityConstraintMap()) && Objects.equals(this.getFilterCombinationMap(), context.getFilterCombinationMap()) && Objects.equals(this.getDroppedEntities(), context.getDroppedEntities()) && Objects.equals(this.getNluEntities(), context.getNluEntities()) && Objects.equals(this.getEntityCandidateMap(), context.getEntityCandidateMap()) && Objects.equals(this.getEntityPositionMap(), context.getEntityPositionMap()) && Objects.equals(this.getUnsupportedEntities(), context.getUnsupportedEntities());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getModule(), this.getEntityResolutionMap(), this.getEntityConstraintMap(), this.getFilterCombinationMap(), this.getDroppedEntities(), this.getNluEntities(), this.getEntityCandidateMap(), this.getEntityPositionMap(), this.getUnsupportedEntities());
    }

    @Override
    public String toString() {
        return "ResolutionContext{module='" + this.module + '\'' + ", entityResolutionMap=" + this.entityResolutionMap + ", entityConstraintMap=" + this.entityConstraintMap + ", filterCombinationMap=" + this.filterCombinationMap + ", droppedEntities=" + this.droppedEntities + ", nluEntities=" + this.nluEntities + ", entityCandidateMap=" + this.entityCandidateMap + ", entityPositionMap=" + this.entityPositionMap + ", unsupportedEntities=" + this.unsupportedEntities + '}';
    }
}

