/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.resolver.strategies;

import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.internal.resolver.strategies.IConstraintSatisfactionStrategy;
import com.ibm.smarts.nlu.resolver.internal.utils.ResolverUtil;
import com.ibm.smarts.nlu.resolver.resolution.entity.ResolverEntity;
import com.ibm.smarts.nlu.resolver.schema.IRequestConfig;
import com.ibm.smarts.nlu.resolver.schema.IUnknownEntityResolver;
import com.ibm.smarts.nlu.resolver.schema.UnknownEntityResponse;
import java.util.List;
import java.util.stream.Collectors;

public class ReplaceUnknownsStrategy
implements IConstraintSatisfactionStrategy {
    private IUnknownEntityResolver unknownEntityResolver;

    public ReplaceUnknownsStrategy(IUnknownEntityResolver unknownEntityResolver) {
        this.unknownEntityResolver = unknownEntityResolver;
    }

    @Override
    public ResolutionContext apply(ResolutionContext context, IRequestConfig requestConfig, List<ResolverEntity> unknowns, List<ResolverEntity> columns, List<ResolverEntity> filters) {
        UnknownEntityResponse response = ResolverUtil.doReplaceUnknowns(this.unknownEntityResolver, unknowns, context.getSentence(), requestConfig);
        if (response != null) {
            List<ResolverEntity> newResolverEntities = response.getNewEntities().stream().map(ResolverEntity::new).collect(Collectors.toList());
            return new ResolutionContext(context.getLocale(), context.getModule(), response.getNewSentence(), newResolverEntities, context.getJoinGraph());
        }
        return context;
    }
}

