/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.utils.graph;

import com.ibm.smarts.nlu.resolver.internal.utils.graph.Edge;
import com.ibm.smarts.nlu.resolver.internal.utils.graph.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Graph<T> {
    private List<Node<T>> nodes = new ArrayList<Node<T>>();
    private List<List<Edge>> adjacencyLists = new ArrayList<List<Edge>>();
    private Map<T, Integer> dataToVertexMap = new HashMap<T, Integer>();
    private Map<Integer, Node<T>> vertexToNodeMap = new HashMap<Integer, Node<T>>();
    private Set<String> nodeGroupSet = new HashSet<String>();
    private Map<String, List<Node<T>>> groupToNodeMap = new HashMap<String, List<Node<T>>>();
    private static final int MAX_PATH_DISCOVERY = 250;

    public void addNode(Node<T> node) {
        int vertex = this.nodes.size();
        this.dataToVertexMap.put(node.getData(), vertex);
        this.vertexToNodeMap.put(vertex, node);
        this.nodes.add(node);
        this.adjacencyLists.add(new ArrayList());
        this.nodeGroupSet.add(node.getGroupId());
        List listOfNodes = this.groupToNodeMap.computeIfAbsent(node.getGroupId(), id -> new ArrayList());
        listOfNodes.add(node);
    }

    public void addNodes(List<Node<T>> nodes) {
        nodes.forEach(this::addNode);
    }

    public void addEdge(Edge edge) {
        this.adjacencyLists.get(edge.getSource()).add(edge);
    }

    public void addEdge(int source, int destination, double sourceWeight, double destinationWeight) {
        this.addEdge(new Edge(source, destination, sourceWeight, destinationWeight));
    }

    public int getVertex(T data) {
        return this.dataToVertexMap.get(data);
    }

    private void dfs(Set<String> visited, List<Edge> bestSolution, IntRef minWeight, List<Edge> path, int source, int count) {
        if (path.size() == this.nodeGroupSet.size() || count <= 0) {
            return;
        }
        for (Edge edge : this.adjacencyLists.get(source)) {
            path.add(edge);
            this.dfs(visited, bestSolution, minWeight, path, edge.getDestination(), --count);
            if (path.size() == this.nodeGroupSet.size() - 1) {
                double weight = 0.0;
                if (path.size() == 1) {
                    weight += path.get(0).getSourceWeight() + path.get(0).getDestinationWeight();
                } else {
                    for (int i = 0; i < path.size(); ++i) {
                        if (i == path.size() - 1) {
                            weight += path.get(i).getDestinationWeight();
                            continue;
                        }
                        weight += path.get(i).getSourceWeight();
                    }
                }
                if (Double.compare(minWeight.weight, weight) > 0) {
                    bestSolution.clear();
                    bestSolution.addAll(path);
                    minWeight.weight = weight;
                }
            }
            if (count <= 0) {
                return;
            }
            path.remove(edge);
        }
    }

    public List<T> findBestPath() {
        ArrayList<Edge> solution = new ArrayList<Edge>();
        ArrayList<Edge> bestSolution = new ArrayList<Edge>();
        IntRef minWeight = new IntRef();
        if (this.adjacencyLists.isEmpty()) {
            return Collections.emptyList();
        }
        String firstGroupId = this.nodes.get(0).getGroupId();
        List startNodes = this.nodes.stream().filter(n -> n.getGroupId().equals(firstGroupId)).collect(Collectors.toList());
        for (Node node : startNodes) {
            this.dfs(new HashSet<String>(), bestSolution, minWeight, solution, this.getVertex(node.getData()), 250);
        }
        return bestSolution.stream().flatMap(e -> Stream.of(e.getSource(), e.getDestination())).distinct().map(vertex -> this.vertexToNodeMap.get(vertex).getData()).collect(Collectors.toList());
    }

    static class IntRef {
        double weight = Double.MAX_VALUE;

        IntRef() {
        }
    }
}

