/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.utils.graph;

import java.util.Objects;

public class Node<T> {
    private final String groupId;
    private final String id;
    private final T data;
    private final double weight;

    public Node(String groupId, String id, T data, double weight) {
        this.groupId = groupId;
        this.id = id;
        this.data = data;
        this.weight = weight;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getId() {
        return this.id;
    }

    public T getData() {
        return this.data;
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node node = (Node)o;
        return Double.compare(node.getWeight(), this.getWeight()) == 0 && Objects.equals(this.getGroupId(), node.getGroupId()) && Objects.equals(this.getId(), node.getId()) && Objects.equals(this.getData(), node.getData());
    }

    public int hashCode() {
        return Objects.hash(this.getGroupId(), this.getId(), this.getData(), this.getWeight());
    }

    public String toString() {
        return "Node{groupId='" + this.groupId + '\'' + ", id='" + this.id + '\'' + ", data=" + this.data + ", weight=" + this.weight + '}';
    }
}

