/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.internal.utils.mst;

import com.ibm.smarts.nlu.resolver.internal.utils.mst.Edge;
import com.ibm.smarts.nlu.resolver.internal.utils.mst.GraphException;
import com.ibm.smarts.nlu.resolver.internal.utils.mst.GraphInvalidEdgeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.stream.Collectors;

public class Graph<T, E> {
    private final List<T> nodes = new ArrayList<T>();
    private final List<List<Edge<E>>> adjacencyList;
    private final Map<T, Integer> nodeToVertexMap;

    public Graph(List<T> nodes) {
        int i;
        this.nodes.addAll(nodes);
        this.adjacencyList = new ArrayList<List<Edge<E>>>(nodes.size());
        for (i = 0; i < nodes.size(); ++i) {
            this.adjacencyList.add(new ArrayList());
        }
        this.nodeToVertexMap = new HashMap<T, Integer>();
        for (i = 0; i < nodes.size(); ++i) {
            this.nodeToVertexMap.put(nodes.get(i), i);
        }
    }

    public void addEdge(Edge edge) throws GraphException {
        if (edge.getSource() >= this.nodes.size() || edge.getDestination() >= this.nodes.size()) {
            throw new GraphInvalidEdgeException(edge);
        }
        this.adjacencyList.get(edge.getSource()).add(edge);
    }

    public void addEdge(T n1, T n2, E data, double weight) throws GraphException {
        int v = this.nodeToVertexMap.getOrDefault(n1, Integer.MAX_VALUE);
        int w = this.nodeToVertexMap.getOrDefault(n2, Integer.MAX_VALUE);
        Edge<E> edge = new Edge<E>(v, w, data, weight);
        this.addEdge(edge);
        edge = new Edge<E>(w, v, data, weight);
        this.addEdge(edge);
    }

    public List<Edge<E>> getAdjacencyList(int node) {
        if (node >= this.adjacencyList.size()) {
            return Collections.emptyList();
        }
        return this.adjacencyList.get(node);
    }

    public List<Edge<E>> getMST() {
        boolean[] visited = new boolean[this.nodes.size()];
        ArrayList mstNodes = new ArrayList(this.nodes.size());
        for (int i = 0; i < this.nodes.size(); ++i) {
            MstNode node = new MstNode(i);
            mstNodes.add(node);
        }
        ((MstNode)mstNodes.get(0)).setWeight(0.0);
        PriorityQueue queue = new PriorityQueue();
        for (int i = 0; i < this.nodes.size(); ++i) {
            queue.add(mstNodes.get(i));
        }
        while (!queue.isEmpty()) {
            MstNode node = (MstNode)queue.poll();
            int vertex = node.getVertex();
            visited[vertex] = true;
            List<Edge<E>> adj = this.adjacencyList.get(vertex);
            for (Edge<E> edge : adj) {
                if (visited[edge.getDestination()] || !(((MstNode)mstNodes.get(edge.getDestination())).getWeight() > edge.getWeight())) continue;
                ((MstNode)mstNodes.get(edge.getDestination())).setData(edge);
                ((MstNode)mstNodes.get(edge.getDestination())).setWeight(edge.getWeight());
                queue.add(mstNodes.get(edge.getDestination()));
            }
        }
        return mstNodes.stream().map(MstNode::getData).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Graph)) {
            return false;
        }
        Graph graph = (Graph)o;
        return Objects.equals(this.nodes, graph.nodes) && Objects.equals(this.adjacencyList, graph.adjacencyList) && Objects.equals(this.nodeToVertexMap, graph.nodeToVertexMap);
    }

    public int hashCode() {
        return Objects.hash(this.nodes, this.adjacencyList, this.nodeToVertexMap);
    }

    public String toString() {
        return "Graph{nodes=" + this.nodes + ", adjacencyList=" + this.adjacencyList + ", nodeToVertexMap=" + this.nodeToVertexMap + '}';
    }

    private static class MstNode<U>
    implements Comparable<MstNode> {
        private final int vertex;
        private U data;
        private double weight = Double.MAX_VALUE;

        public MstNode(int vertex) {
            this.vertex = vertex;
        }

        public MstNode(int vertex, U data, double weight) {
            this(vertex);
            this.data = data;
            this.weight = weight;
        }

        public void setData(U data) {
            this.data = data;
        }

        public void setWeight(double weight) {
            this.weight = weight;
        }

        public U getData() {
            return this.data;
        }

        public int getVertex() {
            return this.vertex;
        }

        public double getWeight() {
            return this.weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MstNode)) {
                return false;
            }
            MstNode mstNode = (MstNode)o;
            return this.getVertex() == mstNode.getVertex() && Double.compare(mstNode.getWeight(), this.getWeight()) == 0 && Objects.equals(this.getData(), mstNode.getData());
        }

        public int hashCode() {
            return Objects.hash(this.getVertex(), this.getData(), this.getWeight());
        }

        @Override
        public int compareTo(MstNode o) {
            return Double.compare(this.weight, o.weight);
        }
    }
}

