/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.providers.search;

import com.ibm.smarts.conversation.nlu.schema.entity.Entity;
import com.ibm.smarts.nlu.resolver.internal.resolver.ResolutionContext;
import com.ibm.smarts.nlu.resolver.internal.utils.Pair;
import com.ibm.smarts.nlu.resolver.providers.search.ISearchProcessor;
import com.ibm.smarts.nlu.resolver.resolution.entity.EntityResolution;
import com.ibm.smarts.nlu.resolver.resolution.entity.ResolverEntity;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.MatchedEntity;
import com.ibm.smarts.schema.MatchedFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SearchProcessor
implements ISearchProcessor {
    private static final float MAX_CONFIDENCE = 1.0f;
    private static final float FILTER_SPLIT_THRESHOLD = 0.7f;

    private List<ResolverEntity> findNluEntity(List<ResolverEntity> nluEntities, String coveredText, int startCoverText, int endCoverText) {
        return nluEntities.stream().filter(entity -> entity.getText().equals(coveredText) || entity.getStart() <= (long)startCoverText && entity.getEnd() >= (long)endCoverText).distinct().collect(Collectors.toList());
    }

    private List<ResolverEntity> findContainingNluEntity(List<ResolverEntity> nluEntities, String coveredText) {
        return nluEntities.stream().filter(entity -> entity.getText().toLowerCase().contains(coveredText)).distinct().collect(Collectors.toList());
    }

    private boolean splitEntityUsingFilterMatch(ResolutionContext context, MatchedEntity match, List<ResolverEntity> processedEntities) {
        String matchTextLC = match.getCoveredText().toLowerCase();
        List<ResolverEntity> entities = this.findContainingNluEntity(context.getSearchableEntities(), matchTextLC);
        if (!entities.isEmpty() && processedEntities.contains(entities.get(0)) || !match.getMatchedFeatures().isEmpty() && ((MatchedFeature)match.getMatchedFeatures().get(0)).getConfidence() < 0.7f) {
            return false;
        }
        for (ResolverEntity entity : entities) {
            List splitPairs = context.getEntityToFilterSplitCandidates().getOrDefault(entity, Collections.emptyList());
            for (Pair pair : splitPairs) {
                ResolverEntity filterEntity = (ResolverEntity)pair.getRight();
                if (!filterEntity.getText().equalsIgnoreCase(matchTextLC)) continue;
                EntityResolution partialLexicalMatch = (EntityResolution)pair.getLeft();
                String coveredTextLC = entity.getText().toLowerCase();
                int index = coveredTextLC.indexOf(matchTextLC);
                String lexicalCoveredText = null;
                long startOffset = 0L;
                if (index > 0) {
                    lexicalCoveredText = coveredTextLC.substring(0, index).trim();
                    startOffset = entity.getStart();
                } else if (index == 0) {
                    lexicalCoveredText = coveredTextLC.substring(matchTextLC.length()).trim();
                    startOffset = entity.getStart() + (long)matchTextLC.length();
                }
                if (lexicalCoveredText == null) continue;
                ResolverEntity lexicalEntity = new ResolverEntity(new Entity(entity.getEntity().getId(), lexicalCoveredText, startOffset, startOffset + (long)lexicalCoveredText.length(), entity.getEntity().getExtractor()));
                context.getEntityCandidateMap().remove(entity);
                List lexicalResolutions = context.getEntityCandidateMap().computeIfAbsent(lexicalEntity, k -> new ArrayList());
                lexicalResolutions.add(partialLexicalMatch);
                partialLexicalMatch.setNluEntity(lexicalEntity);
                List filterResolutions = context.getEntityCandidateMap().computeIfAbsent(filterEntity, k -> new ArrayList());
                filterResolutions.addAll(match.getMatchedFeatures().stream().map(f -> new EntityResolution(filterEntity, (MatchedFeature)f)).collect(Collectors.toList()));
                context.getNluEntities().remove(entity);
                if (filterResolutions.stream().map(r -> r.getMatchedFeature().getFeature().getIdForExpression().toLowerCase()).noneMatch(f -> f.contains(lexicalEntity.getText().toLowerCase()))) {
                    context.getNluEntities().add(lexicalEntity);
                }
                context.getNluEntities().add(filterEntity);
                context.buildEntityPositionMap();
                return true;
            }
        }
        return false;
    }

    @Override
    public void accept(List<MatchedEntity> matchedEntities, ResolutionContext context) {
        List<ResolverEntity> nluEntities = context.getSearchableEntities();
        if (matchedEntities == null) {
            return;
        }
        matchedEntities.sort(Comparator.comparingDouble(m -> {
            Optional<Double> confidence = m.getMatchedFeatures().stream().map(f -> f.getConfidence()).max(Comparator.comparingDouble(d -> d));
            if (confidence.isPresent()) {
                return confidence.get();
            }
            return 0.0;
        }).thenComparing(m -> m.getCoveredText().length()).reversed());
        ArrayList<ResolverEntity> processed = new ArrayList<ResolverEntity>();
        for (MatchedEntity match : matchedEntities) {
            if (this.splitEntityUsingFilterMatch(context, match, processed)) continue;
            String coveredText = match.getCoveredText();
            List<ResolverEntity> entities = this.findNluEntity(nluEntities, coveredText, match.getCharOffsetBegin(), match.getCharOffsetEnd());
            processed.addAll(entities);
            for (ResolverEntity nluEntity : entities) {
                for (MatchedFeature matchedFeature : match.getMatchedFeatures()) {
                    if (matchedFeature.getMatchReason() == MatchReason.DATA_VALUE && matchedFeature.getConfidence() == 1.0f && !nluEntity.getText().equals(coveredText)) {
                        ResolverEntity resolverEntity = new ResolverEntity(new Entity(nluEntity.getEntity().getId(), coveredText, (long)match.getCharOffsetBegin(), (long)match.getCharOffsetEnd(), nluEntity.getEntity().getExtractor()));
                        List currentMatches = context.getEntityCandidateMap().getOrDefault(nluEntity, new ArrayList());
                        currentMatches.forEach(m -> m.setNluEntity(resolverEntity));
                        currentMatches.add(new EntityResolution(nluEntity, matchedFeature));
                        context.getEntityCandidateMap().remove(nluEntity);
                        context.getEntityCandidateMap().put(resolverEntity, currentMatches);
                        context.getNluEntities().remove(nluEntity);
                        context.getNluEntities().add(resolverEntity);
                        continue;
                    }
                    EntityResolution resolution = new EntityResolution(nluEntity, matchedFeature);
                    context.addEntityResolution(nluEntity, resolution);
                }
            }
        }
    }
}

