/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlu.resolver.resolution.entity;

import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.nlu.resolver.internal.processor.ProcessingRules;
import com.ibm.smarts.nlu.resolver.resolution.entity.ResolverEntity;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.FeatureType;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.MatchedFeature;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class EntityResolution {
    private ResolverEntity nluEntity;
    private final MatchedFeature matchedFeature;
    private final String moduleId;
    private final String datasetId;
    private final ColumnInfo colInfo;
    private final MatchReason matchReason;
    private final FeatureType type;
    private double lexicalDistance;
    private final double matchConfidence;
    private double cost;
    private EnumSet<ProcessingRules> applicableRules = EnumSet.noneOf(ProcessingRules.class);

    public EntityResolution(ResolverEntity nluEntity, MatchedFeature match) {
        this.nluEntity = nluEntity;
        this.matchedFeature = match;
        this.moduleId = match.getFeature().getAssetRef();
        this.datasetId = match.getFeature().getDatasetRef();
        this.matchReason = match.getMatchReason();
        this.matchConfidence = match.getConfidence();
        this.type = match.getFeatureType();
        String colInfoJSON = match.getFeature().getColumnInfo();
        this.colInfo = colInfoJSON != null && !colInfoJSON.isEmpty() ? (ColumnInfo)CommonJAXBHelper.unmarshalFromJSON(ColumnInfo.class, (String)colInfoJSON) : null;
    }

    public EntityResolution(ResolverEntity nluEntity, MatchedFeature match, double cost) {
        this(nluEntity, match);
        this.cost = cost;
    }

    public ResolverEntity getNluEntity() {
        return this.nluEntity;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public ColumnInfo getColInfo() {
        return this.colInfo;
    }

    public MatchReason getMatchReason() {
        return this.matchReason;
    }

    public double getMatchConfidence() {
        return this.matchConfidence;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void addRule(ProcessingRules rule) {
        this.applicableRules.add(rule);
    }

    public void removeRules(List<ProcessingRules> rules) {
        this.applicableRules.removeAll(rules);
    }

    public void replaceRule(ProcessingRules oldRule, ProcessingRules newRule) {
        this.applicableRules.remove((Object)oldRule);
        this.applicableRules.add(newRule);
    }

    public void setNluEntity(ResolverEntity nluEntity) {
        this.nluEntity = nluEntity;
    }

    public Set<ProcessingRules> getApplicableRules() {
        return this.applicableRules;
    }

    public FeatureType getType() {
        return this.type;
    }

    public MatchedFeature getMatchedFeature() {
        return this.matchedFeature;
    }

    public double getLexicalDistance() {
        return this.lexicalDistance;
    }

    public void setLexicalDistance(double lexicalDistance) {
        this.lexicalDistance = lexicalDistance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityResolution)) {
            return false;
        }
        EntityResolution that = (EntityResolution)o;
        return Double.compare(that.getLexicalDistance(), this.getLexicalDistance()) == 0 && Double.compare(that.getMatchConfidence(), this.getMatchConfidence()) == 0 && Double.compare(that.getCost(), this.getCost()) == 0 && Objects.equals(this.getNluEntity(), that.getNluEntity()) && Objects.equals(this.getMatchedFeature(), that.getMatchedFeature()) && Objects.equals(this.getModuleId(), that.getModuleId()) && Objects.equals(this.getDatasetId(), that.getDatasetId()) && Objects.equals(this.getColInfo(), that.getColInfo()) && this.getMatchReason() == that.getMatchReason() && this.getType() == that.getType() && Objects.equals(this.getApplicableRules(), that.getApplicableRules());
    }

    public int hashCode() {
        return Objects.hash(this.getNluEntity(), this.getMatchedFeature(), this.getModuleId(), this.getDatasetId(), this.getColInfo(), this.getMatchReason(), this.getType(), this.getLexicalDistance(), this.getMatchConfidence(), this.getCost(), this.getApplicableRules());
    }

    public String toString() {
        return "EntityResolution{ nluEntity=" + this.nluEntity + ", matchedFeature=" + CommonJAXBHelper.marshalToJSON((Object)this.matchedFeature, (boolean)true) + ", moduleId='" + this.moduleId + '\'' + ", datasetId='" + this.datasetId + '\'' + ", colInfo=" + CommonJAXBHelper.marshalToJSON((Object)this.colInfo, (boolean)true) + ", matchReason=" + this.matchReason + ", type=" + this.type + ", lexicalDistance=" + this.lexicalDistance + ", matchConfidence=" + this.matchConfidence + ", cost=" + this.cost + ", applicableRules=" + this.applicableRules + '}';
    }
}

